/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ICommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkSystem;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.profiler.DebugProfiler;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.ScoreboardSaveData;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.CustomServerBossInfoManager;
import net.minecraft.server.ServerEula;
import net.minecraft.server.ServerPropertiesProvider;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.OpEntry;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.WhiteList;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.test.TestCollection;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.WorldOptimizer;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.Bootstrap;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.chunk.listener.LoggingChunkStatusListener;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerMultiWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.CommandStorage;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraft.world.storage.WorldSavedDataCallableSave;
import net.minecraft.world.storage.loot.LootPredicateManager;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.LootModifierManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.BrandingControl;
import net.minecraftforge.fml.StartupQuery;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends RecursiveEventLoop<TickDelayedTask>
implements ISnooperInfo,
ICommandSource,
AutoCloseable,
Runnable {
    private static final Logger field_147145_h = LogManager.getLogger();
    public static final File field_152367_a = new File("usercache.json");
    private static final CompletableFuture<Unit> field_223713_i = CompletableFuture.completedFuture(Unit.INSTANCE);
    public static final WorldSettings field_213219_c = new WorldSettings((long)"North Carolina".hashCode(), GameType.SURVIVAL, true, false, WorldType.field_77137_b).func_77159_a();
    private final SaveFormat field_71310_m;
    private final Snooper field_71307_n = new Snooper("server", (ISnooperInfo)this, Util.func_211177_b());
    private final File field_71308_o;
    private final List<Runnable> field_71322_p = Lists.newArrayList();
    private final DebugProfiler field_71304_b = new DebugProfiler(this::func_71259_af);
    private final NetworkSystem field_147144_o;
    protected final IChunkStatusListenerFactory field_213220_d;
    private final ServerStatusResponse field_147147_p = new ServerStatusResponse();
    private final Random field_147146_q = new Random();
    private final DataFixer field_184112_s;
    private String field_71320_r;
    private int field_71319_s = -1;
    private final Map<DimensionType, ServerWorld> field_71305_c = Maps.newIdentityHashMap();
    private PlayerList field_71318_t;
    private volatile boolean field_71317_u = true;
    private boolean field_71316_v;
    private int field_71315_w;
    protected final Proxy field_110456_c;
    private boolean field_71325_x;
    private boolean field_190519_A;
    private boolean field_71324_y;
    private boolean field_71323_z;
    private boolean field_71284_A;
    private boolean field_71285_B;
    @Nullable
    private String field_71286_C;
    private int field_71280_D;
    private int field_143008_E;
    public final long[] field_71311_j = new long[100];
    @Nullable
    private KeyPair field_71292_I;
    @Nullable
    private String field_71293_J;
    private final String field_71294_K;
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    private String field_71287_L;
    private boolean field_71288_M;
    private boolean field_71289_N;
    private String field_147141_M = "";
    private String field_175588_P = "";
    private volatile boolean field_71296_Q;
    private long field_71299_R;
    @Nullable
    private ITextComponent field_71298_S;
    private boolean field_71295_T;
    private boolean field_104057_T;
    @Nullable
    private final YggdrasilAuthenticationService field_152364_T;
    private final MinecraftSessionService field_147143_S;
    private final GameProfileRepository field_152365_W;
    private final PlayerProfileCache field_152366_X;
    private long field_147142_T;
    protected final Thread field_175590_aa = (Thread)Util.func_200696_a((Object)new Thread((ThreadGroup)SidedThreadGroups.SERVER, this, "Server thread"), p_213187_0_ -> p_213187_0_.setUncaughtExceptionHandler((p_213206_0_, p_213206_1_) -> field_147145_h.error((Object)p_213206_1_)));
    protected long field_211151_aa = Util.func_211177_b();
    private long field_213213_ab;
    private boolean field_213214_ac;
    @OnlyIn(value=Dist.CLIENT)
    private boolean field_184111_ab;
    private final IReloadableResourceManager field_195576_ac = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA, this.field_175590_aa);
    private final ResourcePackList<ResourcePackInfo> field_195577_ad = new ResourcePackList<ResourcePackInfo>(ResourcePackInfo::new);
    @Nullable
    private FolderPackFinder field_195578_ae;
    private final Commands field_195579_af;
    private final RecipeManager field_199530_ag = new RecipeManager();
    private final NetworkTagManager field_199736_ah = new NetworkTagManager();
    private final ServerScoreboard field_200255_ai = new ServerScoreboard(this);
    @Nullable
    private CommandStorage field_229733_al_;
    private final CustomServerBossInfoManager field_201301_aj = new CustomServerBossInfoManager(this);
    private final LootPredicateManager field_229734_an_ = new LootPredicateManager();
    private final LootTableManager field_200256_aj = new LootTableManager(this.field_229734_an_);
    private final AdvancementManager field_200257_ak = new AdvancementManager();
    private final FunctionManager field_200258_al = new FunctionManager(this);
    private final LootModifierManager lootManager = new LootModifierManager();
    private final FrameTimer field_213215_ap = new FrameTimer();
    private boolean field_205745_an;
    private boolean field_212205_ao;
    private boolean field_213216_as;
    private float field_211152_ao;
    private final Executor field_213217_au;
    @Nullable
    private String field_213218_av;
    private Map<DimensionType, long[]> perWorldTickTimes = Maps.newIdentityHashMap();
    private int worldArrayMarker = 0;
    private int worldArrayLast = -1;
    private ServerWorld[] worldArray;

    public MinecraftServer(File p_i50590_1_, Proxy p_i50590_2_, DataFixer dataFixerIn, Commands p_i50590_4_, YggdrasilAuthenticationService p_i50590_5_, MinecraftSessionService p_i50590_6_, GameProfileRepository p_i50590_7_, PlayerProfileCache p_i50590_8_, IChunkStatusListenerFactory p_i50590_9_, String p_i50590_10_) {
        super("Server");
        this.field_110456_c = p_i50590_2_;
        this.field_195579_af = p_i50590_4_;
        this.field_152364_T = p_i50590_5_;
        this.field_147143_S = p_i50590_6_;
        this.field_152365_W = p_i50590_7_;
        this.field_152366_X = p_i50590_8_;
        this.field_71308_o = p_i50590_1_;
        this.field_147144_o = new NetworkSystem(this);
        this.field_213220_d = p_i50590_9_;
        this.field_71310_m = new SaveFormat(p_i50590_1_.toPath(), p_i50590_1_.toPath().resolve("../backups"), dataFixerIn);
        this.field_184112_s = dataFixerIn;
        this.field_195576_ac.func_219534_a((IFutureReloadListener)this.field_199736_ah);
        this.field_195576_ac.func_219534_a((IFutureReloadListener)this.field_229734_an_);
        this.field_195576_ac.func_219534_a((IFutureReloadListener)this.field_199530_ag);
        this.field_195576_ac.func_219534_a((IFutureReloadListener)this.field_200256_aj);
        this.field_195576_ac.func_219534_a((IFutureReloadListener)this.field_200258_al);
        this.field_195576_ac.func_219534_a((IFutureReloadListener)this.field_200257_ak);
        this.field_195576_ac.func_219534_a((IFutureReloadListener)this.lootManager);
        this.field_213217_au = Util.func_215072_e();
        this.field_71294_K = p_i50590_10_;
    }

    private void func_213204_a(DimensionSavedDataManager p_213204_1_) {
        ScoreboardSaveData scoreboardsavedata = p_213204_1_.func_215752_a(ScoreboardSaveData::new, "scoreboard");
        scoreboardsavedata.func_96499_a((Scoreboard)this.func_200251_aP());
        this.func_200251_aP().func_186684_a((Runnable)new WorldSavedDataCallableSave((WorldSavedData)scoreboardsavedata));
    }

    protected abstract boolean func_71197_b() throws IOException;

    protected void func_71237_c(String worldNameIn) {
        if (this.func_71254_M().func_75801_b(worldNameIn)) {
            field_147145_h.info("Converting map!");
            this.func_200245_b((ITextComponent)new TranslationTextComponent("menu.convertingLevel", new Object[0]));
            this.func_71254_M().func_75805_a(worldNameIn, new IProgressUpdate(){
                private long field_96245_b = Util.func_211177_b();

                public void func_200210_a(ITextComponent component) {
                }

                @OnlyIn(value=Dist.CLIENT)
                public void func_200211_b(ITextComponent component) {
                }

                public void func_73718_a(int progress) {
                    if (Util.func_211177_b() - this.field_96245_b >= 1000L) {
                        this.field_96245_b = Util.func_211177_b();
                        field_147145_h.info("Converting... {}%", (Object)progress);
                    }
                }

                @OnlyIn(value=Dist.CLIENT)
                public void func_146586_a() {
                }

                public void func_200209_c(ITextComponent component) {
                }
            });
        }
        if (this.field_212205_ao) {
            field_147145_h.info("Forcing world upgrade!");
            WorldInfo worldinfo = this.func_71254_M().func_75803_c(this.func_71270_I());
            if (worldinfo != null) {
                WorldOptimizer worldoptimizer = new WorldOptimizer(this.func_71270_I(), this.func_71254_M(), worldinfo, this.field_213216_as);
                ITextComponent itextcomponent = null;
                while (!worldoptimizer.func_212218_b()) {
                    int i;
                    ITextComponent itextcomponent1 = worldoptimizer.func_212215_m();
                    if (itextcomponent != itextcomponent1) {
                        itextcomponent = itextcomponent1;
                        field_147145_h.info(worldoptimizer.func_212215_m().getString());
                    }
                    if ((i = worldoptimizer.func_212211_j()) > 0) {
                        int j = worldoptimizer.func_212208_k() + worldoptimizer.func_212209_l();
                        field_147145_h.info("{}% completed ({} / {} chunks)...", (Object)MathHelper.func_76141_d((float)((float)j / (float)i * 100.0f)), (Object)j, (Object)i);
                    }
                    if (this.func_71241_aa()) {
                        worldoptimizer.func_212217_a();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected synchronized void func_200245_b(ITextComponent userMessageIn) {
        this.field_71298_S = userMessageIn;
    }

    protected void func_71247_a(String saveName, String worldNameIn, long seed, WorldType type, JsonElement generatorOptions) {
        WorldSettings worldsettings;
        this.func_71237_c(saveName);
        this.func_200245_b((ITextComponent)new TranslationTextComponent("menu.loadingLevel", new Object[0]));
        SaveHandler savehandler = this.func_71254_M().func_197715_a(saveName, this);
        this.func_175584_a(this.func_71270_I(), savehandler);
        IChunkStatusListener ichunkstatuslistener = this.field_213220_d.create(11);
        WorldInfo worldinfo = savehandler.func_75757_d();
        if (worldinfo == null) {
            if (this.func_71242_L()) {
                worldsettings = field_213219_c;
            } else {
                worldsettings = new WorldSettings(seed, this.func_71265_f(), this.func_71225_e(), this.func_71199_h(), type);
                worldsettings.func_205390_a(generatorOptions);
                if (this.field_71289_N) {
                    worldsettings.func_77159_a();
                }
            }
            worldinfo = new WorldInfo(worldsettings, worldNameIn);
        } else {
            worldinfo.func_76062_a(worldNameIn);
            worldsettings = new WorldSettings(worldinfo);
        }
        worldinfo.func_230145_a_(this.getServerModName(), this.func_230045_q_().isPresent());
        this.func_195560_a(savehandler.func_75765_b(), worldinfo);
        this.func_213194_a(savehandler, worldinfo, worldsettings, ichunkstatuslistener);
        this.func_147139_a(this.func_147135_j(), true);
        this.func_213186_a(ichunkstatuslistener);
    }

    protected void func_213194_a(SaveHandler saveHandlerIn, WorldInfo info, WorldSettings worldSettingsIn, IChunkStatusListener chunkStatusListenerIn) {
        DimensionManager.fireRegister();
        if (this.func_71242_L()) {
            info.func_176127_a(field_213219_c);
        }
        ServerWorld serverworld = new ServerWorld(this, this.field_213217_au, saveHandlerIn, info, DimensionType.field_223227_a_, (IProfiler)this.field_71304_b, chunkStatusListenerIn);
        this.field_71305_c.put(DimensionType.field_223227_a_, serverworld);
        DimensionSavedDataManager dimensionsaveddatamanager = serverworld.func_217481_x();
        this.func_213204_a(dimensionsaveddatamanager);
        this.field_229733_al_ = new CommandStorage(dimensionsaveddatamanager);
        serverworld.func_175723_af().func_222519_b(info);
        ServerWorld serverworld1 = this.func_71218_a(DimensionType.field_223227_a_);
        if (!info.func_76070_v()) {
            try {
                serverworld1.func_73052_b(worldSettingsIn);
                if (info.func_76067_t() == WorldType.field_180272_g) {
                    this.func_213188_a(info);
                }
                info.func_76091_d(true);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception initializing level");
                try {
                    serverworld1.func_72914_a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            info.func_76091_d(true);
        }
        this.func_184103_al().func_212504_a(serverworld1);
        if (info.func_201357_P() != null) {
            this.func_201300_aS().func_201381_a(info.func_201357_P());
        }
        for (DimensionType dimensiontype : DimensionType.func_212681_b()) {
            if (dimensiontype != DimensionType.field_223227_a_) {
                this.field_71305_c.put(dimensiontype, new ServerMultiWorld(serverworld1, this, this.field_213217_au, saveHandlerIn, dimensiontype, (IProfiler)this.field_71304_b, chunkStatusListenerIn));
            }
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)this.field_71305_c.get((Object)dimensiontype)));
        }
    }

    private void func_213188_a(WorldInfo worldInfoIn) {
        worldInfoIn.func_176128_f(false);
        worldInfoIn.func_176121_c(true);
        worldInfoIn.func_76084_b(false);
        worldInfoIn.func_76069_a(false);
        worldInfoIn.func_176142_i(1000000000);
        worldInfoIn.func_76068_b(6000L);
        worldInfoIn.func_76060_a(GameType.SPECTATOR);
        worldInfoIn.func_176119_g(false);
        worldInfoIn.func_176144_a(Difficulty.PEACEFUL);
        worldInfoIn.func_180783_e(true);
        ((GameRules.BooleanValue)worldInfoIn.func_82574_x().func_223585_a(GameRules.field_223607_j)).func_223570_a(false, this);
    }

    protected void func_195560_a(File p_195560_1_, WorldInfo p_195560_2_) {
        this.field_195577_ad.func_198982_a((IPackFinder)new ServerPackFinder());
        this.field_195578_ae = new FolderPackFinder(new File(p_195560_1_, "datapacks"));
        this.field_195577_ad.func_198982_a((IPackFinder)this.field_195578_ae);
        this.field_195577_ad.func_198983_a();
        ArrayList list = Lists.newArrayList();
        for (String s : p_195560_2_.func_197720_O()) {
            ResourcePackInfo resourcepackinfo = this.field_195577_ad.func_198981_a(s);
            if (resourcepackinfo != null) {
                list.add(resourcepackinfo);
                continue;
            }
            field_147145_h.warn("Missing data pack {}", (Object)s);
        }
        this.field_195577_ad.func_198985_a(list);
        this.func_195568_a(p_195560_2_);
        this.func_229737_ba_();
    }

    protected void func_213186_a(IChunkStatusListener p_213186_1_) {
        this.func_200245_b((ITextComponent)new TranslationTextComponent("menu.generatingTerrain", new Object[0]));
        ServerWorld serverworld = this.func_71218_a(DimensionType.field_223227_a_);
        field_147145_h.info("Preparing start region for dimension " + DimensionType.func_212678_a(serverworld.field_73011_w.func_186058_p()));
        BlockPos blockpos = serverworld.func_175694_M();
        p_213186_1_.func_219509_a(new ChunkPos(blockpos));
        ServerChunkProvider serverchunkprovider = serverworld.func_72863_F();
        serverchunkprovider.func_212863_j_().func_215598_a(500);
        this.field_211151_aa = Util.func_211177_b();
        serverchunkprovider.func_217228_a(TicketType.field_219488_a, new ChunkPos(blockpos), 11, (Object)Unit.INSTANCE);
        while (serverchunkprovider.func_217229_b() != 441) {
            this.field_211151_aa = Util.func_211177_b() + 10L;
            this.func_213202_o();
        }
        this.field_211151_aa = Util.func_211177_b() + 10L;
        this.func_213202_o();
        for (DimensionType dimensiontype : DimensionType.func_212681_b()) {
            ForcedChunksSaveData forcedchunkssavedata = this.func_71218_a(dimensiontype).func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
            if (forcedchunkssavedata == null) continue;
            ServerWorld serverworld1 = this.func_71218_a(dimensiontype);
            LongIterator longiterator = forcedchunkssavedata.func_212438_a().iterator();
            while (longiterator.hasNext()) {
                long i = longiterator.nextLong();
                ChunkPos chunkpos = new ChunkPos(i);
                serverworld1.func_72863_F().func_217206_a(chunkpos, true);
            }
        }
        this.field_211151_aa = Util.func_211177_b() + 10L;
        this.func_213202_o();
        p_213186_1_.func_219510_b();
        serverchunkprovider.func_212863_j_().func_215598_a(5);
    }

    protected void func_175584_a(String worldNameIn, SaveHandler saveHandlerIn) {
        File file1 = new File(saveHandlerIn.func_75765_b(), "resources.zip");
        if (file1.isFile()) {
            try {
                this.func_180507_a_("level://" + URLEncoder.encode(worldNameIn, StandardCharsets.UTF_8.toString()) + "/resources.zip", "");
            }
            catch (UnsupportedEncodingException var5) {
                field_147145_h.warn("Something went wrong url encoding {}", (Object)worldNameIn);
            }
        }
    }

    public abstract boolean func_71225_e();

    public abstract GameType func_71265_f();

    public abstract Difficulty func_147135_j();

    public abstract boolean func_71199_h();

    public abstract int func_110455_j();

    public abstract int func_223707_k();

    public abstract boolean func_195569_l();

    public boolean func_213211_a(boolean suppressLog, boolean flush, boolean forced) {
        boolean flag = false;
        for (ServerWorld serverworld : this.func_212370_w()) {
            if (!suppressLog) {
                field_147145_h.info("Saving chunks for level '{}'/{}", (Object)serverworld.func_72912_H().func_76065_j(), (Object)DimensionType.func_212678_a(serverworld.field_73011_w.func_186058_p()));
            }
            try {
                serverworld.func_217445_a(null, flush, serverworld.field_73058_d && !forced);
            }
            catch (SessionLockException sessionlockexception) {
                field_147145_h.warn(sessionlockexception.getMessage());
            }
            flag = true;
        }
        ServerWorld serverworld1 = this.func_71218_a(DimensionType.field_223227_a_);
        WorldInfo worldinfo = serverworld1.func_72912_H();
        serverworld1.func_175723_af().func_222520_a(worldinfo);
        worldinfo.func_201356_c(this.func_201300_aS().func_201380_c());
        serverworld1.func_217485_w().func_75755_a(worldinfo, this.func_184103_al().func_72378_q());
        return flag;
    }

    @Override
    public void close() {
        this.func_71260_j();
    }

    protected void func_71260_j() {
        field_147145_h.info("Stopping server");
        if (this.func_147137_ag() != null) {
            this.func_147137_ag().func_151268_b();
        }
        if (this.field_71318_t != null) {
            field_147145_h.info("Saving players");
            this.field_71318_t.func_72389_g();
            this.field_71318_t.func_72392_r();
        }
        field_147145_h.info("Saving worlds");
        for (ServerWorld serverworld : this.func_212370_w()) {
            if (serverworld == null) continue;
            serverworld.field_73058_d = false;
        }
        this.func_213211_a(false, true, false);
        for (ServerWorld serverworld1 : this.func_212370_w()) {
            if (serverworld1 == null) continue;
            try {
                MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)serverworld1));
                serverworld1.close();
            }
            catch (IOException ioexception) {
                field_147145_h.error("Exception closing the level", (Throwable)ioexception);
            }
        }
        if (this.field_71307_n.func_76468_d()) {
            this.field_71307_n.func_76470_e();
        }
    }

    public String func_71211_k() {
        return this.field_71320_r;
    }

    public void func_71189_e(String host) {
        this.field_71320_r = host;
    }

    public boolean func_71278_l() {
        return this.field_71317_u;
    }

    public void func_71263_m(boolean waitForServer) {
        this.field_71317_u = false;
        if (waitForServer) {
            try {
                this.field_175590_aa.join();
            }
            catch (InterruptedException interruptedexception) {
                field_147145_h.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            if (this.func_71197_b()) {
                ServerLifecycleHooks.handleServerStarted((MinecraftServer)this);
                this.field_211151_aa = Util.func_211177_b();
                this.field_147147_p.func_151315_a((ITextComponent)new StringTextComponent(this.field_71286_C));
                this.field_147147_p.func_151321_a(new ServerStatusResponse.Version(SharedConstants.func_215069_a().getName(), SharedConstants.func_215069_a().getProtocolVersion()));
                this.func_184107_a(this.field_147147_p);
                while (true) {
                    if (!this.field_71317_u) {
                        ServerLifecycleHooks.handleServerStopping((MinecraftServer)this);
                        ServerLifecycleHooks.expectServerStopped();
                        return;
                    }
                    long i = Util.func_211177_b() - this.field_211151_aa;
                    if (i > 2000L && this.field_211151_aa - this.field_71299_R >= 15000L) {
                        long j = i / 50L;
                        field_147145_h.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)i, (Object)j);
                        this.field_211151_aa += j * 50L;
                        this.field_71299_R = this.field_211151_aa;
                    }
                    this.field_211151_aa += 50L;
                    if (this.field_71295_T) {
                        this.field_71295_T = false;
                        this.field_71304_b.func_219899_d().func_219939_d();
                    }
                    this.field_71304_b.func_219894_a();
                    this.field_71304_b.func_76320_a("tick");
                    this.func_71217_p(this::func_212379_aT);
                    this.field_71304_b.func_219895_b("nextTickWait");
                    this.field_213214_ac = true;
                    this.field_213213_ab = Math.max(Util.func_211177_b() + 50L, this.field_211151_aa);
                    this.func_213202_o();
                    this.field_71304_b.func_76319_b();
                    this.field_71304_b.func_219897_b();
                    this.field_71296_Q = true;
                }
            }
            ServerLifecycleHooks.expectServerStopped();
            this.func_71228_a(null);
            return;
        }
        catch (StartupQuery.AbortedException e) {
            ServerLifecycleHooks.expectServerStopped();
            return;
        }
        catch (Throwable throwable1) {
            field_147145_h.error("Encountered an unexpected exception", throwable1);
            CrashReport crashreport = throwable1 instanceof ReportedException ? this.func_71230_b(((ReportedException)throwable1).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", throwable1));
            File file1 = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.func_147149_a(file1)) {
                field_147145_h.error("This crash report has been saved to: {}", (Object)file1.getAbsolutePath());
            } else {
                field_147145_h.error("We were unable to save this crash report to disk.");
            }
            ServerLifecycleHooks.expectServerStopped();
            this.func_71228_a(crashreport);
            return;
        }
        finally {
            try {
                this.field_71316_v = true;
                this.func_71260_j();
            }
            catch (Throwable throwable) {
                field_147145_h.error("Exception stopping the server", throwable);
            }
            finally {
                ServerLifecycleHooks.handleServerStopped((MinecraftServer)this);
                this.func_71240_o();
            }
        }
    }

    private boolean func_212379_aT() {
        return this.func_213182_bg() || Util.func_211177_b() < (this.field_213214_ac ? this.field_213213_ab : this.field_211151_aa);
    }

    protected void func_213202_o() {
        this.func_213160_bf();
        this.func_213161_c(() -> !this.func_212379_aT());
    }

    protected TickDelayedTask func_212875_d_(Runnable runnable) {
        return new TickDelayedTask(this.field_71315_w, runnable);
    }

    protected boolean func_212874_c_(TickDelayedTask runnable) {
        return runnable.func_218823_a() + 3 < this.field_71315_w || this.func_212379_aT();
    }

    public boolean func_213168_p() {
        boolean flag;
        this.field_213214_ac = flag = this.func_213205_aW();
        return flag;
    }

    private boolean func_213205_aW() {
        if (super.func_213168_p()) {
            return true;
        }
        if (this.func_212379_aT()) {
            for (ServerWorld serverworld : this.func_212370_w()) {
                if (!serverworld.func_72863_F().func_217234_d()) continue;
                return true;
            }
        }
        return false;
    }

    protected void func_213166_h(TickDelayedTask taskIn) {
        this.func_213185_aS().func_230035_c_("runTask");
        super.func_213166_h((Runnable)taskIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_184107_a(ServerStatusResponse response) {
        File file1 = this.func_71209_f("server-icon.png");
        if (!file1.exists()) {
            file1 = this.func_71254_M().func_186352_b(this.func_71270_I(), "icon.png");
        }
        if (file1.isFile()) {
            ByteBuf bytebuf = Unpooled.buffer();
            try {
                BufferedImage bufferedimage = ImageIO.read(file1);
                Validate.validState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedimage, "PNG", (OutputStream)new ByteBufOutputStream(bytebuf));
                ByteBuffer bytebuffer = Base64.getEncoder().encode(bytebuf.nioBuffer());
                response.func_151320_a("data:image/png;base64," + StandardCharsets.UTF_8.decode(bytebuffer));
            }
            catch (Exception exception) {
                field_147145_h.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                bytebuf.release();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_184106_y() {
        this.field_184111_ab = this.field_184111_ab || this.func_184109_z().isFile();
        return this.field_184111_ab;
    }

    @OnlyIn(value=Dist.CLIENT)
    public File func_184109_z() {
        return this.func_71254_M().func_186352_b(this.func_71270_I(), "icon.png");
    }

    public File func_71238_n() {
        return new File(".");
    }

    protected void func_71228_a(CrashReport report) {
    }

    protected void func_71240_o() {
    }

    protected void func_71217_p(BooleanSupplier hasTimeLeft) {
        long i = Util.func_211178_c();
        BasicEventHooks.onPreServerTick();
        ++this.field_71315_w;
        this.func_71190_q(hasTimeLeft);
        if (i - this.field_147142_T >= 5000000000L) {
            this.field_147142_T = i;
            this.field_147147_p.func_151319_a(new ServerStatusResponse.Players(this.func_71275_y(), this.func_71233_x()));
            GameProfile[] agameprofile = new GameProfile[Math.min(this.func_71233_x(), 12)];
            int j = MathHelper.func_76136_a((Random)this.field_147146_q, (int)0, (int)(this.func_71233_x() - agameprofile.length));
            for (int k = 0; k < agameprofile.length; ++k) {
                agameprofile[k] = this.field_71318_t.func_181057_v().get(j + k).func_146103_bH();
            }
            Collections.shuffle(Arrays.asList(agameprofile));
            this.field_147147_p.func_151318_b().func_151330_a(agameprofile);
            this.field_147147_p.invalidateJson();
        }
        if (this.field_71315_w % 6000 == 0) {
            field_147145_h.debug("Autosave started");
            this.field_71304_b.func_76320_a("save");
            this.field_71318_t.func_72389_g();
            this.func_213211_a(true, false, false);
            this.field_71304_b.func_76319_b();
            field_147145_h.debug("Autosave finished");
        }
        this.field_71304_b.func_76320_a("snooper");
        if (!this.field_71307_n.func_76468_d() && this.field_71315_w > 100) {
            this.field_71307_n.func_76463_a();
        }
        if (this.field_71315_w % 6000 == 0) {
            this.field_71307_n.func_76471_b();
        }
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76320_a("tallying");
        long l = Util.func_211178_c() - i;
        this.field_71311_j[this.field_71315_w % 100] = l;
        long l2 = l;
        this.field_211152_ao = this.field_211152_ao * 0.8f + (float)l2 / 1000000.0f * 0.19999999f;
        long i1 = Util.func_211178_c();
        this.field_213215_ap.func_181747_a(i1 - i);
        this.field_71304_b.func_76319_b();
        BasicEventHooks.onPostServerTick();
    }

    protected void func_71190_q(BooleanSupplier hasTimeLeft) {
        this.field_71304_b.func_76320_a("commandFunctions");
        this.func_193030_aL().func_73660_a();
        this.field_71304_b.func_219895_b("levels");
        for (ServerWorld serverworld : this.getWorldArray()) {
            long tickStart = Util.func_211178_c();
            if (serverworld.field_73011_w.func_186058_p() == DimensionType.field_223227_a_ || this.func_71255_r()) {
                this.field_71304_b.func_194340_a(() -> serverworld.func_72912_H().func_76065_j() + " " + Registry.field_212622_k.func_177774_c(serverworld.field_73011_w.func_186058_p()));
                if (this.field_71315_w % 20 == 0) {
                    this.field_71304_b.func_76320_a("timeSync");
                    this.field_71318_t.func_148537_a((IPacket<?>)new SUpdateTimePacket(serverworld.func_82737_E(), serverworld.func_72820_D(), serverworld.func_82736_K().func_223586_b(GameRules.field_223607_j)), serverworld.field_73011_w.func_186058_p());
                    this.field_71304_b.func_76319_b();
                }
                this.field_71304_b.func_76320_a("tick");
                BasicEventHooks.onPreWorldTick((World)serverworld);
                try {
                    serverworld.func_72835_b(hasTimeLeft);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception ticking world");
                    serverworld.func_72914_a(crashreport);
                    throw new ReportedException(crashreport);
                }
                BasicEventHooks.onPostWorldTick((World)serverworld);
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76319_b();
            }
            this.perWorldTickTimes.computeIfAbsent((DimensionType)serverworld.func_201675_m().func_186058_p(), (Function<DimensionType, long[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateTimeLightAndEntities$4(net.minecraft.world.dimension.DimensionType ), (Lnet/minecraft/world/dimension/DimensionType;)[J)())[this.field_71315_w % 100] = Util.func_211178_c() - tickStart;
        }
        this.field_71304_b.func_219895_b("dim_unloading");
        DimensionManager.unloadWorlds((MinecraftServer)this, (this.field_71315_w % 200 == 0 ? 1 : 0) != 0);
        this.field_71304_b.func_219895_b("connection");
        this.func_147137_ag().func_151269_c();
        this.field_71304_b.func_219895_b("players");
        this.field_71318_t.func_72374_b();
        if (SharedConstants.field_206244_b) {
            TestCollection.field_229570_a_.func_229574_b_();
        }
        this.field_71304_b.func_219895_b("server gui refresh");
        for (int i = 0; i < this.field_71322_p.size(); ++i) {
            this.field_71322_p.get(i).run();
        }
        this.field_71304_b.func_76319_b();
    }

    public boolean func_71255_r() {
        return true;
    }

    public void func_82010_a(Runnable tickable) {
        this.field_71322_p.add(tickable);
    }

    public static void main(String[] p_main_0_) {
        OptionParser optionparser = new OptionParser();
        OptionSpecBuilder optionspec = optionparser.accepts("nogui");
        OptionSpecBuilder optionspec1 = optionparser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder optionspec2 = optionparser.accepts("demo");
        OptionSpecBuilder optionspec3 = optionparser.accepts("bonusChest");
        OptionSpecBuilder optionspec4 = optionparser.accepts("forceUpgrade");
        OptionSpecBuilder optionspec5 = optionparser.accepts("eraseCache");
        AbstractOptionSpec optionspec6 = optionparser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec optionspec7 = optionparser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec8 = optionparser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec9 = optionparser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec10 = optionparser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec11 = optionparser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec optionspec12 = optionparser.nonOptions();
        optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        try {
            boolean flag;
            OptionSet optionset = optionparser.parse(p_main_0_);
            if (optionset.has((OptionSpec)optionspec6)) {
                optionparser.printHelpOn((OutputStream)System.err);
                return;
            }
            Path path = Paths.get("server.properties", new String[0]);
            ServerPropertiesProvider serverpropertiesprovider = new ServerPropertiesProvider(path);
            if (optionset.has((OptionSpec)optionspec1) || !Files.exists(path, new LinkOption[0])) {
                serverpropertiesprovider.func_219035_b();
            }
            Path path1 = Paths.get("eula.txt", new String[0]);
            ServerEula servereula = new ServerEula(path1);
            if (optionset.has((OptionSpec)optionspec1)) {
                field_147145_h.info("Initialized '" + path.toAbsolutePath().toString() + "' and '" + path1.toAbsolutePath().toString() + "'");
                return;
            }
            if (!servereula.func_154346_a()) {
                field_147145_h.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            CrashReport.func_230188_h_();
            Bootstrap.func_151354_b();
            Bootstrap.func_218821_c();
            String s = (String)optionset.valueOf((OptionSpec)optionspec8);
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(s, field_152367_a.getName()));
            String s1 = (String)Optional.ofNullable(optionset.valueOf((OptionSpec)optionspec9)).orElse(serverpropertiesprovider.func_219034_a().field_219021_o);
            if (s1 == null || s1.isEmpty() || new File(s, s1).getAbsolutePath().equals(new File(s).getAbsolutePath())) {
                field_147145_h.error("Invalid world directory specified, must not be null, empty or the same directory as your universe! " + s1);
                return;
            }
            final DedicatedServer dedicatedserver = new DedicatedServer(new File(s), serverpropertiesprovider, DataFixesManager.func_210901_a(), yggdrasilauthenticationservice, minecraftsessionservice, gameprofilerepository, playerprofilecache, LoggingChunkStatusListener::new, s1);
            dedicatedserver.func_71224_l((String)optionset.valueOf((OptionSpec)optionspec7));
            dedicatedserver.func_71208_b((Integer)optionset.valueOf((OptionSpec)optionspec10));
            dedicatedserver.func_71204_b(optionset.has((OptionSpec)optionspec2));
            dedicatedserver.func_71194_c(optionset.has((OptionSpec)optionspec3));
            dedicatedserver.func_212204_b(optionset.has((OptionSpec)optionspec4));
            dedicatedserver.func_213197_c(optionset.has((OptionSpec)optionspec5));
            dedicatedserver.func_213208_c((String)optionset.valueOf((OptionSpec)optionspec11));
            boolean bl = flag = !optionset.has((OptionSpec)optionspec) && !optionset.valuesOf((OptionSpec)optionspec12).contains("nogui");
            if (flag && !GraphicsEnvironment.isHeadless()) {
                dedicatedserver.func_120011_ar();
            }
            dedicatedserver.func_71256_s();
            Thread thread = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    dedicatedserver.func_71263_m(true);
                    LogManager.shutdown();
                }
            };
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_147145_h));
            Runtime.getRuntime().addShutdownHook(thread);
        }
        catch (Exception exception) {
            field_147145_h.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    protected void func_213208_c(String serverIdIn) {
        this.field_213218_av = serverIdIn;
    }

    protected void func_212204_b(boolean forceWorldUpgradeIn) {
        this.field_212205_ao = forceWorldUpgradeIn;
    }

    protected void func_213197_c(boolean eraseCacheIn) {
        this.field_213216_as = eraseCacheIn;
    }

    public void func_71256_s() {
        this.field_175590_aa.start();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_213201_w() {
        return !this.field_175590_aa.isAlive();
    }

    public File func_71209_f(String fileName) {
        return new File(this.func_71238_n(), fileName);
    }

    public void func_71244_g(String msg) {
        field_147145_h.info(msg);
    }

    public void func_71236_h(String msg) {
        field_147145_h.warn(msg);
    }

    public ServerWorld func_71218_a(DimensionType dimension) {
        return DimensionManager.getWorld((MinecraftServer)this, (DimensionType)dimension, (boolean)true, (boolean)true);
    }

    public Iterable<ServerWorld> func_212370_w() {
        return this.field_71305_c.values();
    }

    public String func_71249_w() {
        return SharedConstants.func_215069_a().getName();
    }

    public int func_71233_x() {
        return this.field_71318_t.func_72394_k();
    }

    public int func_71275_y() {
        return this.field_71318_t.func_72352_l();
    }

    public String[] func_71213_z() {
        return this.field_71318_t.func_72369_d();
    }

    public boolean func_71239_B() {
        return false;
    }

    public void func_71201_j(String msg) {
        field_147145_h.error(msg);
    }

    public void func_71198_k(String msg) {
        if (this.func_71239_B()) {
            field_147145_h.info(msg);
        }
    }

    public String getServerModName() {
        return BrandingControl.getServerBranding();
    }

    public CrashReport func_71230_b(CrashReport report) {
        if (this.field_71318_t != null) {
            report.func_85056_g().func_189529_a("Player Count", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_71318_t.func_72394_k() + " / " + this.field_71318_t.func_72352_l() + "; " + this.field_71318_t.func_181057_v()));
        }
        report.func_85056_g().func_189529_a("Data Packs", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
            StringBuilder stringbuilder = new StringBuilder();
            for (ResourcePackInfo resourcepackinfo : this.field_195577_ad.func_198980_d()) {
                if (stringbuilder.length() > 0) {
                    stringbuilder.append(", ");
                }
                stringbuilder.append(resourcepackinfo.func_195790_f());
                if (resourcepackinfo.func_195791_d().func_198968_a()) continue;
                stringbuilder.append(" (incompatible)");
            }
            return stringbuilder.toString();
        }));
        if (this.field_213218_av != null) {
            report.func_85056_g().func_189529_a("Server Id", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_213218_av));
        }
        return report;
    }

    public abstract Optional<String> func_230045_q_();

    public boolean func_175578_N() {
        return this.field_71308_o != null;
    }

    public void func_145747_a(ITextComponent component) {
        field_147145_h.info(component.getString());
    }

    public KeyPair func_71250_E() {
        return this.field_71292_I;
    }

    public int func_71215_F() {
        return this.field_71319_s;
    }

    public void func_71208_b(int port) {
        this.field_71319_s = port;
    }

    public String func_71214_G() {
        return this.field_71293_J;
    }

    public void func_71224_l(String owner) {
        this.field_71293_J = owner;
    }

    public boolean func_71264_H() {
        return this.field_71293_J != null;
    }

    public String func_71270_I() {
        return this.field_71294_K;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_71246_n(String worldNameIn) {
        this.field_71287_L = worldNameIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_71221_J() {
        return this.field_71287_L;
    }

    public void func_71253_a(KeyPair keyPair) {
        this.field_71292_I = keyPair;
    }

    public void func_147139_a(Difficulty difficulty, boolean p_147139_2_) {
        for (ServerWorld serverworld : this.func_212370_w()) {
            WorldInfo worldinfo = serverworld.func_72912_H();
            if (!p_147139_2_ && worldinfo.func_176123_z()) continue;
            if (worldinfo.func_76093_s()) {
                worldinfo.func_176144_a(Difficulty.HARD);
                serverworld.func_72891_a(true, true);
                continue;
            }
            if (this.func_71264_H()) {
                worldinfo.func_176144_a(difficulty);
                serverworld.func_72891_a(serverworld.func_175659_aa() != Difficulty.PEACEFUL, true);
                continue;
            }
            worldinfo.func_176144_a(difficulty);
            serverworld.func_72891_a(this.func_71193_K(), this.field_71324_y);
        }
        this.func_184103_al().func_181057_v().forEach(this::func_213189_a);
    }

    public void func_213209_d(boolean locked) {
        for (ServerWorld serverworld : this.func_212370_w()) {
            WorldInfo worldinfo = serverworld.func_72912_H();
            worldinfo.func_180783_e(locked);
        }
        this.func_184103_al().func_181057_v().forEach(this::func_213189_a);
    }

    private void func_213189_a(ServerPlayerEntity playerIn) {
        WorldInfo worldinfo = playerIn.func_71121_q().func_72912_H();
        playerIn.field_71135_a.func_147359_a((IPacket<?>)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
    }

    protected boolean func_71193_K() {
        return true;
    }

    public boolean func_71242_L() {
        return this.field_71288_M;
    }

    public void func_71204_b(boolean demo) {
        this.field_71288_M = demo;
    }

    public void func_71194_c(boolean enable) {
        this.field_71289_N = enable;
    }

    public SaveFormat func_71254_M() {
        return this.field_71310_m;
    }

    public String func_147133_T() {
        return this.field_147141_M;
    }

    public String func_175581_ab() {
        return this.field_175588_P;
    }

    public void func_180507_a_(String url, String hash) {
        this.field_147141_M = url;
        this.field_175588_P = hash;
    }

    public void func_70000_a(Snooper snooper) {
        snooper.func_152768_a("whitelist_enabled", (Object)false);
        snooper.func_152768_a("whitelist_count", (Object)0);
        if (this.field_71318_t != null) {
            snooper.func_152768_a("players_current", (Object)this.func_71233_x());
            snooper.func_152768_a("players_max", (Object)this.func_71275_y());
            snooper.func_152768_a("players_seen", (Object)this.func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_215771_d().length);
        }
        snooper.func_152768_a("uses_auth", (Object)this.field_71325_x);
        snooper.func_152768_a("gui_state", (Object)(this.func_71279_ae() ? "enabled" : "disabled"));
        snooper.func_152768_a("run_time", (Object)((Util.func_211177_b() - snooper.func_130105_g()) / 60L * 1000L));
        snooper.func_152768_a("avg_tick_ms", (Object)((int)(MathHelper.func_76127_a((long[])this.field_71311_j) * 1.0E-6)));
        int i = 0;
        for (ServerWorld serverworld : this.func_212370_w()) {
            if (serverworld == null) continue;
            WorldInfo worldinfo = serverworld.func_72912_H();
            snooper.func_152768_a("world[" + i + "][dimension]", (Object)serverworld.field_73011_w.func_186058_p());
            snooper.func_152768_a("world[" + i + "][mode]", (Object)worldinfo.func_76077_q());
            snooper.func_152768_a("world[" + i + "][difficulty]", (Object)serverworld.func_175659_aa());
            snooper.func_152768_a("world[" + i + "][hardcore]", (Object)worldinfo.func_76093_s());
            snooper.func_152768_a("world[" + i + "][generator_name]", (Object)worldinfo.func_76067_t().func_211888_a());
            snooper.func_152768_a("world[" + i + "][generator_version]", (Object)worldinfo.func_76067_t().func_77131_c());
            snooper.func_152768_a("world[" + i + "][height]", (Object)this.field_71280_D);
            snooper.func_152768_a("world[" + i + "][chunks_loaded]", (Object)serverworld.func_72863_F().func_73152_e());
            ++i;
        }
        snooper.func_152768_a("worlds", (Object)i);
    }

    public abstract boolean func_71262_S();

    public boolean func_71266_T() {
        return this.field_71325_x;
    }

    public void func_71229_d(boolean online) {
        this.field_71325_x = online;
    }

    public boolean func_190518_ac() {
        return this.field_190519_A;
    }

    public void func_190517_e(boolean p_190517_1_) {
        this.field_190519_A = p_190517_1_;
    }

    public boolean func_71268_U() {
        return this.field_71324_y;
    }

    public void func_71251_e(boolean spawnAnimals) {
        this.field_71324_y = spawnAnimals;
    }

    public boolean func_71220_V() {
        return this.field_71323_z;
    }

    public abstract boolean func_181035_ah();

    public void func_71257_f(boolean spawnNpcs) {
        this.field_71323_z = spawnNpcs;
    }

    public boolean func_71219_W() {
        return this.field_71284_A;
    }

    public void func_71188_g(boolean allowPvp) {
        this.field_71284_A = allowPvp;
    }

    public boolean func_71231_X() {
        return this.field_71285_B;
    }

    public void func_71245_h(boolean allow) {
        this.field_71285_B = allow;
    }

    public abstract boolean func_82356_Z();

    public String func_71273_Y() {
        return this.field_71286_C;
    }

    public void func_71205_p(String motdIn) {
        this.field_71286_C = motdIn;
    }

    public int func_71207_Z() {
        return this.field_71280_D;
    }

    public void func_71191_d(int maxBuildHeight) {
        this.field_71280_D = maxBuildHeight;
    }

    public boolean func_71241_aa() {
        return this.field_71316_v;
    }

    public PlayerList func_184103_al() {
        return this.field_71318_t;
    }

    public void func_184105_a(PlayerList list) {
        this.field_71318_t = list;
    }

    public abstract boolean func_71344_c();

    public void func_71235_a(GameType gameMode) {
        for (ServerWorld serverworld : this.func_212370_w()) {
            serverworld.func_72912_H().func_76060_a(gameMode);
        }
    }

    @Nullable
    public NetworkSystem func_147137_ag() {
        return this.field_147144_o;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_71200_ad() {
        return this.field_71296_Q;
    }

    public boolean func_71279_ae() {
        return false;
    }

    public abstract boolean func_195565_a(GameType var1, boolean var2, int var3);

    public int func_71259_af() {
        return this.field_71315_w;
    }

    public void func_71223_ag() {
        this.field_71295_T = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Snooper func_80003_ah() {
        return this.field_71307_n;
    }

    public int func_82357_ak() {
        return 16;
    }

    public boolean func_175579_a(World worldIn, BlockPos pos, PlayerEntity playerIn) {
        return false;
    }

    public void func_104055_i(boolean force) {
        this.field_104057_T = force;
    }

    public boolean func_104056_am() {
        return this.field_104057_T;
    }

    public int func_143007_ar() {
        return this.field_143008_E;
    }

    public void func_143006_e(int idleTimeout) {
        this.field_143008_E = idleTimeout;
    }

    public MinecraftSessionService func_147130_as() {
        return this.field_147143_S;
    }

    public GameProfileRepository func_152359_aw() {
        return this.field_152365_W;
    }

    public PlayerProfileCache func_152358_ax() {
        return this.field_152366_X;
    }

    public ServerStatusResponse func_147134_at() {
        return this.field_147147_p;
    }

    public void func_147132_au() {
        this.field_147142_T = 0L;
    }

    public int func_175580_aG() {
        return 29999984;
    }

    public boolean func_213164_aw() {
        return super.func_213164_aw() && !this.func_71241_aa();
    }

    public Thread func_213170_ax() {
        return this.field_175590_aa;
    }

    public int func_175577_aI() {
        return 256;
    }

    public long func_211150_az() {
        return this.field_211151_aa;
    }

    public DataFixer func_195563_aC() {
        return this.field_184112_s;
    }

    public int func_184108_a(@Nullable ServerWorld worldIn) {
        return worldIn != null ? worldIn.func_82736_K().func_223592_c(GameRules.field_223614_q) : 10;
    }

    public AdvancementManager func_191949_aK() {
        return this.field_200257_ak;
    }

    public FunctionManager func_193030_aL() {
        return this.field_200258_al;
    }

    public LootModifierManager getLootModifierManager() {
        return this.lootManager;
    }

    public void func_193031_aM() {
        if (!this.func_213162_bc()) {
            this.execute(this::func_193031_aM);
        } else {
            this.func_184103_al().func_72389_g();
            this.field_195577_ad.func_198983_a();
            this.func_195568_a(this.func_71218_a(DimensionType.field_223227_a_).func_72912_H());
            this.func_184103_al().func_193244_w();
            this.func_229737_ba_();
        }
    }

    private void func_195568_a(WorldInfo worldInfoIn) {
        ArrayList list = Lists.newArrayList(this.field_195577_ad.func_198980_d());
        for (ResourcePackInfo resourcepackinfo : this.field_195577_ad.func_198978_b()) {
            if (worldInfoIn.func_197719_N().contains(resourcepackinfo.func_195790_f()) || list.contains(resourcepackinfo)) continue;
            field_147145_h.info("Found new data pack {}, loading it automatically", (Object)resourcepackinfo.func_195790_f());
            resourcepackinfo.func_195792_i().func_198993_a(list, resourcepackinfo, p_200247_0_ -> p_200247_0_, false);
        }
        this.field_195577_ad.func_198985_a(list);
        ArrayList list1 = Lists.newArrayList();
        this.field_195577_ad.func_198980_d().forEach(p_200244_1_ -> list1.add(p_200244_1_.func_195796_e()));
        CompletableFuture completablefuture = this.field_195576_ac.func_219536_a(this.field_213217_au, (Executor)((Object)this), (List)list1, field_223713_i);
        this.func_213161_c(completablefuture::isDone);
        try {
            completablefuture.get();
        }
        catch (Exception exception) {
            field_147145_h.error("Failed to reload data packs", (Throwable)exception);
        }
        worldInfoIn.func_197720_O().clear();
        worldInfoIn.func_197719_N().clear();
        this.field_195577_ad.func_198980_d().forEach(p_195562_1_ -> worldInfoIn.func_197720_O().add(p_195562_1_.func_195790_f()));
        this.field_195577_ad.func_198978_b().forEach(p_200248_2_ -> {
            if (!this.field_195577_ad.func_198980_d().contains(p_200248_2_)) {
                worldInfoIn.func_197719_N().add(p_200248_2_.func_195790_f());
            }
        });
    }

    public void func_205743_a(CommandSource commandSourceIn) {
        PlayerList playerlist;
        WhiteList whitelist;
        if (this.func_205744_aT() && (whitelist = (playerlist = commandSourceIn.func_197028_i().func_184103_al()).func_152599_k()).func_152689_b()) {
            for (ServerPlayerEntity serverplayerentity : Lists.newArrayList(playerlist.func_181057_v())) {
                if (whitelist.func_152705_a(serverplayerentity.func_146103_bH())) continue;
                serverplayerentity.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.not_whitelisted", new Object[0]));
            }
        }
    }

    public IReloadableResourceManager func_195570_aG() {
        return this.field_195576_ac;
    }

    public ResourcePackList<ResourcePackInfo> func_195561_aH() {
        return this.field_195577_ad;
    }

    public Commands func_195571_aL() {
        return this.field_195579_af;
    }

    public CommandSource func_195573_aM() {
        return new CommandSource((ICommandSource)this, this.func_71218_a(DimensionType.field_223227_a_) == null ? Vec3d.field_186680_a : new Vec3d((Vec3i)this.func_71218_a(DimensionType.field_223227_a_).func_175694_M()), Vec2f.field_189974_a, this.func_71218_a(DimensionType.field_223227_a_), 4, "Server", (ITextComponent)new StringTextComponent("Server"), this, (Entity)null);
    }

    public boolean func_195039_a() {
        return true;
    }

    public boolean func_195040_b() {
        return true;
    }

    public RecipeManager func_199529_aN() {
        return this.field_199530_ag;
    }

    public NetworkTagManager func_199731_aO() {
        return this.field_199736_ah;
    }

    public ServerScoreboard func_200251_aP() {
        return this.field_200255_ai;
    }

    public CommandStorage func_229735_aN_() {
        if (this.field_229733_al_ == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.field_229733_al_;
    }

    public LootTableManager func_200249_aQ() {
        return this.field_200256_aj;
    }

    public LootPredicateManager func_229736_aP_() {
        return this.field_229734_an_;
    }

    public GameRules func_200252_aR() {
        return this.func_71218_a(DimensionType.field_223227_a_).func_82736_K();
    }

    public CustomServerBossInfoManager func_201300_aS() {
        return this.field_201301_aj;
    }

    public boolean func_205744_aT() {
        return this.field_205745_an;
    }

    public void func_205741_k(boolean whitelistEnabledIn) {
        this.field_205745_an = whitelistEnabledIn;
    }

    public float func_211149_aT() {
        return this.field_211152_ao;
    }

    public int func_211833_a(GameProfile profile) {
        if (this.func_184103_al().func_152596_g(profile)) {
            OpEntry opentry = (OpEntry)this.func_184103_al().func_152603_m().func_152683_b((Object)profile);
            if (opentry != null) {
                return opentry.func_152644_a();
            }
            if (this.func_213199_b(profile)) {
                return 4;
            }
            if (this.func_71264_H()) {
                return this.func_184103_al().func_206257_x() ? 4 : 0;
            }
            return this.func_110455_j();
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FrameTimer func_213210_aR() {
        return this.field_213215_ap;
    }

    public DebugProfiler func_213185_aS() {
        return this.field_71304_b;
    }

    public Executor func_213207_aT() {
        return this.field_213217_au;
    }

    public abstract boolean func_213199_b(GameProfile var1);

    @Nullable
    public long[] getTickTime(DimensionType dim) {
        return this.perWorldTickTimes.get((Object)dim);
    }

    @Deprecated
    public synchronized Map<DimensionType, ServerWorld> forgeGetWorldMap() {
        return this.field_71305_c;
    }

    @Deprecated
    public synchronized void markWorldsDirty() {
        ++this.worldArrayMarker;
    }

    private ServerWorld[] getWorldArray() {
        if (this.worldArrayMarker == this.worldArrayLast && this.worldArray != null) {
            return this.worldArray;
        }
        this.worldArray = (ServerWorld[])this.field_71305_c.values().stream().toArray(ServerWorld[]::new);
        this.worldArrayLast = this.worldArrayMarker;
        return this.worldArray;
    }

    public void func_223711_a(Path p_223711_1_) throws IOException {
        Path path = p_223711_1_.resolve("levels");
        for (Map.Entry<DimensionType, ServerWorld> entry : this.field_71305_c.entrySet()) {
            ResourceLocation resourcelocation = DimensionType.func_212678_a(entry.getKey());
            Path path1 = path.resolve(resourcelocation.func_110624_b()).resolve(resourcelocation.func_110623_a());
            Files.createDirectories(path1, new FileAttribute[0]);
            entry.getValue().func_225322_a(path1);
        }
        this.func_223708_d(p_223711_1_.resolve("gamerules.txt"));
        this.func_223706_e(p_223711_1_.resolve("classpath.txt"));
        this.func_223709_c(p_223711_1_.resolve("example_crash.txt"));
        this.func_223710_b(p_223711_1_.resolve("stats.txt"));
        this.func_223712_f(p_223711_1_.resolve("threads.txt"));
    }

    private void func_223710_b(Path p_223710_1_) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(p_223710_1_, new OpenOption[0]);){
            writer.write(String.format("pending_tasks: %d\n", this.func_223704_be()));
            writer.write(String.format("average_tick_time: %f\n", Float.valueOf(this.func_211149_aT())));
            writer.write(String.format("tick_times: %s\n", Arrays.toString(this.field_71311_j)));
            writer.write(String.format("queue: %s\n", Util.func_215072_e()));
        }
    }

    private void func_223709_c(Path p_223709_1_) throws IOException {
        CrashReport crashreport = new CrashReport("Server dump", new Exception("dummy"));
        this.func_71230_b(crashreport);
        try (BufferedWriter writer = Files.newBufferedWriter(p_223709_1_, new OpenOption[0]);){
            writer.write(crashreport.func_71502_e());
        }
    }

    private void func_223708_d(Path p_223708_1_) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(p_223708_1_, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gamerules = this.func_200252_aR();
            GameRules.func_223590_a((GameRules.IRuleEntryVisitor)new GameRules.IRuleEntryVisitor(){

                public <T extends GameRules.RuleValue<T>> void func_223481_a(GameRules.RuleKey<T> key, GameRules.RuleType<T> type) {
                    list.add(String.format("%s=%s\n", key.func_223576_a(), gamerules.func_223585_a(key).toString()));
                }
            });
            for (String s : list) {
                writer.write(s);
            }
        }
    }

    private void func_223706_e(Path p_223706_1_) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(p_223706_1_, new OpenOption[0]);){
            String s = System.getProperty("java.class.path");
            String s1 = System.getProperty("path.separator");
            for (String s2 : Splitter.on((String)s1).split((CharSequence)s)) {
                writer.write(s2);
                writer.write("\n");
            }
        }
    }

    private void func_223712_f(Path p_223712_1_) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter writer = Files.newBufferedWriter(p_223712_1_, new OpenOption[0]);){
            for (ThreadInfo threadinfo : athreadinfo) {
                writer.write(threadinfo.toString());
                ((Writer)writer).write(10);
            }
        }
    }

    private void func_229737_ba_() {
        Block.field_176229_d.forEach(BlockState::func_215692_c);
    }

    private static /* synthetic */ long[] lambda$updateTimeLightAndEntities$4(DimensionType k) {
        return new long[100];
    }
}

