/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class Texture {
    protected int field_110553_a = -1;
    protected boolean field_174940_b;
    protected boolean field_174941_c;
    private boolean lastBlur;
    private boolean lastMipmap;

    public void func_174937_a(boolean blurIn, boolean mipmapIn) {
        int j;
        int i;
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.field_174940_b = blurIn;
        this.field_174941_c = mipmapIn;
        if (blurIn) {
            i = mipmapIn ? 9987 : 9729;
            j = 9729;
        } else {
            i = mipmapIn ? 9986 : 9728;
            j = 9728;
        }
        GlStateManager.func_227677_b_(3553, 10241, i);
        GlStateManager.func_227677_b_(3553, 10240, j);
    }

    public void setBlurMipmap(boolean blur, boolean mipmap) {
        this.lastBlur = this.field_174940_b;
        this.lastMipmap = this.field_174941_c;
        this.func_174937_a(blur, mipmap);
    }

    public void restoreLastBlurMipmap() {
        this.func_174937_a(this.lastBlur, this.lastMipmap);
    }

    public int func_110552_b() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (this.field_110553_a == -1) {
            this.field_110553_a = TextureUtil.func_225678_a_();
        }
        return this.field_110553_a;
    }

    public void func_147631_c() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                if (this.field_110553_a != -1) {
                    TextureUtil.func_225679_a_((int)this.field_110553_a);
                    this.field_110553_a = -1;
                }
            });
        } else if (this.field_110553_a != -1) {
            TextureUtil.func_225679_a_((int)this.field_110553_a);
            this.field_110553_a = -1;
        }
    }

    public abstract void func_195413_a(IResourceManager var1) throws IOException;

    public void func_229148_d_() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GlStateManager.func_227760_t_(this.func_110552_b()));
        } else {
            GlStateManager.func_227760_t_(this.func_110552_b());
        }
    }

    public void func_215244_a(TextureManager textureManagerIn, IResourceManager resourceManagerIn, ResourceLocation resourceLocationIn, Executor executorIn) {
        textureManagerIn.func_229263_a_(resourceLocationIn, this);
    }
}

