/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.client;

import com.feed_the_beast.mods.ftbchunks.client.FTBChunksClient;
import com.feed_the_beast.mods.ftbchunks.client.LargeMapScreen;
import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapChunk;
import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapDimension;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkManagerImpl;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import com.feed_the_beast.mods.ftbchunks.net.FTBChunksNet;
import com.feed_the_beast.mods.ftbchunks.net.RequestChunkChangePacket;
import com.feed_the_beast.mods.ftbchunks.net.RequestMapDataPacket;
import com.feed_the_beast.mods.ftbchunks.net.RequestPlayerListPacket;
import com.feed_the_beast.mods.ftbchunks.net.SendGeneralDataPacket;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.TextFormatting;

public class ChunkScreen
extends GuiBase {
    public List<ChunkButton> chunkButtons;
    public Set<XZ> selectedChunks;

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void addWidgets() {
        int sx = this.getX() + (this.width - 240) / 2;
        int sy = this.getY() + (this.height - 240) / 2;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        int startX = player.field_70176_ah - 7;
        int startZ = player.field_70164_aj - 7;
        this.chunkButtons = new ArrayList<ChunkButton>();
        this.selectedChunks = new LinkedHashSet<XZ>();
        for (int z = 0; z < 15; ++z) {
            for (int x = 0; x < 15; ++x) {
                ChunkButton button = new ChunkButton((Panel)this, XZ.of(startX + x, startZ + z));
                button.chunk = ClientMapDimension.current.getRegion(XZ.regionFromChunk(startX + x, startZ + z)).getChunk(button.chunkPos);
                this.chunkButtons.add(button);
                button.setPos(sx + x * 16, sy + z * 16);
            }
        }
        this.addAll(this.chunkButtons);
        FTBChunksNet.MAIN.sendToServer((Object)new RequestMapDataPacket(player.field_70176_ah - 7, player.field_70164_aj - 7, player.field_70176_ah + 7, player.field_70164_aj + 7));
        this.add(new SimpleButton((Panel)this, I18n.func_135052_a((String)"ftbchunks.gui.large_map", (Object[])new Object[0]), GuiIcons.MAP, (simpleButton, mouseButton) -> new LargeMapScreen().openGui()).setPosAndSize(1, 1, 16, 16));
        this.add(new SimpleButton((Panel)this, I18n.func_135052_a((String)"ftbchunks.gui.allies", (Object[])new Object[0]), GuiIcons.FRIENDS, (simpleButton, mouseButton) -> FTBChunksNet.MAIN.sendToServer((Object)new RequestPlayerListPacket())).setPosAndSize(1, 19, 16, 16));
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        if (!this.selectedChunks.isEmpty()) {
            FTBChunksNet.MAIN.sendToServer((Object)new RequestChunkChangePacket(ChunkScreen.isShiftKeyDown() ? (button.isLeft() ? 2 : 3) : (button.isLeft() ? 0 : 1), this.selectedChunks));
            this.selectedChunks.clear();
            this.playClickSound();
        }
    }

    public boolean keyPressed(Key key) {
        if (key.is(70)) {
            new LargeMapScreen().openGui();
            return true;
        }
        return super.keyPressed(key);
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        int sx = x + (w - 240) / 2;
        int sy = y + (h - 240) / 2;
        int r = 70;
        int g = 70;
        int b = 70;
        int a = 100;
        RenderSystem.lineWidth((float)Math.max(2.5f, (float)Minecraft.func_71410_x().func_228018_at_().func_198109_k() / 1920.0f * 2.5f));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.enableTexture();
        RenderSystem.bindTexture((int)FTBChunksClient.minimapTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        GuiHelper.drawTexturedRect((int)sx, (int)sy, (int)240, (int)240, (Color4I)Color4I.WHITE, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        if (!InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)258)) {
            ClientMapChunk chunk;
            GlStateManager.func_227621_I_();
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            for (int gy = 1; gy < 15; ++gy) {
                buffer.func_225582_a_((double)sx, (double)(sy + gy * 16), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
                buffer.func_225582_a_((double)(sx + 240), (double)(sy + gy * 16), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            }
            for (int gx = 1; gx < 15; ++gx) {
                buffer.func_225582_a_((double)(sx + gx * 16), (double)sy, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
                buffer.func_225582_a_((double)(sx + gx * 16), (double)(sy + 240), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            }
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (ChunkButton button : this.chunkButtons) {
                chunk = button.chunk;
                if (chunk.claimedDate == null) continue;
                int cr = chunk.color >> 16 & 0xFF;
                int cg = chunk.color >> 8 & 0xFF;
                int cb = chunk.color >> 0 & 0xFF;
                int cx = button.getX();
                int cy = button.getY();
                this.rect(buffer, cx, cy, 16, 16, cr, cg, cb, 100);
                int borders = 15;
                if (!chunk.connects(chunk.region.dimension.getChunk(button.chunkPos.offset(0, -1)))) {
                    this.rect(buffer, cx, cy, 16, 1, cr, cg, cb, 255);
                }
                if (!chunk.connects(chunk.region.dimension.getChunk(button.chunkPos.offset(0, 1)))) {
                    this.rect(buffer, cx, cy + 16 - 1, 16, 1, cr, cg, cb, 255);
                }
                if (!chunk.connects(chunk.region.dimension.getChunk(button.chunkPos.offset(-1, 0)))) {
                    this.rect(buffer, cx, cy, 1, 16, cr, cg, cb, 255);
                }
                if (chunk.connects(chunk.region.dimension.getChunk(button.chunkPos.offset(1, 0)))) continue;
                this.rect(buffer, cx + 16 - 1, cy, 1, 16, cr, cg, cb, 255);
            }
            tessellator.func_78381_a();
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            for (ChunkButton button : this.chunkButtons) {
                chunk = button.chunk;
                if (chunk.forceLoadedDate == null) continue;
                int cx = button.getX();
                int cy = button.getY();
                buffer.func_225582_a_((double)cx, (double)cy, 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                buffer.func_225582_a_((double)(cx + 16), (double)(cy + 16), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                buffer.func_225582_a_((double)((float)cx + 8.0f), (double)cy, 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                buffer.func_225582_a_((double)(cx + 16), (double)((float)cy + 8.0f), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                buffer.func_225582_a_((double)cx, (double)((float)cy + 8.0f), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                buffer.func_225582_a_((double)((float)cx + 8.0f), (double)(cy + 16), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        GlStateManager.func_227619_H_();
        GlStateManager.func_227701_d_((float)1.0f);
        SendGeneralDataPacket d = FTBChunksClient.generalData;
        if (d != null) {
            ArrayList<String> list = new ArrayList<String>(4);
            list.add(I18n.func_135052_a((String)"ftbchunks.gui.claimed", (Object[])new Object[0]));
            list.add((d.claimed > d.maxClaimed ? TextFormatting.RED : (d.claimed == d.maxClaimed ? TextFormatting.YELLOW : TextFormatting.GREEN)) + "" + d.claimed + " / " + d.maxClaimed);
            list.add(I18n.func_135052_a((String)"ftbchunks.gui.force_loaded", (Object[])new Object[0]));
            list.add((d.loaded > d.maxLoaded ? TextFormatting.RED : (d.loaded == d.maxLoaded ? TextFormatting.YELLOW : TextFormatting.GREEN)) + "" + d.loaded + " / " + d.maxLoaded);
            for (int i = 0; i < list.size(); ++i) {
                theme.drawString((String)list.get(i), 3.0f, (float)(this.getScreen().func_198087_p() - 10 * (list.size() - i) - 1), Color4I.WHITE, 2);
            }
        }
    }

    private void rect(BufferBuilder buffer, int x, int y, int w, int h, int r, int g, int b, int a) {
        buffer.func_225582_a_((double)x, (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)(x + w), (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)(x + w), (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
    }

    public class ChunkButton
    extends Button {
        public final XZ chunkPos;
        public ClientMapChunk chunk;

        public ChunkButton(Panel panel, XZ xz) {
            super(panel, "", (Icon)Icon.EMPTY);
            this.setSize(16, 16);
            this.chunkPos = xz;
        }

        public void onClicked(MouseButton mouseButton) {
            ChunkScreen.this.selectedChunks.add(this.chunkPos);
        }

        public void drawBackground(Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver() || ChunkScreen.this.selectedChunks.contains(this.chunkPos)) {
                Color4I.WHITE.withAlpha(100).draw(x, y, w, h);
                if (ChunkButton.isMouseButtonDown((MouseButton)MouseButton.LEFT) || ChunkButton.isMouseButtonDown((MouseButton)MouseButton.RIGHT)) {
                    ChunkScreen.this.selectedChunks.add(this.chunkPos);
                }
            }
        }

        public void addMouseOverText(List<String> list) {
            if (this.chunk != null && !this.chunk.formattedOwner.isEmpty()) {
                list.add(this.chunk.formattedOwner);
                Date date = new Date();
                if (Screen.hasAltDown()) {
                    list.add(TextFormatting.GRAY + this.chunk.claimedDate.toLocaleString());
                } else {
                    list.add(TextFormatting.GRAY + ClaimedChunkManagerImpl.prettyTimeString((date.getTime() - this.chunk.claimedDate.getTime()) / 1000L) + " ago");
                }
                if (this.chunk.forceLoadedDate != null) {
                    list.add(TextFormatting.RED + I18n.func_135052_a((String)"ftbchunks.gui.force_loaded", (Object[])new Object[0]));
                    if (Screen.hasAltDown()) {
                        list.add(TextFormatting.GRAY + this.chunk.forceLoadedDate.toLocaleString());
                    } else {
                        list.add(TextFormatting.GRAY + ClaimedChunkManagerImpl.prettyTimeString((date.getTime() - this.chunk.forceLoadedDate.getTime()) / 1000L) + " ago");
                    }
                }
            }
        }
    }
}

