/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IAlloyInteraction;
import mekanism.api.block.IHasTileEntity;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.AlloyTier;
import mekanism.api.tier.BaseTier;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;

public abstract class TileEntityTransmitter<A, N extends DynamicNetwork<A, N, BUFFER>, BUFFER>
extends TileEntitySidedPipe
implements IAlloyInteraction {
    @Nonnull
    public TransmitterImpl<A, N, BUFFER> transmitterDelegate = new TransmitterImpl(this);

    public TileEntityTransmitter(IBlockProvider blockProvider) {
        super((TileEntityType<? extends TileEntitySidedPipe>)((IHasTileEntity)blockProvider.getBlock()).getTileType());
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.ALLOY_INTERACTION_CAPABILITY, this));
        this.addCapabilityResolver(BasicCapabilityResolver.persistent(Capabilities.GRID_TRANSMITTER_CAPABILITY, this::getTransmitter));
    }

    @Nonnull
    public TransmitterImpl<A, N, BUFFER> getTransmitter() {
        return this.transmitterDelegate;
    }

    public abstract N createNewNetwork();

    public abstract N createNewNetworkWithID(UUID var1);

    public abstract N createNetworkByMerging(Collection<N> var1);

    @Override
    public void onWorldJoin() {
        if (!this.isRemote()) {
            TransmitterNetworkRegistry.registerOrphanTransmitter(this.getTransmitter());
        }
    }

    @Override
    public void onChunkUnloaded() {
        if (!this.isRemote()) {
            this.getTransmitter().takeShare();
        }
        super.onChunkUnloaded();
    }

    @Override
    public void onWorldSeparate() {
        if (this.isRemote()) {
            this.getTransmitter().setTransmitterNetwork(null);
        } else {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        }
    }

    @Override
    public void markDirtyTransmitters() {
        super.markDirtyTransmitters();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        }
    }

    @Override
    public void markDirtyAcceptor(Direction side) {
        super.markDirtyAcceptor(side);
        if (this.getTransmitter().hasTransmitterNetwork()) {
            ((DynamicNetwork)this.getTransmitter().getTransmitterNetwork()).acceptorChanged(this.getTransmitter(), side);
        }
    }

    protected boolean canHaveIncompatibleNetworks() {
        return false;
    }

    @Override
    protected void recheckConnections(byte newlyEnabledTransmitters) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            if (this.canHaveIncompatibleNetworks()) {
                for (Direction side : EnumUtils.DIRECTIONS) {
                    if (!TileEntityTransmitter.connectionMapContainsSide(newlyEnabledTransmitters, side)) continue;
                    this.recheckConnectionPrechecked(side);
                }
            }
        } else {
            super.recheckConnections(newlyEnabledTransmitters);
        }
    }

    @Override
    protected void recheckConnection(Direction side) {
        if (this.canHaveIncompatibleNetworks() && this.getTransmitter().hasTransmitterNetwork()) {
            this.recheckConnectionPrechecked(side);
        }
    }

    private void recheckConnectionPrechecked(Direction side) {
        TileEntityTransmitter other = MekanismUtils.getTileEntity(TileEntityTransmitter.class, (IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(side));
        if (other != null) {
            Object otherNetwork;
            Object network = this.getTransmitter().getTransmitterNetwork();
            if (other.canHaveIncompatibleNetworks() && other.getTransmitter().hasTransmitterNetwork() && network != (otherNetwork = other.getTransmitter().getTransmitterNetwork()) && ((DynamicNetwork)network).isCompatibleWith(otherNetwork)) {
                if (this.noBufferOrFallback()) {
                    Object tempNetwork = network;
                    network = otherNetwork;
                    otherNetwork = tempNetwork;
                }
                ((DynamicNetwork)network).adoptTransmittersAndAcceptorsFrom(otherNetwork);
                ArrayList otherTransmitters = new ArrayList(((DynamicNetwork)otherNetwork).getTransmitters());
                ((DynamicNetwork)otherNetwork).deregister();
                ((DynamicNetwork)network).commit();
                ((DynamicNetwork)network).clampBuffer();
                other.refreshConnections(side.func_176734_d());
                for (IGridTransmitter iGridTransmitter : otherTransmitters) {
                    iGridTransmitter.setRequestsUpdate();
                }
            }
        }
    }

    public void requestsUpdate() {
        if (this.canHaveIncompatibleNetworks()) {
            byte possibleTransmitters = this.getPossibleTransmitterConnections();
            byte possibleAcceptors = this.getPossibleAcceptorConnections();
            byte allPossibleConnections = (byte)(possibleTransmitters | possibleAcceptors);
            byte allCurrentConnections = this.getAllCurrentConnections();
            this.currentTransmitterConnections = possibleTransmitters;
            this.currentAcceptorConnections = possibleAcceptors;
            if (allPossibleConnections != allCurrentConnections) {
                byte changedTransmitters = (byte)(allPossibleConnections ^ allCurrentConnections);
                for (Direction side : EnumUtils.DIRECTIONS) {
                    TileEntitySidedPipe tile;
                    if (!TileEntityTransmitter.connectionMapContainsSide(changedTransmitters, side) || (tile = MekanismUtils.getTileEntity(TileEntitySidedPipe.class, (IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(side))) == null) continue;
                    tile.refreshConnections(side.func_176734_d());
                }
            }
        }
        this.sendUpdatePacket();
    }

    @Override
    public boolean isValidTransmitter(TileEntity tile) {
        TileEntityTransmitter other;
        if (tile instanceof TileEntityTransmitter && this.canHaveIncompatibleNetworks() && (other = (TileEntityTransmitter)tile).canHaveIncompatibleNetworks()) {
            if (this.getTransmitter().hasTransmitterNetwork() && other.getTransmitter().isOrphan()) {
                return false;
            }
            if (other.getTransmitter().hasTransmitterNetwork() && this.getTransmitter().isOrphan()) {
                return false;
            }
        }
        return true;
    }

    public abstract A getCachedAcceptor(Direction var1);

    protected TileEntity getCachedTile(Direction side) {
        TileEntitySidedPipe.ConnectionType type = this.connectionTypes[side.ordinal()];
        if (type == TileEntitySidedPipe.ConnectionType.PULL || type == TileEntitySidedPipe.ConnectionType.NONE) {
            return null;
        }
        return TileEntityTransmitter.connectionMapContainsSide(this.currentAcceptorConnections, side) ? this.cachedAcceptors[side.ordinal()] : null;
    }

    @Override
    public void onAlloyInteraction(PlayerEntity player, Hand hand, ItemStack stack, @Nonnull AlloyTier tier) {
        if (this.func_145831_w() != null && this.getTransmitter().hasTransmitterNetwork()) {
            Object transmitterNetwork = this.getTransmitter().getTransmitterNetwork();
            ArrayList list = new ArrayList(((DynamicNetwork)transmitterNetwork).getTransmitters());
            list.sort((o1, o2) -> {
                if (o1 != null && o2 != null) {
                    BlockPos o1Pos = o1.coord().getPos();
                    BlockPos o2Pos = o2.coord().getPos();
                    return Double.compare(o1Pos.func_177951_i((Vec3i)this.func_174877_v()), o2Pos.func_177951_i((Vec3i)this.func_174877_v()));
                }
                return 0;
            });
            int upgraded = 0;
            for (IGridTransmitter iGridTransmitter : list) {
                BlockState upgradeState;
                BlockState state;
                if (!(iGridTransmitter instanceof TransmitterImpl)) continue;
                TransmitterImpl transmitter = (TransmitterImpl)iGridTransmitter;
                TileEntityTransmitter t = transmitter.containingTile;
                if (!t.canUpgrade(tier) || (state = t.func_195044_w()) == (upgradeState = t.upgradeResult(state, tier.getBaseTier()))) continue;
                transmitter.takeShare();
                transmitter.setTransmitterNetwork(null);
                TransmitterUpgradeData upgradeData = t.getUpgradeData();
                if (upgradeData == null) {
                    Mekanism.logger.warn("Got no upgrade data for transmitter at position: {} in {} but it said it would be able to provide some.", (Object)t.func_174877_v(), (Object)t.func_145831_w());
                    continue;
                }
                t.func_145831_w().func_175656_a(t.func_174877_v(), upgradeState);
                TileEntityTransmitter upgradedTile = MekanismUtils.getTileEntity(TileEntityTransmitter.class, (IBlockReader)t.func_145831_w(), t.func_174877_v());
                if (upgradedTile == null) {
                    Mekanism.logger.warn("Error upgrading transmitter at position: {} in {}.", (Object)t.func_174877_v(), (Object)t.func_145831_w());
                    continue;
                }
                upgradedTile.parseUpgradeData(upgradeData);
                if (++upgraded != 8) continue;
                break;
            }
            if (upgraded > 0) {
                ((DynamicNetwork)transmitterNetwork).invalidate();
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                    if (stack.func_190916_E() == 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                }
            }
        }
    }

    protected boolean canUpgrade(AlloyTier tier) {
        return false;
    }

    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        return current;
    }

    @Nullable
    protected TransmitterUpgradeData getUpgradeData() {
        return null;
    }

    protected void parseUpgradeData(@Nonnull TransmitterUpgradeData upgradeData) {
        Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
    }

    @Nonnull
    public FloatingLong getCapacityAsFloatingLong() {
        return FloatingLong.create(this.getCapacity());
    }

    public abstract long getCapacity();

    public abstract BUFFER getBuffer();

    public boolean noBufferOrFallback() {
        return this.getBufferWithFallback() == null;
    }

    @Nullable
    public BUFFER getBufferWithFallback() {
        BUFFER buffer = this.getBuffer();
        if (buffer == null && this.getTransmitter().hasTransmitterNetwork()) {
            return ((DynamicNetwork)this.getTransmitter().getTransmitterNetwork()).getBuffer();
        }
        return buffer;
    }

    public abstract void takeShare();

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        TransmitterImpl<A, N, BUFFER> transmitter = this.getTransmitter();
        if (transmitter.hasTransmitterNetwork()) {
            updateTag.func_186854_a("network", ((DynamicNetwork)transmitter.getTransmitterNetwork()).getUUID());
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        TransmitterImpl<A, N, BUFFER> transmitter = this.getTransmitter();
        if (tag.func_186855_b("network")) {
            UUID networkID = tag.func_186857_a("network");
            if (transmitter.hasTransmitterNetwork() && ((DynamicNetwork)transmitter.getTransmitterNetwork()).getUUID().equals(networkID)) {
                return;
            }
            TransmitterNetworkRegistry networkRegistry = TransmitterNetworkRegistry.getInstance();
            DynamicNetwork<?, ?, ?> clientNetwork = networkRegistry.getClientNetwork(networkID);
            if (clientNetwork == null) {
                N network = transmitter.createEmptyNetworkWithID(networkID);
                ((DynamicNetwork)network).register();
                transmitter.setTransmitterNetwork(network);
                ((DynamicNetwork)network).updateCapacity();
                this.handleContentsUpdateTag(network, tag);
            } else {
                clientNetwork.register();
                transmitter.setTransmitterNetwork(clientNetwork);
                clientNetwork.updateCapacity();
            }
        } else {
            transmitter.setTransmitterNetwork(null);
        }
    }

    protected void handleContentsUpdateTag(@Nonnull N network, @Nonnull CompoundNBT tag) {
    }
}

