/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.EnumSet;
import java.util.function.Supplier;
import mekanism.api.Pos3D;
import mekanism.api.Upgrade;
import mekanism.api.math.FloatingLong;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.AttributeUpgradeable;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.BlockShapes;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.blocktype.Factory;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.inventory.container.ContainerProvider;
import mekanism.common.inventory.container.tile.DigitalMinerContainer;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.inventory.container.tile.FormulaicAssemblicatorContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.container.tile.OredictionificatorContainer;
import mekanism.common.inventory.container.tile.PersonalChestTileContainer;
import mekanism.common.inventory.container.tile.QuantumEntangloporterContainer;
import mekanism.common.inventory.container.tile.SecurityDeskContainer;
import mekanism.common.inventory.container.tile.TeleporterContainer;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tier.BinTier;
import mekanism.common.tier.EnergyCubeTier;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tier.GasTankTier;
import mekanism.common.tier.InductionCellTier;
import mekanism.common.tier.InductionProviderTier;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.tile.TileEntityBoilerValve;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.TileEntityChemicalCrystallizer;
import mekanism.common.tile.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.TileEntityChemicalInfuser;
import mekanism.common.tile.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.TileEntityChemicalOxidizer;
import mekanism.common.tile.TileEntityChemicalWasher;
import mekanism.common.tile.TileEntityCombiner;
import mekanism.common.tile.TileEntityCrusher;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityDynamicValve;
import mekanism.common.tile.TileEntityElectricPump;
import mekanism.common.tile.TileEntityElectrolyticSeparator;
import mekanism.common.tile.TileEntityEnergizedSmelter;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityEnrichmentChamber;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityFluidicPlenisher;
import mekanism.common.tile.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.TileEntityFuelwoodHeater;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionPort;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityMetallurgicInfuser;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.tile.TileEntityOsmiumCompressor;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.tile.TileEntityPrecisionSawmill;
import mekanism.common.tile.TileEntityPressurizedReactionChamber;
import mekanism.common.tile.TileEntityPurificationChamber;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.tile.TileEntityRotaryCondensentrator;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.TileEntitySeismicVibrator;
import mekanism.common.tile.TileEntitySolarNeutronActivator;
import mekanism.common.tile.TileEntitySuperheatingElement;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.tile.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.tile.TileEntityThermalEvaporationValve;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.laser.TileEntityLaser;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.tile.laser.TileEntityLaserTractorBeam;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.text.ITextComponent;

public class MekanismBlockTypes {
    private static final FloatingLong LARGE_LASER = FloatingLong.createConst(5000000000L);
    private static final FloatingLong TELEPORTER_USAGE = FloatingLong.createConst(12500L);
    private static final FloatingLong HUNDRED = FloatingLong.createConst(100L);
    private static final FloatingLong TWENTY_FIVE = FloatingLong.createConst(25L);
    private static final Table<FactoryTier, FactoryType, Factory<?>> FACTORIES = HashBasedTable.create();
    public static final Machine.FactoryMachine<TileEntityEnrichmentChamber> ENRICHMENT_CHAMBER = (Machine.FactoryMachine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createFactoryMachine(() -> MekanismTileEntityTypes.ENRICHMENT_CHAMBER, MekanismLang.DESCRIPTION_ENRICHMENT_CHAMBER, FactoryType.ENRICHING).withGui(() -> MekanismContainerTypes.ENRICHMENT_CHAMBER)).withSound(MekanismSounds.ENRICHMENT_CHAMBER)).withEnergyConfig(MekanismConfig.usage.enrichmentChamber, MekanismConfig.storage.enrichmentChamber)).build();
    public static final Machine.FactoryMachine<TileEntityCrusher> CRUSHER = (Machine.FactoryMachine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createFactoryMachine(() -> MekanismTileEntityTypes.CRUSHER, MekanismLang.DESCRIPTION_CRUSHER, FactoryType.CRUSHING).withGui(() -> MekanismContainerTypes.CRUSHER)).withSound(MekanismSounds.CRUSHER)).withEnergyConfig(MekanismConfig.usage.crusher, MekanismConfig.storage.crusher)).build();
    public static final Machine.FactoryMachine<TileEntityEnergizedSmelter> ENERGIZED_SMELTER = (Machine.FactoryMachine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createFactoryMachine(() -> MekanismTileEntityTypes.ENERGIZED_SMELTER, MekanismLang.DESCRIPTION_ENERGIZED_SMELTER, FactoryType.SMELTING).withGui(() -> MekanismContainerTypes.ENERGIZED_SMELTER)).withSound(MekanismSounds.ENERGIZED_SMELTER)).withEnergyConfig(MekanismConfig.usage.energizedSmelter, MekanismConfig.storage.energizedSmelter)).build();
    public static final Machine.FactoryMachine<TileEntityPrecisionSawmill> PRECISION_SAWMILL = (Machine.FactoryMachine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createFactoryMachine(() -> MekanismTileEntityTypes.PRECISION_SAWMILL, MekanismLang.DESCRIPTION_PRECISION_SAWMILL, FactoryType.SAWING).withGui(() -> MekanismContainerTypes.PRECISION_SAWMILL)).withSound(MekanismSounds.PRECISION_SAWMILL)).withEnergyConfig(MekanismConfig.usage.precisionSawmill, MekanismConfig.storage.precisionSawmill)).build();
    public static final Machine.FactoryMachine<TileEntityOsmiumCompressor> OSMIUM_COMPRESSOR = (Machine.FactoryMachine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createFactoryMachine(() -> MekanismTileEntityTypes.OSMIUM_COMPRESSOR, MekanismLang.DESCRIPTION_OSMIUM_COMPRESSOR, FactoryType.COMPRESSING).withGui(() -> MekanismContainerTypes.OSMIUM_COMPRESSOR)).withSound(MekanismSounds.OSMIUM_COMPRESSOR)).withEnergyConfig(MekanismConfig.usage.osmiumCompressor, MekanismConfig.storage.osmiumCompressor)).build();
    public static final Machine.FactoryMachine<TileEntityCombiner> COMBINER = (Machine.FactoryMachine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createFactoryMachine(() -> MekanismTileEntityTypes.COMBINER, MekanismLang.DESCRIPTION_COMBINER, FactoryType.COMBINING).withGui(() -> MekanismContainerTypes.COMBINER)).withSound(MekanismSounds.COMBINER)).withEnergyConfig(MekanismConfig.usage.combiner, MekanismConfig.storage.combiner)).build();
    public static final Machine.FactoryMachine<TileEntityMetallurgicInfuser> METALLURGIC_INFUSER = (Machine.FactoryMachine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createFactoryMachine(() -> MekanismTileEntityTypes.METALLURGIC_INFUSER, MekanismLang.DESCRIPTION_METALLURGIC_INFUSER, FactoryType.INFUSING).withGui(() -> MekanismContainerTypes.METALLURGIC_INFUSER)).withSound(MekanismSounds.METALLURGIC_INFUSER)).withEnergyConfig(MekanismConfig.usage.metallurgicInfuser, MekanismConfig.storage.metallurgicInfuser)).withCustomShape(BlockShapes.METALLURGIC_INFUSER)).build();
    public static final Machine.FactoryMachine<TileEntityPurificationChamber> PURIFICATION_CHAMBER = (Machine.FactoryMachine)((BlockType.BlockTypeBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createFactoryMachine(() -> MekanismTileEntityTypes.PURIFICATION_CHAMBER, MekanismLang.DESCRIPTION_PURIFICATION_CHAMBER, FactoryType.PURIFYING).withGui(() -> MekanismContainerTypes.PURIFICATION_CHAMBER)).withSound(MekanismSounds.PURIFICATION_CHAMBER)).withEnergyConfig(MekanismConfig.usage.purificationChamber, MekanismConfig.storage.purificationChamber)).withSupportedUpgrades(EnumSet.of(Upgrade.SPEED, Upgrade.ENERGY, Upgrade.MUFFLING, Upgrade.GAS))).build();
    public static final Machine.FactoryMachine<TileEntityChemicalInjectionChamber> CHEMICAL_INJECTION_CHAMBER = (Machine.FactoryMachine)((BlockType.BlockTypeBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createFactoryMachine(() -> MekanismTileEntityTypes.CHEMICAL_INJECTION_CHAMBER, MekanismLang.DESCRIPTION_CHEMICAL_INJECTION_CHAMBER, FactoryType.INJECTING).withGui(() -> MekanismContainerTypes.CHEMICAL_INJECTION_CHAMBER)).withSound(MekanismSounds.CHEMICAL_INJECTION_CHAMBER)).withEnergyConfig(MekanismConfig.usage.chemicalInjectionChamber, MekanismConfig.storage.chemicalInjectionChamber)).withSupportedUpgrades(EnumSet.of(Upgrade.SPEED, Upgrade.ENERGY, Upgrade.MUFFLING, Upgrade.GAS))).build();
    public static final Machine<TileEntityPressurizedReactionChamber> PRESSURIZED_REACTION_CHAMBER = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.PRESSURIZED_REACTION_CHAMBER, MekanismLang.DESCRIPTION_PRESSURIZED_REACTION_CHAMBER).withGui(() -> MekanismContainerTypes.PRESSURIZED_REACTION_CHAMBER)).withSound(MekanismSounds.PRESSURIZED_REACTION_CHAMBER)).withEnergyConfig(MekanismConfig.usage.pressurizedReactionBase, MekanismConfig.storage.pressurizedReactionBase)).withCustomShape(BlockShapes.PRESSURIZED_REACTION_CHAMBER)).build();
    public static final Machine<TileEntityChemicalCrystallizer> CHEMICAL_CRYSTALLIZER = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.CHEMICAL_CRYSTALLIZER, MekanismLang.DESCRIPTION_CHEMICAL_CRYSTALLIZER).withGui(() -> MekanismContainerTypes.CHEMICAL_CRYSTALLIZER)).withSound(MekanismSounds.CHEMICAL_CRYSTALLIZER)).withEnergyConfig(MekanismConfig.usage.chemicalCrystallizer, MekanismConfig.storage.chemicalCrystallizer)).withCustomShape(BlockShapes.CHEMICAL_CRYSTALLIZER)).build();
    public static final Machine<TileEntityChemicalDissolutionChamber> CHEMICAL_DISSOLUTION_CHAMBER = (Machine)((Machine.MachineBuilder)((BlockType.BlockTypeBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.CHEMICAL_DISSOLUTION_CHAMBER, MekanismLang.DESCRIPTION_CHEMICAL_DISSOLUTION_CHAMBER).withGui(() -> MekanismContainerTypes.CHEMICAL_DISSOLUTION_CHAMBER)).withSound(MekanismSounds.CHEMICAL_DISSOLUTION_CHAMBER)).withEnergyConfig(MekanismConfig.usage.chemicalDissolutionChamber, MekanismConfig.storage.chemicalDissolutionChamber)).withSupportedUpgrades(EnumSet.of(Upgrade.SPEED, Upgrade.ENERGY, Upgrade.MUFFLING, Upgrade.GAS))).withCustomShape(BlockShapes.CHEMICAL_DISSOLUTION_CHAMBER)).build();
    public static final Machine<TileEntityChemicalInfuser> CHEMICAL_INFUSER = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.CHEMICAL_INFUSER, MekanismLang.DESCRIPTION_CHEMICAL_INFUSER).withGui(() -> MekanismContainerTypes.CHEMICAL_INFUSER)).withSound(MekanismSounds.CHEMICAL_INFUSER)).withEnergyConfig(MekanismConfig.usage.chemicalInfuser, MekanismConfig.storage.chemicalInfuser)).withCustomShape(BlockShapes.CHEMICAL_INFUSER)).build();
    public static final Machine<TileEntityChemicalOxidizer> CHEMICAL_OXIDIZER = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.CHEMICAL_OXIDIZER, MekanismLang.DESCRIPTION_CHEMICAL_OXIDIZER).withGui(() -> MekanismContainerTypes.CHEMICAL_OXIDIZER)).withSound(MekanismSounds.CHEMICAL_OXIDIZER)).withEnergyConfig(MekanismConfig.usage.oxidationChamber, MekanismConfig.storage.oxidationChamber)).withCustomShape(BlockShapes.CHEMICAL_OXIDIZER)).build();
    public static final Machine<TileEntityChemicalWasher> CHEMICAL_WASHER = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.CHEMICAL_WASHER, MekanismLang.DESCRIPTION_CHEMICAL_WASHER).withGui(() -> MekanismContainerTypes.CHEMICAL_WASHER)).withSound(MekanismSounds.CHEMICAL_WASHER)).withEnergyConfig(MekanismConfig.usage.chemicalWasher, MekanismConfig.storage.chemicalWasher)).withCustomShape(BlockShapes.CHEMICAL_WASHER)).build();
    public static final Machine<TileEntityRotaryCondensentrator> ROTARY_CONDENSENTRATOR = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.ROTARY_CONDENSENTRATOR, MekanismLang.DESCRIPTION_ROTARY_CONDENSENTRATOR).withGui(() -> MekanismContainerTypes.ROTARY_CONDENSENTRATOR)).withSound(MekanismSounds.ROTARY_CONDENSENTRATOR)).withEnergyConfig(MekanismConfig.usage.rotaryCondensentrator, MekanismConfig.storage.rotaryCondensentrator)).withCustomShape(BlockShapes.ROTARY_CONDENSENTRATOR)).build();
    public static final Machine<TileEntityElectrolyticSeparator> ELECTROLYTIC_SEPARATOR = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.ELECTROLYTIC_SEPARATOR, MekanismLang.DESCRIPTION_ELECTROLYTIC_SEPARATOR).withGui(() -> MekanismContainerTypes.ELECTROLYTIC_SEPARATOR)).withSound(MekanismSounds.ELECTROLYTIC_SEPARATOR)).withEnergyConfig(() -> ((FloatingLong)MekanismConfig.general.FROM_H2.get()).multiply(2L), MekanismConfig.storage.electrolyticSeparator)).withCustomShape(BlockShapes.ELECTROLYTIC_SEPARATOR)).build();
    public static final Machine<TileEntityDigitalMiner> DIGITAL_MINER = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((BlockTypeTile.BlockTileBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.DIGITAL_MINER, MekanismLang.DESCRIPTION_DIGITAL_MINER).withGui(() -> MekanismContainerTypes.DIGITAL_MINER)).withEnergyConfig(MekanismConfig.usage.digitalMiner, MekanismConfig.storage.digitalMiner)).withSupportedUpgrades(EnumSet.of(Upgrade.SPEED, Upgrade.ENERGY, Upgrade.ANCHOR))).withCustomContainer(tile -> new ContainerProvider((ITextComponent)TextComponentUtil.translate(tile.getBlockType().func_149739_a(), new Object[0]), (i, inv, player) -> new DigitalMinerContainer(i, inv, (TileEntityDigitalMiner)tile)))).withCustomShape(BlockShapes.DIGITAL_MINER)).with(new Attributes.AttributeCustomSelectionBox())).build();
    public static final Machine<TileEntityFormulaicAssemblicator> FORMULAIC_ASSEMBLICATOR = (Machine)((Machine.MachineBuilder)((BlockTypeTile.BlockTileBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.FORMULAIC_ASSEMBLICATOR, MekanismLang.DESCRIPTION_FORMULAIC_ASSEMBLICATOR).withGui(() -> MekanismContainerTypes.FORMULAIC_ASSEMBLICATOR)).withEnergyConfig(MekanismConfig.usage.formulaicAssemblicator, MekanismConfig.storage.formulaicAssemblicator)).withSupportedUpgrades(EnumSet.of(Upgrade.SPEED, Upgrade.ENERGY))).withCustomContainer(tile -> new ContainerProvider((ITextComponent)TextComponentUtil.translate(tile.getBlockType().func_149739_a(), new Object[0]), (i, inv, player) -> new FormulaicAssemblicatorContainer(i, inv, (TileEntityFormulaicAssemblicator)tile)))).build();
    public static final Machine<TileEntityElectricPump> ELECTRIC_PUMP = (Machine)((Machine.MachineBuilder)((BlockType.BlockTypeBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.ELECTRIC_PUMP, MekanismLang.DESCRIPTION_ELECTRIC_PUMP).withGui(() -> MekanismContainerTypes.ELECTRIC_PUMP)).withEnergyConfig(MekanismConfig.usage.electricPump, MekanismConfig.storage.electricPump)).withSupportedUpgrades(EnumSet.of(Upgrade.SPEED, Upgrade.ENERGY, Upgrade.FILTER))).withCustomShape(BlockShapes.ELECTRIC_PUMP)).build();
    public static final Machine<TileEntityFluidicPlenisher> FLUIDIC_PLENISHER = (Machine)((Machine.MachineBuilder)((BlockType.BlockTypeBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.FLUIDIC_PLENISHER, MekanismLang.DESCRIPTION_FLUIDIC_PLENISHER).withGui(() -> MekanismContainerTypes.FLUIDIC_PLENISHER)).withEnergyConfig(MekanismConfig.usage.fluidicPlenisher, MekanismConfig.storage.fluidicPlenisher)).withSupportedUpgrades(EnumSet.of(Upgrade.SPEED, Upgrade.ENERGY))).withCustomShape(BlockShapes.FLUIDIC_PLENISHER)).build();
    public static final Machine<TileEntitySolarNeutronActivator> SOLAR_NEUTRON_ACTIVATOR = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((BlockType.BlockTypeBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.SOLAR_NEUTRON_ACTIVATOR, MekanismLang.DESCRIPTION_SOLAR_NEUTRON_ACTIVATOR).withGui(() -> MekanismContainerTypes.SOLAR_NEUTRON_ACTIVATOR)).without(AttributeParticleFX.class)).withSupportedUpgrades(EnumSet.of(Upgrade.SPEED))).withCustomShape(BlockShapes.SOLAR_NEUTRON_ACTIVATOR)).with(new Attributes.AttributeCustomSelectionBox())).build();
    public static final Machine<TileEntityTeleporter> TELEPORTER = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((BlockType.BlockTypeBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.TELEPORTER, MekanismLang.DESCRIPTION_TELEPORTER).withGui(() -> MekanismContainerTypes.TELEPORTER)).withEnergyConfig(() -> TELEPORTER_USAGE, MekanismConfig.storage.teleporter)).withSupportedUpgrades(EnumSet.of(Upgrade.ANCHOR))).without(AttributeStateActive.class, AttributeStateFacing.class, AttributeParticleFX.class)).withCustomContainer(tile -> new ContainerProvider((ITextComponent)TextComponentUtil.translate(tile.getBlockType().func_149739_a(), new Object[0]), (i, inv, player) -> new TeleporterContainer(i, inv, (TileEntityTeleporter)tile)))).build();
    public static final BlockTypeTile<TileEntityChargepad> CHARGEPAD = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.CHARGEPAD, MekanismLang.DESCRIPTION_CHARGEPAD).withEnergyConfig(() -> TWENTY_FIVE, MekanismConfig.storage.chargePad)).withSound(MekanismSounds.CHARGEPAD)).with(new AttributeStateActive(), new AttributeStateFacing())).withCustomShape(BlockShapes.CHARGEPAD)).build();
    public static final BlockTypeTile<TileEntityLaser> LASER = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.LASER, MekanismLang.DESCRIPTION_LASER).withEnergyConfig(MekanismConfig.usage.laser, MekanismConfig.storage.laser)).withSound(MekanismSounds.LASER)).with(new AttributeStateActive(), new AttributeStateFacing(BlockStateHelper.facingProperty))).withCustomShape(BlockShapes.LASER)).build();
    public static final BlockTypeTile<TileEntityLaserAmplifier> LASER_AMPLIFIER = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.LASER_AMPLIFIER, MekanismLang.DESCRIPTION_LASER_AMPLIFIER).withGui(() -> MekanismContainerTypes.LASER_AMPLIFIER)).withEnergyConfig(null, () -> LARGE_LASER)).with(new AttributeStateFacing(BlockStateHelper.facingProperty), new Attributes.AttributeRedstoneEmitter<TileEntityMekanism>(TileEntityMekanism::getRedstoneLevel), new Attributes.AttributeRedstone(), new Attributes.AttributeComparator(), new Attributes.AttributeSecurity())).withCustomShape(BlockShapes.LASER_AMPLIFIER)).build();
    public static final BlockTypeTile<TileEntityLaserTractorBeam> LASER_TRACTOR_BEAM = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.LASER_TRACTOR_BEAM, MekanismLang.DESCRIPTION_LASER_TRACTOR_BEAM).withGui(() -> MekanismContainerTypes.LASER_TRACTOR_BEAM)).withEnergyConfig(null, () -> LARGE_LASER)).with(new AttributeStateFacing(BlockStateHelper.facingProperty), new Attributes.AttributeComparator(), new Attributes.AttributeSecurity(), new Attributes.AttributeInventory())).withCustomShape(BlockShapes.LASER_AMPLIFIER)).build();
    public static final Machine<TileEntityResistiveHeater> RESISTIVE_HEATER = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.RESISTIVE_HEATER, MekanismLang.DESCRIPTION_RESISTIVE_HEATER).withGui(() -> MekanismContainerTypes.RESISTIVE_HEATER)).withEnergyConfig(() -> HUNDRED, null)).without(Attributes.AttributeComparator.class, AttributeUpgradeSupport.class)).withCustomShape(BlockShapes.RESISTIVE_HEATER)).withSound(MekanismSounds.RESISTIVE_HEATER)).build();
    public static final Machine<TileEntitySeismicVibrator> SEISMIC_VIBRATOR = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.SEISMIC_VIBRATOR, MekanismLang.DESCRIPTION_SEISMIC_VIBRATOR).withGui(() -> MekanismContainerTypes.SEISMIC_VIBRATOR)).withEnergyConfig(MekanismConfig.usage.seismicVibrator, MekanismConfig.storage.seismicVibrator)).without(Attributes.AttributeComparator.class, AttributeParticleFX.class, AttributeUpgradeSupport.class)).withCustomShape(BlockShapes.SEISMIC_VIBRATOR)).with(new Attributes.AttributeCustomSelectionBox())).build();
    public static final BlockTypeTile<TileEntityPersonalChest> PERSONAL_CHEST = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.PERSONAL_CHEST, MekanismLang.DESCRIPTION_PERSONAL_CHEST).withGui(() -> MekanismContainerTypes.PERSONAL_CHEST_BLOCK)).withCustomContainer(tile -> new ContainerProvider((ITextComponent)TextComponentUtil.translate(tile.getBlockType().func_149739_a(), new Object[0]), (i, inv, player) -> new PersonalChestTileContainer(i, inv, (TileEntityPersonalChest)tile)))).with(new Attributes.AttributeSecurity(), new Attributes.AttributeInventory(), new AttributeStateActive(), new AttributeStateFacing(), new Attributes.AttributeCustomResistance(-1.0f))).withCustomShape(BlockShapes.PERSONAL_CHEST)).build();
    public static final BlockTypeTile<TileEntityFuelwoodHeater> FUELWOOD_HEATER = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.FUELWOOD_HEATER, MekanismLang.DESCRIPTION_FUELWOOD_HEATER).withGui(() -> MekanismContainerTypes.FUELWOOD_HEATER)).with(new Attributes.AttributeSecurity(), new Attributes.AttributeInventory(), new AttributeStateActive(), new AttributeStateFacing(), new AttributeParticleFX().add((IParticleData)ParticleTypes.field_197601_L, rand -> new Pos3D(rand.nextFloat() * 0.6f - 0.3f, rand.nextFloat() * 6.0f / 16.0f, -0.52)).add((IParticleData)RedstoneParticleData.field_197564_a, rand -> new Pos3D(rand.nextFloat() * 0.6f - 0.3f, rand.nextFloat() * 6.0f / 16.0f, -0.52)))).build();
    public static final BlockTypeTile<TileEntityOredictionificator> OREDICTIONIFICATOR = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.OREDICTIONIFICATOR, MekanismLang.DESCRIPTION_OREDICTIONIFICATOR).withGui(() -> MekanismContainerTypes.OREDICTIONIFICATOR)).withCustomContainer(tile -> new ContainerProvider((ITextComponent)TextComponentUtil.translate(tile.getBlockType().func_149739_a(), new Object[0]), (i, inv, player) -> new OredictionificatorContainer(i, inv, (TileEntityOredictionificator)tile)))).with(new Attributes.AttributeSecurity(), new Attributes.AttributeInventory(), new AttributeStateActive(), new AttributeStateFacing(), new Attributes.AttributeRedstone())).build();
    public static final Machine<TileEntityQuantumEntangloporter> QUANTUM_ENTANGLOPORTER = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((BlockType.BlockTypeBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.QUANTUM_ENTANGLOPORTER, MekanismLang.DESCRIPTION_QUANTUM_ENTANGLOPORTER).withGui(() -> MekanismContainerTypes.QUANTUM_ENTANGLOPORTER)).withEnergyConfig(null, null)).withSupportedUpgrades(EnumSet.of(Upgrade.ANCHOR))).with(new AttributeStateFacing(BlockStateHelper.facingProperty))).without(AttributeStateActive.class, AttributeParticleFX.class, Attributes.AttributeRedstone.class, Attributes.AttributeComparator.class)).withCustomShape(BlockShapes.QUANTUM_ENTANGLOPORTER)).withCustomContainer(tile -> new ContainerProvider((ITextComponent)TextComponentUtil.translate(tile.getBlockType().func_149739_a(), new Object[0]), (i, inv, player) -> new QuantumEntangloporterContainer(i, inv, (TileEntityQuantumEntangloporter)tile)))).build();
    public static final Machine<TileEntityLogisticalSorter> LOGISTICAL_SORTER = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((BlockType.BlockTypeBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> MekanismTileEntityTypes.LOGISTICAL_SORTER, MekanismLang.DESCRIPTION_LOGISTICAL_SORTER).withGui(() -> MekanismContainerTypes.LOGISTICAL_SORTER)).withSupportedUpgrades(EnumSet.of(Upgrade.MUFFLING))).with(new AttributeStateFacing(BlockStateHelper.facingProperty))).withCustomContainer(tile -> new ContainerProvider((ITextComponent)TextComponentUtil.translate(tile.getBlockType().func_149739_a(), new Object[0]), (i, inv, player) -> new EmptyTileContainer<TileEntityMekanism>(MekanismContainerTypes.LOGISTICAL_SORTER, i, inv, (TileEntityMekanism)tile)))).withCustomShape(BlockShapes.LOGISTICAL_SORTER)).withSound(MekanismSounds.LOGISTICAL_SORTER)).build();
    public static final BlockTypeTile<TileEntitySecurityDesk> SECURITY_DESK = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.SECURITY_DESK, MekanismLang.DESCRIPTION_SECURITY_DESK).withGui(() -> MekanismContainerTypes.SECURITY_DESK)).withCustomContainer(tile -> new ContainerProvider((ITextComponent)TextComponentUtil.translate(tile.getBlockType().func_149739_a(), new Object[0]), (i, inv, player) -> new SecurityDeskContainer(i, inv, (TileEntitySecurityDesk)tile)))).with(new Attributes.AttributeInventory(), new AttributeStateFacing(), new Attributes.AttributeCustomResistance(-1.0f))).withCustomShape(BlockShapes.SECURITY_DESK)).with(new Attributes.AttributeCustomSelectionBox())).build();
    public static final BlockTypeTile<TileEntityDynamicTank> DYNAMIC_TANK = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.DYNAMIC_TANK, MekanismLang.DESCRIPTION_DYNAMIC_TANK).withGui(() -> MekanismContainerTypes.DYNAMIC_TANK)).withCustomContainer(tile -> new ContainerProvider(MekanismLang.DYNAMIC_TANK, (i, inv, player) -> new MekanismTileContainer<TileEntityMekanism>(MekanismContainerTypes.DYNAMIC_TANK, i, inv, (TileEntityMekanism)tile)))).with(new Attributes.AttributeInventory())).build();
    public static final BlockTypeTile<TileEntityDynamicValve> DYNAMIC_VALVE = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.DYNAMIC_VALVE, MekanismLang.DESCRIPTION_DYNAMIC_VALVE).withGui(() -> MekanismContainerTypes.DYNAMIC_TANK)).withCustomContainer(tile -> new ContainerProvider(MekanismLang.DYNAMIC_TANK, (i, inv, player) -> new MekanismTileContainer<TileEntityMekanism>(MekanismContainerTypes.DYNAMIC_TANK, i, inv, (TileEntityMekanism)tile)))).with(new Attributes.AttributeInventory(), new Attributes.AttributeComparator())).build();
    public static final BlockTypeTile<TileEntityBoilerCasing> BOILER_CASING = (BlockTypeTile)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.BOILER_CASING, MekanismLang.DESCRIPTION_BOILER_CASING).withGui(() -> MekanismContainerTypes.THERMOELECTRIC_BOILER)).withCustomContainer(tile -> new ContainerProvider(MekanismLang.BOILER, (i, inv, player) -> new MekanismTileContainer<TileEntityMekanism>(MekanismContainerTypes.THERMOELECTRIC_BOILER, i, inv, (TileEntityMekanism)tile)))).build();
    public static final BlockTypeTile<TileEntityBoilerValve> BOILER_VALVE = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.BOILER_VALVE, MekanismLang.DESCRIPTION_BOILER_VALVE).withGui(() -> MekanismContainerTypes.THERMOELECTRIC_BOILER)).withCustomContainer(tile -> new ContainerProvider(MekanismLang.BOILER, (i, inv, player) -> new MekanismTileContainer<TileEntityMekanism>(MekanismContainerTypes.THERMOELECTRIC_BOILER, i, inv, (TileEntityMekanism)tile)))).with(new Attributes.AttributeInventory(), new Attributes.AttributeComparator())).build();
    public static final BlockTypeTile<TileEntitySuperheatingElement> SUPERHEATING_ELEMENT = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.SUPERHEATING_ELEMENT, MekanismLang.DESCRIPTION_SUPERHEATING_ELEMENT).with(new AttributeStateActive())).build();
    public static final BlockTypeTile<TileEntityInductionCasing> INDUCTION_CASING = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.INDUCTION_CASING, MekanismLang.DESCRIPTION_INDUCTION_CASING).withGui(() -> MekanismContainerTypes.INDUCTION_MATRIX)).withCustomContainer(tile -> new ContainerProvider(MekanismLang.MATRIX, (i, inv, player) -> new MekanismTileContainer<TileEntityMekanism>(MekanismContainerTypes.INDUCTION_MATRIX, i, inv, (TileEntityMekanism)tile)))).with(new Attributes.AttributeInventory(), new Attributes.AttributeComparator())).build();
    public static final BlockTypeTile<TileEntityInductionPort> INDUCTION_PORT = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.INDUCTION_PORT, MekanismLang.DESCRIPTION_INDUCTION_PORT).withGui(() -> MekanismContainerTypes.INDUCTION_MATRIX)).withCustomContainer(tile -> new ContainerProvider(MekanismLang.MATRIX, (i, inv, player) -> new MekanismTileContainer<TileEntityMekanism>(MekanismContainerTypes.INDUCTION_MATRIX, i, inv, (TileEntityMekanism)tile)))).with(new Attributes.AttributeInventory(), new Attributes.AttributeComparator(), new AttributeStateActive())).build();
    public static final BlockTypeTile<TileEntityThermalEvaporationController> THERMAL_EVAPORATION_CONTROLLER = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.THERMAL_EVAPORATION_CONTROLLER, MekanismLang.DESCRIPTION_THERMAL_EVAPORATION_CONTROLLER).withGui(() -> MekanismContainerTypes.THERMAL_EVAPORATION_CONTROLLER)).with(new Attributes.AttributeInventory(), new AttributeStateActive(), new AttributeStateFacing(), new Attributes.AttributeCustomResistance(9.0f))).build();
    public static final BlockTypeTile<TileEntityThermalEvaporationValve> THERMAL_EVAPORATION_VALVE = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.THERMAL_EVAPORATION_VALVE, MekanismLang.DESCRIPTION_THERMAL_EVAPORATION_VALVE).with(new Attributes.AttributeComparator(), new Attributes.AttributeCustomResistance(9.0f))).build();
    public static final BlockTypeTile<TileEntityThermalEvaporationBlock> THERMAL_EVAPORATION_BLOCK = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> MekanismTileEntityTypes.THERMAL_EVAPORATION_BLOCK, MekanismLang.DESCRIPTION_THERMAL_EVAPORATION_BLOCK).with(new Attributes.AttributeCustomResistance(9.0f))).build();
    public static final BlockType STEEL_CASING = ((BlockType.BlockTypeBuilder)BlockTypeTile.BlockTileBuilder.createBlock(MekanismLang.DESCRIPTION_STEEL_CASING).with(new Attributes.AttributeCustomResistance(9.0f))).build();
    public static final BlockTypeTile<TileEntityInductionCell> BASIC_INDUCTION_CELL = MekanismBlockTypes.createInductionCell(InductionCellTier.BASIC, () -> MekanismTileEntityTypes.BASIC_INDUCTION_CELL);
    public static final BlockTypeTile<TileEntityInductionCell> ADVANCED_INDUCTION_CELL = MekanismBlockTypes.createInductionCell(InductionCellTier.ADVANCED, () -> MekanismTileEntityTypes.ADVANCED_INDUCTION_CELL);
    public static final BlockTypeTile<TileEntityInductionCell> ELITE_INDUCTION_CELL = MekanismBlockTypes.createInductionCell(InductionCellTier.ELITE, () -> MekanismTileEntityTypes.ELITE_INDUCTION_CELL);
    public static final BlockTypeTile<TileEntityInductionCell> ULTIMATE_INDUCTION_CELL = MekanismBlockTypes.createInductionCell(InductionCellTier.ULTIMATE, () -> MekanismTileEntityTypes.ULTIMATE_INDUCTION_CELL);
    public static final BlockTypeTile<TileEntityInductionProvider> BASIC_INDUCTION_PROVIDER = MekanismBlockTypes.createInductionProvider(InductionProviderTier.BASIC, () -> MekanismTileEntityTypes.BASIC_INDUCTION_PROVIDER);
    public static final BlockTypeTile<TileEntityInductionProvider> ADVANCED_INDUCTION_PROVIDER = MekanismBlockTypes.createInductionProvider(InductionProviderTier.ADVANCED, () -> MekanismTileEntityTypes.ADVANCED_INDUCTION_PROVIDER);
    public static final BlockTypeTile<TileEntityInductionProvider> ELITE_INDUCTION_PROVIDER = MekanismBlockTypes.createInductionProvider(InductionProviderTier.ELITE, () -> MekanismTileEntityTypes.ELITE_INDUCTION_PROVIDER);
    public static final BlockTypeTile<TileEntityInductionProvider> ULTIMATE_INDUCTION_PROVIDER = MekanismBlockTypes.createInductionProvider(InductionProviderTier.ULTIMATE, () -> MekanismTileEntityTypes.ULTIMATE_INDUCTION_PROVIDER);
    public static final Machine<TileEntityBin> BASIC_BIN = MekanismBlockTypes.createBin(BinTier.BASIC, () -> MekanismTileEntityTypes.BASIC_BIN, () -> MekanismBlocks.ADVANCED_BIN);
    public static final Machine<TileEntityBin> ADVANCED_BIN = MekanismBlockTypes.createBin(BinTier.ADVANCED, () -> MekanismTileEntityTypes.ADVANCED_BIN, () -> MekanismBlocks.ELITE_BIN);
    public static final Machine<TileEntityBin> ELITE_BIN = MekanismBlockTypes.createBin(BinTier.ELITE, () -> MekanismTileEntityTypes.ELITE_BIN, () -> MekanismBlocks.ULTIMATE_BIN);
    public static final Machine<TileEntityBin> ULTIMATE_BIN = MekanismBlockTypes.createBin(BinTier.ULTIMATE, () -> MekanismTileEntityTypes.ULTIMATE_BIN, null);
    public static final Machine<TileEntityBin> CREATIVE_BIN = MekanismBlockTypes.createBin(BinTier.CREATIVE, () -> MekanismTileEntityTypes.CREATIVE_BIN, null);
    public static final Machine<TileEntityEnergyCube> BASIC_ENERGY_CUBE = MekanismBlockTypes.createEnergyCube(EnergyCubeTier.BASIC, () -> MekanismTileEntityTypes.BASIC_ENERGY_CUBE, () -> MekanismBlocks.ADVANCED_ENERGY_CUBE);
    public static final Machine<TileEntityEnergyCube> ADVANCED_ENERGY_CUBE = MekanismBlockTypes.createEnergyCube(EnergyCubeTier.ADVANCED, () -> MekanismTileEntityTypes.ADVANCED_ENERGY_CUBE, () -> MekanismBlocks.ELITE_ENERGY_CUBE);
    public static final Machine<TileEntityEnergyCube> ELITE_ENERGY_CUBE = MekanismBlockTypes.createEnergyCube(EnergyCubeTier.ELITE, () -> MekanismTileEntityTypes.ELITE_ENERGY_CUBE, () -> MekanismBlocks.ULTIMATE_ENERGY_CUBE);
    public static final Machine<TileEntityEnergyCube> ULTIMATE_ENERGY_CUBE = MekanismBlockTypes.createEnergyCube(EnergyCubeTier.ULTIMATE, () -> MekanismTileEntityTypes.ULTIMATE_ENERGY_CUBE, null);
    public static final Machine<TileEntityEnergyCube> CREATIVE_ENERGY_CUBE = MekanismBlockTypes.createEnergyCube(EnergyCubeTier.CREATIVE, () -> MekanismTileEntityTypes.CREATIVE_ENERGY_CUBE, null);
    public static final Machine<TileEntityFluidTank> BASIC_FLUID_TANK = MekanismBlockTypes.createFluidTank(FluidTankTier.BASIC, () -> MekanismTileEntityTypes.BASIC_FLUID_TANK, () -> MekanismBlocks.ADVANCED_FLUID_TANK);
    public static final Machine<TileEntityFluidTank> ADVANCED_FLUID_TANK = MekanismBlockTypes.createFluidTank(FluidTankTier.ADVANCED, () -> MekanismTileEntityTypes.ADVANCED_FLUID_TANK, () -> MekanismBlocks.ELITE_FLUID_TANK);
    public static final Machine<TileEntityFluidTank> ELITE_FLUID_TANK = MekanismBlockTypes.createFluidTank(FluidTankTier.ELITE, () -> MekanismTileEntityTypes.ELITE_FLUID_TANK, () -> MekanismBlocks.ULTIMATE_FLUID_TANK);
    public static final Machine<TileEntityFluidTank> ULTIMATE_FLUID_TANK = MekanismBlockTypes.createFluidTank(FluidTankTier.ULTIMATE, () -> MekanismTileEntityTypes.ULTIMATE_FLUID_TANK, null);
    public static final Machine<TileEntityFluidTank> CREATIVE_FLUID_TANK = MekanismBlockTypes.createFluidTank(FluidTankTier.CREATIVE, () -> MekanismTileEntityTypes.CREATIVE_FLUID_TANK, null);
    public static final Machine<TileEntityGasTank> BASIC_GAS_TANK = MekanismBlockTypes.createGasTank(GasTankTier.BASIC, () -> MekanismTileEntityTypes.BASIC_GAS_TANK, () -> MekanismBlocks.ADVANCED_GAS_TANK);
    public static final Machine<TileEntityGasTank> ADVANCED_GAS_TANK = MekanismBlockTypes.createGasTank(GasTankTier.ADVANCED, () -> MekanismTileEntityTypes.ADVANCED_GAS_TANK, () -> MekanismBlocks.ELITE_GAS_TANK);
    public static final Machine<TileEntityGasTank> ELITE_GAS_TANK = MekanismBlockTypes.createGasTank(GasTankTier.ELITE, () -> MekanismTileEntityTypes.ELITE_GAS_TANK, () -> MekanismBlocks.ULTIMATE_GAS_TANK);
    public static final Machine<TileEntityGasTank> ULTIMATE_GAS_TANK = MekanismBlockTypes.createGasTank(GasTankTier.ULTIMATE, () -> MekanismTileEntityTypes.ULTIMATE_GAS_TANK, null);
    public static final Machine<TileEntityGasTank> CREATIVE_GAS_TANK = MekanismBlockTypes.createGasTank(GasTankTier.CREATIVE, () -> MekanismTileEntityTypes.CREATIVE_GAS_TANK, null);

    public static Factory<?> getFactory(FactoryTier tier, FactoryType type) {
        return (Factory)FACTORIES.get((Object)tier, (Object)type);
    }

    private static <TILE extends TileEntityInductionCell> BlockTypeTile<TILE> createInductionCell(InductionCellTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile) {
        return (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockType.BlockTypeBuilder)BlockTypeTile.BlockTileBuilder.createBlock(tile, MekanismLang.DESCRIPTION_INDUCTION_CELL).withEnergyConfig(tier::getMaxEnergy)).with(new AttributeTier<InductionCellTier>(tier), new Attributes.AttributeNoMobSpawn())).build();
    }

    private static <TILE extends TileEntityInductionProvider> BlockTypeTile<TILE> createInductionProvider(InductionProviderTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile) {
        return (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(tile, MekanismLang.DESCRIPTION_INDUCTION_PROVIDER).with(new AttributeTier<InductionProviderTier>(tier), new Attributes.AttributeNoMobSpawn())).build();
    }

    private static <TILE extends TileEntityBin> Machine<TILE> createBin(BinTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile, Supplier<BlockRegistryObject<?, ?>> upgradeBlock) {
        return (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(tile, MekanismLang.DESCRIPTION_BIN).with(new AttributeTier<BinTier>(tier), new AttributeUpgradeable(upgradeBlock))).without(AttributeParticleFX.class, Attributes.AttributeSecurity.class, AttributeUpgradeSupport.class, Attributes.AttributeRedstone.class)).build();
    }

    private static <TILE extends TileEntityEnergyCube> Machine<TILE> createEnergyCube(EnergyCubeTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile, Supplier<BlockRegistryObject<?, ?>> upgradeBlock) {
        return (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(tile, MekanismLang.DESCRIPTION_ENERGY_CUBE).withGui(() -> MekanismContainerTypes.ENERGY_CUBE)).withEnergyConfig(tier::getMaxEnergy)).with(new AttributeTier<EnergyCubeTier>(tier), new AttributeUpgradeable(upgradeBlock), new AttributeStateFacing(BlockStateHelper.facingProperty))).without(AttributeParticleFX.class, AttributeStateActive.class, AttributeUpgradeSupport.class)).build();
    }

    private static <TILE extends TileEntityFluidTank> Machine<TILE> createFluidTank(FluidTankTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile, Supplier<BlockRegistryObject<?, ?>> upgradeBlock) {
        return (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(tile, MekanismLang.DESCRIPTION_FLUID_TANK).withGui(() -> MekanismContainerTypes.FLUID_TANK)).withCustomShape(BlockShapes.FLUID_TANK)).with(new AttributeTier<FluidTankTier>(tier), new AttributeUpgradeable(upgradeBlock))).without(AttributeParticleFX.class, AttributeStateFacing.class, Attributes.AttributeRedstone.class, AttributeUpgradeSupport.class)).build();
    }

    private static <TILE extends TileEntityGasTank> Machine<TILE> createGasTank(GasTankTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile, Supplier<BlockRegistryObject<?, ?>> upgradeBlock) {
        return (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(tile, MekanismLang.DESCRIPTION_GAS_TANK).withGui(() -> MekanismContainerTypes.GAS_TANK)).withCustomShape(BlockShapes.GAS_TANK)).with(new AttributeTier<GasTankTier>(tier), new AttributeUpgradeable(upgradeBlock))).without(AttributeParticleFX.class, AttributeStateActive.class, AttributeUpgradeSupport.class)).build();
    }

    static {
        for (FactoryTier tier : FactoryTier.values()) {
            for (FactoryType type : FactoryType.values()) {
                FACTORIES.put((Object)tier, (Object)type, Factory.FactoryBuilder.createFactory(() -> MekanismTileEntityTypes.getFactoryTile(tier, type), () -> MekanismContainerTypes.FACTORY, type.getBaseMachine(), tier).build());
            }
        }
    }
}

