/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mekanism.api.math.FloatingLong;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGuiSetEnergy {
    private GuiEnergyValue interaction;
    private BlockPos tilePosition;
    private FloatingLong value;

    public PacketGuiSetEnergy(GuiEnergyValue interaction, BlockPos tilePosition, FloatingLong value) {
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.value = value;
    }

    public static void handle(PacketGuiSetEnergy message, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = BasePacketHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        context.get().enqueueWork(() -> {
            TileEntityMekanism tile = MekanismUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, message.tilePosition);
            if (tile != null) {
                message.interaction.consume(tile, message.value);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(PacketGuiSetEnergy pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.interaction);
        buf.func_179255_a(pkt.tilePosition);
        pkt.value.writeToBuffer(buf);
    }

    public static PacketGuiSetEnergy decode(PacketBuffer buf) {
        return new PacketGuiSetEnergy((GuiEnergyValue)buf.func_179257_a(GuiEnergyValue.class), buf.func_179259_c(), FloatingLong.readFromBuffer(buf));
    }

    public static enum GuiEnergyValue {
        MIN_THRESHOLD((tile, value) -> {
            if (tile instanceof TileEntityLaserAmplifier) {
                ((TileEntityLaserAmplifier)tile).setMinThresholdFromPacket((FloatingLong)value);
            }
        }),
        MAX_THRESHOLD((tile, value) -> {
            if (tile instanceof TileEntityLaserAmplifier) {
                ((TileEntityLaserAmplifier)tile).setMaxThresholdFromPacket((FloatingLong)value);
            }
        }),
        ENERGY_USAGE((tile, value) -> {
            if (tile instanceof TileEntityResistiveHeater) {
                ((TileEntityResistiveHeater)tile).setEnergyUsageFromPacket((FloatingLong)value);
            }
        });

        private BiConsumer<TileEntityMekanism, FloatingLong> consumerForTile;

        private GuiEnergyValue(BiConsumer<TileEntityMekanism, FloatingLong> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, FloatingLong value) {
            this.consumerForTile.accept(tile, value);
        }
    }
}

