/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ItemStackGasToGasRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSGas;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;

@RecipeTypeMapper
public class ItemStackGasToGasRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekItemStackGasToGas";
    }

    public String getDescription() {
        return "Maps Mekanism dissolution recipes.";
    }

    public boolean canHandle(IRecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.DISSOLUTION;
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, IRecipe<?> iRecipe) {
        if (!(iRecipe instanceof ItemStackGasToGasRecipe)) {
            return false;
        }
        boolean handled = false;
        ItemStackGasToGasRecipe recipe = (ItemStackGasToGasRecipe)iRecipe;
        List<@NonNull TYPE> itemRepresentations = recipe.getItemInput().getRepresentations();
        List<@NonNull TYPE> gasRepresentations = recipe.getGasInput().getRepresentations();
        long gasMultiplier = 200L;
        for (GasStack gasRepresentation : gasRepresentations) {
            NSSGas nssGas = NSSGas.createGas(gasRepresentation);
            long gasAmount = gasRepresentation.getAmount() * gasMultiplier;
            for (ItemStack itemRepresentation : itemRepresentations) {
                GasStack output = recipe.getOutput(itemRepresentation, gasRepresentation);
                if (output.isEmpty()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put(itemRepresentation);
                ingredientHelper.put((NormalizedSimpleStack)nssGas, gasAmount);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

