/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
public class RenderPersonalChest
extends MekanismTileEntityRenderer<TileEntityPersonalChest> {
    private static final ResourceLocation texture = MekanismUtils.getResource(MekanismUtils.ResourceType.TEXTURE_BLOCKS, "models/personal_chest.png");
    private final ModelRenderer lid;
    private final ModelRenderer base = new ModelRenderer(64, 64, 0, 19);
    private final ModelRenderer latch;

    public RenderPersonalChest(TileEntityRendererDispatcher renderer) {
        super(renderer);
        this.base.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.lid = new ModelRenderer(64, 64, 0, 0);
        this.lid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.lid.field_78797_d = 9.0f;
        this.lid.field_78798_e = 1.0f;
        this.latch = new ModelRenderer(64, 64, 0, 0);
        this.latch.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.latch.field_78797_d = 8.0f;
    }

    @Override
    protected void render(TileEntityPersonalChest tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        matrix.func_227860_a_();
        if (!tile.func_145837_r()) {
            matrix.func_227861_a_(0.5, 0.5, 0.5);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-tile.getDirection().func_185119_l()));
            matrix.func_227861_a_(-0.5, -0.5, -0.5);
        }
        float lidAngle = tile.prevLidAngle + (tile.lidAngle - tile.prevLidAngle) * partialTick;
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        IVertexBuilder builder = renderer.getBuffer(RenderType.func_228638_b_((ResourceLocation)texture));
        this.latch.field_78795_f = this.lid.field_78795_f = -(lidAngle * 1.5707964f);
        this.lid.func_228308_a_(matrix, builder, light, overlayLight);
        this.latch.func_228308_a_(matrix, builder, light, overlayLight);
        this.base.func_228308_a_(matrix, builder, light, overlayLight);
        matrix.func_227865_b_();
    }

    @Override
    protected String getProfilerSection() {
        return "personalChest";
    }
}

