/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiElement
extends Widget {
    public static final Minecraft minecraft = Minecraft.func_71410_x();
    protected final IGuiWrapper guiObj;
    protected boolean playClickSound;

    public GuiElement(IGuiWrapper gui, int x, int y, int width, int height, String text) {
        super(x, y, width, height, text);
        this.guiObj = gui;
    }

    public void renderForeground(int mouseX, int mouseY, int xAxis, int yAxis) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.renderToolTip(xAxis, yAxis);
        }
    }

    public void displayTooltip(ITextComponent component, int xAxis, int yAxis) {
        this.guiObj.displayTooltip(component, xAxis, yAxis);
    }

    public void displayTooltips(List<ITextComponent> list, int xAxis, int yAxis) {
        this.guiObj.displayTooltips(list, xAxis, yAxis);
    }

    public int drawString(ITextComponent component, int x, int y, int color) {
        return this.drawString(component.func_150254_d(), x, y, color);
    }

    public void renderScaledText(ITextComponent component, int x, int y, int color, int maxX) {
        this.renderScaledText(component.func_150254_d(), x, y, color, maxX);
    }

    public int drawString(String text, int x, int y, int color) {
        return this.getFontRenderer().func_211126_b(text, (float)x, (float)y, color);
    }

    public int getStringWidth(ITextComponent component) {
        return this.getFontRenderer().func_78256_a(component.func_150254_d());
    }

    public float getNeededScale(ITextComponent text, int maxX) {
        int length = this.getStringWidth(text);
        return length <= maxX ? 1.0f : (float)maxX / (float)length;
    }

    public void renderScaledText(String text, int x, int y, int color, int maxX) {
        int length = this.getFontRenderer().func_78256_a(text);
        if (length <= maxX) {
            this.drawString(text, x, y, color);
        } else {
            float scale = (float)maxX / (float)length;
            float reverse = 1.0f / scale;
            float yAdd = 4.0f - scale * 8.0f / 2.0f;
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            this.drawString(text, (int)((float)x * reverse), (int)((float)y * reverse + yAdd), color);
            RenderSystem.popMatrix();
        }
        MekanismRenderer.resetColor();
    }

    protected FontRenderer getFontRenderer() {
        return this.guiObj.getFont();
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY);
    }

    protected int getButtonX() {
        return this.x;
    }

    protected int getButtonY() {
        return this.y;
    }

    protected int getButtonWidth() {
        return this.width;
    }

    protected int getButtonHeight() {
        return this.height;
    }

    protected boolean resetColorBeforeRender() {
        return true;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        this.drawButton(mouseX, mouseY);
    }

    protected void drawButton(int mouseX, int mouseY) {
        if (this.resetColorBeforeRender()) {
            MekanismRenderer.resetColor();
        }
        MekanismRenderer.bindTexture(WIDGETS_LOCATION);
        int i = this.getYImage(this.isMouseOver(mouseX, mouseY));
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int width = this.getButtonWidth();
        int height = this.getButtonHeight();
        int halfWidthLeft = width / 2;
        int halfWidthRight = width % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
        int halfHeightTop = height / 2;
        int halfHeightBottom = height % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
        int position = 46 + i * 20;
        int x = this.getButtonX();
        int y = this.getButtonY();
        this.blit(x, y, 0, position, halfWidthLeft, halfHeightTop);
        this.blit(x, y + halfHeightTop, 0, position + 20 - halfHeightBottom, halfWidthLeft, halfHeightBottom);
        this.blit(x + halfWidthLeft, y, 200 - halfWidthRight, position, halfWidthRight, halfHeightTop);
        this.blit(x + halfWidthLeft, y + halfHeightTop, 200 - halfWidthRight, position + 20 - halfHeightBottom, halfWidthRight, halfHeightBottom);
        this.renderBg(minecraft, mouseX, mouseY);
        String message = this.getMessage();
        if (!message.isEmpty()) {
            this.drawCenteredString(this.getFontRenderer(), message, x + halfWidthLeft, y + (height - 8) / 2, this.getFGColor() | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24);
        }
        RenderSystem.disableBlend();
    }

    protected void renderExtendedTexture(ResourceLocation resource, int sideWidth, int sideHeight) {
        GuiUtils.renderExtendedTexture(resource, sideWidth, sideHeight, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
    }

    public void playDownSound(SoundHandler soundHandler) {
        if (this.playClickSound) {
            super.playDownSound(soundHandler);
        }
    }

    protected void drawTiledSprite(int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite) {
        GuiUtils.drawTiledSprite(xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, 16, 16, this.getBlitOffset());
    }

    @FunctionalInterface
    public static interface IHoverable {
        public void onHover(GuiElement var1, int var2, int var3);
    }
}

