/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiGraph;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.tab.GuiBoilerTab;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiBoilerStats
extends GuiMekanismTile<TileEntityBoilerCasing, EmptyTileContainer<TileEntityBoilerCasing>> {
    private GuiGraph boilGraph;
    private GuiGraph maxGraph;

    public GuiBoilerStats(EmptyTileContainer<TileEntityBoilerCasing> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiBoilerTab((IGuiWrapper)this, (TileEntityBoilerCasing)this.tile, GuiBoilerTab.BoilerTab.MAIN));
        this.addButton(new GuiHeatInfo(() -> {
            ITextComponent environment = MekanismUtils.getTemperatureDisplay(((TileEntityBoilerCasing)this.tile).getLastEnvironmentLoss(), UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(environment));
        }, this));
        this.boilGraph = new GuiGraph((IGuiWrapper)this, 8, 83, 160, 36, xva$0 -> MekanismLang.BOIL_RATE.translate(xva$0));
        this.addButton(this.boilGraph);
        this.maxGraph = new GuiGraph((IGuiWrapper)this, 8, 122, 160, 36, xva$0 -> MekanismLang.MAX_BOIL_RATE.translate(xva$0));
        this.addButton(this.maxGraph);
        this.maxGraph.enableFixedScale((int)(MekanismConfig.general.superheatingHeatTransfer.get() * (double)((TileEntityBoilerCasing)this.tile).getSuperheatingElements() / HeatUtils.getVaporizationEnthalpy()));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredText((ITextComponent)MekanismLang.BOILER_STATS.translate(new Object[0]), 0, this.getXSize(), 6, 0x404040);
        this.drawString((ITextComponent)MekanismLang.BOILER_MAX_WATER.translate(((TileEntityBoilerCasing)this.tile).structure == null ? 0 : ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tile).structure).waterTank.getCapacity()), 8, 26, 0x404040);
        this.drawString((ITextComponent)MekanismLang.BOILER_MAX_STEAM.translate(((TileEntityBoilerCasing)this.tile).structure == null ? 0L : ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tile).structure).steamTank.getCapacity()), 8, 35, 0x404040);
        this.drawString((ITextComponent)MekanismLang.BOILER_HEAT_TRANSFER.translate(new Object[0]), 8, 49, 0x797979);
        this.drawString((ITextComponent)MekanismLang.BOILER_HEATERS.translate(((TileEntityBoilerCasing)this.tile).getSuperheatingElements()), 14, 58, 0x404040);
        int boilCapacity = (int)(MekanismConfig.general.superheatingHeatTransfer.get() * (double)((TileEntityBoilerCasing)this.tile).getSuperheatingElements() / HeatUtils.getVaporizationEnthalpy());
        this.drawString((ITextComponent)MekanismLang.BOILER_CAPACITY.translate(boilCapacity), 8, 72, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    public void tick() {
        super.tick();
        this.boilGraph.addData(((TileEntityBoilerCasing)this.tile).getLastBoilRate());
        this.maxGraph.addData(((TileEntityBoilerCasing)this.tile).getLastMaxBoil());
    }
}

