/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class PressurizedReactionCachedRecipe
extends CachedRecipe<PressurizedReactionRecipe> {
    private final IOutputHandler<@NonNull Pair<@NonNull ItemStack, @NonNull GasStack>> outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NonNull GasStack> gasInputHandler;

    public PressurizedReactionCachedRecipe(PressurizedReactionRecipe recipe, IInputHandler<@NonNull ItemStack> itemInputHandler, IInputHandler<@NonNull FluidStack> fluidInputHandler, IInputHandler<@NonNull GasStack> gasInputHandler, IOutputHandler<@NonNull Pair<@NonNull ItemStack, @NonNull GasStack>> outputHandler) {
        super(recipe);
        this.itemInputHandler = itemInputHandler;
        this.fluidInputHandler = fluidInputHandler;
        this.gasInputHandler = gasInputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ItemStack recipeItem = this.itemInputHandler.getRecipeInput(((PressurizedReactionRecipe)this.recipe).getInputSolid());
        if (recipeItem.func_190926_b()) {
            return -1;
        }
        FluidStack recipeFluid = this.fluidInputHandler.getRecipeInput(((PressurizedReactionRecipe)this.recipe).getInputFluid());
        if (recipeFluid.isEmpty()) {
            return -1;
        }
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((PressurizedReactionRecipe)this.recipe).getInputGas());
        if (recipeGas.isEmpty()) {
            return -1;
        }
        currentMax = this.itemInputHandler.operationsCanSupport(((PressurizedReactionRecipe)this.recipe).getInputSolid(), currentMax);
        currentMax = this.fluidInputHandler.operationsCanSupport(((PressurizedReactionRecipe)this.recipe).getInputFluid(), currentMax);
        currentMax = this.gasInputHandler.operationsCanSupport(((PressurizedReactionRecipe)this.recipe).getInputGas(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((PressurizedReactionRecipe)this.recipe).getOutput(recipeItem, recipeFluid, recipeGas), currentMax);
    }

    @Override
    public boolean isInputValid() {
        GasStack gas = this.gasInputHandler.getInput();
        if (gas.isEmpty()) {
            return false;
        }
        FluidStack fluid = this.fluidInputHandler.getInput();
        if (fluid.isEmpty()) {
            return false;
        }
        return ((PressurizedReactionRecipe)this.recipe).test(this.itemInputHandler.getInput(), fluid, gas);
    }

    @Override
    protected void finishProcessing(int operations) {
        ItemStack recipeItem = this.itemInputHandler.getRecipeInput(((PressurizedReactionRecipe)this.recipe).getInputSolid());
        if (recipeItem.func_190926_b()) {
            return;
        }
        FluidStack recipeFluid = this.fluidInputHandler.getRecipeInput(((PressurizedReactionRecipe)this.recipe).getInputFluid());
        if (recipeFluid.isEmpty()) {
            return;
        }
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((PressurizedReactionRecipe)this.recipe).getInputGas());
        if (recipeGas.isEmpty()) {
            return;
        }
        this.itemInputHandler.use(recipeItem, operations);
        this.fluidInputHandler.use(recipeFluid, operations);
        this.gasInputHandler.use(recipeGas, operations);
        this.outputHandler.handleOutput(((PressurizedReactionRecipe)this.recipe).getOutput(recipeItem, recipeFluid, recipeGas), operations);
    }
}

