/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.GasStackIngredient;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ItemStackGasToGasRecipe
extends MekanismRecipe
implements BiPredicate<ItemStack, GasStack> {
    private final ItemStackIngredient itemInput;
    private final GasStackIngredient gasInput;
    private final GasStack output;

    public ItemStackGasToGasRecipe(ResourceLocation id, ItemStackIngredient itemInput, GasStackIngredient gasInput, GasStack output) {
        super(id);
        this.itemInput = itemInput;
        this.gasInput = gasInput;
        this.output = output;
    }

    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    public GasStackIngredient getGasInput() {
        return this.gasInput;
    }

    public GasStack getOutput(ItemStack inputItem, GasStack inputGas) {
        return this.output.copy();
    }

    @Override
    public boolean test(ItemStack itemStack, GasStack gasStack) {
        return this.itemInput.test(itemStack) && this.gasInput.test(gasStack);
    }

    public GasStack getOutputDefinition() {
        return this.output;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.itemInput.write(buffer);
        this.gasInput.write(buffer);
        this.output.writeToPacket(buffer);
    }
}

