/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.inventory;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.ISidedItemHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IMekanismInventory
extends ISidedItemHandler {
    default public boolean hasInventory() {
        return true;
    }

    public List<IInventorySlot> getInventorySlots(@Nullable Direction var1);

    public void onContentsChanged();

    @Nullable
    default public IInventorySlot getInventorySlot(int slot, @Nullable Direction side) {
        List<IInventorySlot> slots = this.getInventorySlots(side);
        return slot >= 0 && slot < slots.size() ? slots.get(slot) : null;
    }

    @Override
    default public void setStackInSlot(int slot, ItemStack stack, @Nullable Direction side) {
        IInventorySlot inventorySlot = this.getInventorySlot(slot, side);
        if (inventorySlot != null) {
            inventorySlot.setStack(stack);
        }
    }

    @Override
    default public int getSlots(@Nullable Direction side) {
        return this.getInventorySlots(side).size();
    }

    @Override
    default public ItemStack getStackInSlot(int slot, @Nullable Direction side) {
        IInventorySlot inventorySlot = this.getInventorySlot(slot, side);
        return inventorySlot == null ? ItemStack.field_190927_a : inventorySlot.getStack();
    }

    @Override
    default public ItemStack insertItem(int slot, ItemStack stack, @Nullable Direction side, Action action) {
        IInventorySlot inventorySlot = this.getInventorySlot(slot, side);
        if (inventorySlot == null) {
            return stack;
        }
        return inventorySlot.insertItem(stack, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
    }

    @Override
    default public ItemStack extractItem(int slot, int amount, @Nullable Direction side, Action action) {
        IInventorySlot inventorySlot = this.getInventorySlot(slot, side);
        if (inventorySlot == null) {
            return ItemStack.field_190927_a;
        }
        return inventorySlot.extractItem(amount, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
    }

    @Override
    default public int getSlotLimit(int slot, @Nullable Direction side) {
        IInventorySlot inventorySlot = this.getInventorySlot(slot, side);
        return inventorySlot == null ? 0 : inventorySlot.getLimit(ItemStack.field_190927_a);
    }

    @Override
    default public boolean isItemValid(int slot, ItemStack stack, @Nullable Direction side) {
        IInventorySlot inventorySlot = this.getInventorySlot(slot, side);
        return inventorySlot != null && inventorySlot.isItemValid(stack);
    }
}

