/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.inventory.materials.objects;

import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObjectSerializer;
import com.direwolf20.buildinggadgets.common.template.SerialisationSupport;
import com.direwolf20.buildinggadgets.common.util.tools.RegistryUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public final class UniqueItem
implements IUniqueObject<Item> {
    private final Item item;
    @Nullable
    private final CompoundNBT tagCompound;
    @Nullable
    private final CompoundNBT forgeCaps;
    private final int hash;
    private final ComparisonMode tagMatch;
    private final ComparisonMode capMatch;

    public static UniqueItem ofStack(ItemStack stack) {
        CompoundNBT nbt = new CompoundNBT();
        stack.func_77955_b(nbt);
        return new UniqueItem(stack.func_77973_b(), stack.func_77978_p(), ComparisonMode.EXACT_MATCH, nbt.func_74775_l("ForgeCaps"), ComparisonMode.EXACT_MATCH);
    }

    public UniqueItem(Item item) {
        this(item, null, ComparisonMode.EXACT_MATCH);
    }

    public UniqueItem(Item item, @Nullable CompoundNBT tagCompound, ComparisonMode comparisonMode) {
        this(item, tagCompound, comparisonMode, null, ComparisonMode.EXACT_MATCH);
    }

    public UniqueItem(Item item, @Nullable CompoundNBT tagCompound, ComparisonMode tagMatch, @Nullable CompoundNBT forgeCaps, ComparisonMode capMatch) {
        this.item = Objects.requireNonNull(item, "Cannot construct a UniqueItem for a null Item!");
        this.tagCompound = tagCompound;
        this.forgeCaps = forgeCaps;
        this.tagMatch = Objects.requireNonNull(tagMatch);
        this.capMatch = Objects.requireNonNull(capMatch);
        int hash = capMatch.hashCode() + 31 * tagMatch.hashCode();
        hash = tagCompound != null ? tagCompound.hashCode() + 31 * hash : hash;
        hash = forgeCaps != null ? forgeCaps.hashCode() + 31 * hash : hash;
        this.hash = Objects.requireNonNull(item.getRegistryName()).hashCode() + 31 * hash;
    }

    @Override
    public Class<Item> getIndexClass() {
        return Item.class;
    }

    @Override
    public Item getIndexObject() {
        return this.item;
    }

    @Nullable
    public CompoundNBT getTag() {
        return this.tagCompound != null ? this.tagCompound.func_74737_b() : null;
    }

    @Nullable
    public CompoundNBT getForgeCaps() {
        return this.forgeCaps != null ? this.forgeCaps.func_74737_b() : null;
    }

    @Override
    public ItemStack createStack(int count) {
        ItemStack res = new ItemStack((IItemProvider)this.item, count, this.forgeCaps);
        res.func_77982_d(this.tagCompound);
        return res;
    }

    @Override
    public boolean matches(ItemStack stack) {
        if (stack.func_77973_b() != this.getIndexObject()) {
            return false;
        }
        if (this.tagCompound != null && !this.tagMatch.match(this.tagCompound, stack.func_77978_p())) {
            return false;
        }
        if (this.forgeCaps != null) {
            CompoundNBT container = new CompoundNBT();
            stack.func_77955_b(container);
            CompoundNBT otherCapNBT = container.func_74775_l("ForgeCaps");
            return this.capMatch.match(this.forgeCaps, otherCapNBT);
        }
        return true;
    }

    @Override
    public ItemStack insertInto(ItemStack stack, int count) {
        if (this.forgeCaps != null) {
            stack = new ItemStack((IItemProvider)this.getIndexObject(), count, this.forgeCaps);
        } else {
            stack.func_190920_e(Math.min(stack.func_190916_E() + count, stack.func_77976_d()));
        }
        if (this.tagCompound != null) {
            stack.func_77982_d(this.tagCompound);
        }
        return stack;
    }

    @Override
    public IUniqueObjectSerializer getSerializer() {
        return SerialisationSupport.uniqueItemSerializer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UniqueItem)) {
            return false;
        }
        UniqueItem that = (UniqueItem)o;
        if (!this.item.equals(that.item)) {
            return false;
        }
        if (this.tagCompound != null ? !this.tagCompound.equals((Object)that.tagCompound) : that.tagCompound != null) {
            return false;
        }
        if (this.forgeCaps != null ? !this.forgeCaps.equals((Object)that.forgeCaps) : that.forgeCaps != null) {
            return false;
        }
        if (this.tagMatch != that.tagMatch) {
            return false;
        }
        return this.capMatch == that.capMatch;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("item", (Object)this.getIndexObject().getRegistryName()).add("tagCompound", (Object)this.tagCompound).add("forgeCaps", (Object)this.forgeCaps).add("tagMatch", (Object)this.tagMatch).add("capMatch", (Object)this.capMatch).toString();
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IUniqueObjectSerializer>
    implements IUniqueObjectSerializer {
        @Override
        public CompoundNBT serialize(IUniqueObject<?> obj, boolean persisted) {
            UniqueItem item = (UniqueItem)obj;
            CompoundNBT res = new CompoundNBT();
            if (item.tagCompound != null) {
                res.func_218657_a("data", (INBT)item.tagCompound);
            }
            if (item.forgeCaps != null) {
                res.func_218657_a("cap_data", (INBT)item.forgeCaps);
            }
            if (persisted) {
                res.func_74778_a("id", item.getIndexObject().getRegistryName().toString());
            } else {
                res.func_74768_a("id", RegistryUtils.getId(ForgeRegistries.ITEMS, item.item));
            }
            res.func_74774_a("data_comp", item.tagMatch.getId());
            res.func_74774_a("cap_comp", item.capMatch.getId());
            return res;
        }

        public IUniqueObject<Item> deserialize(CompoundNBT res) {
            Preconditions.checkArgument((boolean)res.func_74764_b("id"), (Object)"Cannot construct a UniqueItem without an Item!");
            CompoundNBT nbt = res.func_74775_l("data");
            ComparisonMode mode = ComparisonMode.byId(res.func_74771_c("data_comp"));
            CompoundNBT capNbt = res.func_74775_l("cap_data");
            ComparisonMode capMode = ComparisonMode.byId(res.func_74771_c("cap_comp"));
            Item item = res.func_150297_b("id", 3) ? (Item)RegistryUtils.getById(ForgeRegistries.ITEMS, res.func_74762_e("id")) : (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(res.func_74779_i("id")));
            return new UniqueItem(item, nbt.isEmpty() ? null : nbt, mode, capNbt.isEmpty() ? null : capNbt, capMode);
        }

        @Override
        public JsonSerializer<IUniqueObject<?>> asJsonSerializer(boolean printName, boolean extended) {
            return (uobj, typeOfSrc, context) -> {
                JsonObject obj = new JsonObject();
                UniqueItem element = (UniqueItem)uobj;
                Item item = element.getIndexObject();
                if (printName) {
                    obj.addProperty("name", I18n.func_135052_a((String)item.func_77667_c(element.createStack()), (Object[])new Object[0]));
                }
                obj.add("id", context.serialize((Object)element.getIndexObject().getRegistryName()));
                if (extended) {
                    if (element.tagCompound != null && !element.tagCompound.isEmpty()) {
                        obj.addProperty("nbt", element.tagCompound.toString());
                        obj.add("nbt_match_type", context.serialize((Object)element.tagMatch));
                    }
                    if (element.forgeCaps != null && !element.forgeCaps.isEmpty()) {
                        obj.addProperty("cap_nbt", element.forgeCaps.toString());
                        obj.add("cap_nbt_match_type", context.serialize((Object)element.capMatch));
                    }
                }
                return obj;
            };
        }

        @Override
        public JsonDeserializer<IUniqueObject<?>> asJsonDeserializer() {
            return (json, typeOfT, context) -> {
                JsonObject object = json.getAsJsonObject();
                ResourceLocation registryName = (ResourceLocation)context.deserialize(object.get("id"), ResourceLocation.class);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
                if (item == null) {
                    return new UniqueItem(Items.field_190931_a);
                }
                CompoundNBT tagCompound = null;
                ComparisonMode tagMatch = ComparisonMode.EXACT_MATCH;
                if (object.has("nbt")) {
                    try {
                        tagCompound = JsonToNBT.func_180713_a((String)object.getAsJsonPrimitive("nbt").getAsString());
                        tagMatch = (ComparisonMode)((Object)((Object)context.deserialize(object.get("nbt_match_type"), ComparisonMode.class)));
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
                CompoundNBT forgeCaps = null;
                ComparisonMode capMatch = ComparisonMode.EXACT_MATCH;
                if (object.has("cap_nbt")) {
                    try {
                        forgeCaps = JsonToNBT.func_180713_a((String)object.getAsJsonPrimitive("cap_nbt").getAsString());
                        capMatch = (ComparisonMode)((Object)((Object)context.deserialize(object.get("cap_nbt_match_type"), ComparisonMode.class)));
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
                return new UniqueItem(item, tagCompound, tagMatch, forgeCaps, capMatch);
            };
        }
    }

    public static enum ComparisonMode {
        EXACT_MATCH(0){

            @Override
            public boolean match(CompoundNBT nbt, @Nullable CompoundNBT other) {
                return nbt.equals((Object)other);
            }
        }
        ,
        SUB_TAG_MATCH(1){

            @Override
            public boolean match(CompoundNBT nbt, @Nullable CompoundNBT other) {
                if (other == null) {
                    return false;
                }
                for (String key : nbt.func_150296_c()) {
                    INBT val = nbt.func_74781_a(key);
                    if (val == null) {
                        if (other.func_74781_a(key) == null) continue;
                        return false;
                    }
                    if (!other.func_150297_b(key, (int)val.func_74732_a()) || other.func_74781_a(key) == null) {
                        return false;
                    }
                    if (val.func_74732_a() == 10 && !this.match((CompoundNBT)val, other.func_74775_l(key))) {
                        return false;
                    }
                    if (val.func_74732_a() == 10 || val.func_150285_a_().equals(other.func_74781_a(key).func_150285_a_())) continue;
                    return false;
                }
                return true;
            }
        };

        private static final Byte2ObjectMap<ComparisonMode> BY_ID;
        private final byte id;

        private ComparisonMode(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public abstract boolean match(CompoundNBT var1, @Nullable CompoundNBT var2);

        public static ComparisonMode byId(byte id) {
            ComparisonMode mode = (ComparisonMode)((Object)BY_ID.get(id));
            return mode == null ? EXACT_MATCH : mode;
        }

        static {
            BY_ID = new Byte2ObjectOpenHashMap();
            Arrays.stream(ComparisonMode.values()).forEach(m -> {
                ComparisonMode cfr_ignored_0 = (ComparisonMode)((Object)((Object)BY_ID.put(m.getId(), (Object)m)));
            });
        }
    }
}

