/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.data.FluxNetworkData;

public class FluxChunkManager {
    public static final TicketType<ChunkPos> FLUX_TICKET_TYPE = TicketType.func_219484_a((String)"fluxnetworks:chunkloading", (l1, l2) -> 0);
    public static final int DEFAULT_DISTANCE = 31;
    public static final HashMap<Integer, List<ChunkPos>> activeChunks = new HashMap();

    public static void clear() {
        activeChunks.clear();
    }

    public static void loadWorld(ServerWorld world) {
        if (!FluxConfig.enableChunkLoading) {
            return;
        }
        int dim = world.func_201675_m().func_186058_p().func_186068_a();
        List<ChunkPos> toLoad = FluxNetworkData.get().loadedChunks.get(dim);
        if (toLoad == null) {
            return;
        }
        toLoad.forEach(pos -> FluxChunkManager.registerTicket(world, pos));
        int count = ((List)activeChunks.getOrDefault(dim, new ArrayList())).size();
        if (count > 0) {
            FluxNetworks.LOGGER.info("Chunks Loaded in Dim: {}  Dim Id: {}  Chunks Loaded: {}", (Object)DimensionType.func_212678_a((DimensionType)world.func_201675_m().func_186058_p()), (Object)dim, (Object)count);
        }
    }

    public static boolean addChunkLoader(ServerWorld world, ChunkPos pos) {
        int dim = world.func_201675_m().func_186058_p().func_186068_a();
        if (!FluxNetworkData.get().loadedChunks.computeIfAbsent(dim, d -> new ArrayList()).contains(pos)) {
            FluxNetworkData.get().loadedChunks.get(dim).add(pos);
            FluxChunkManager.registerTicket(world, pos);
            FluxNetworks.LOGGER.info("Added Chunk Loader in Dim: {} Dim Id: {} Chunk: {}", (Object)DimensionType.func_212678_a((DimensionType)world.func_201675_m().func_186058_p()), (Object)dim, (Object)pos);
            return true;
        }
        return false;
    }

    public static void removeChunkLoader(ServerWorld world, ChunkPos pos) {
        int dim = world.func_201675_m().func_186058_p().func_186068_a();
        long count = ((List)FluxNetworkData.get().loadedChunks.getOrDefault(dim, new ArrayList())).stream().filter(chunkPos -> chunkPos.equals((Object)pos)).count();
        if (count > 0L) {
            FluxNetworkData.get().loadedChunks.get(dim).remove(pos);
            if (count <= 1L) {
                FluxChunkManager.releaseTicket(world, pos);
            }
            FluxNetworks.LOGGER.info("Removed Chunk Loader in Dim: {} Dim Id: {} Chunk: {}", (Object)DimensionType.func_212678_a((DimensionType)world.func_201675_m().func_186058_p()), (Object)dim, (Object)pos);
        }
    }

    public static void registerTicket(ServerWorld world, ChunkPos pos) {
        List active = activeChunks.computeIfAbsent(world.func_201675_m().func_186058_p().func_186068_a(), d -> new ArrayList());
        if (!active.contains(pos)) {
            world.func_217458_b(pos.field_77276_a, pos.field_77275_b, true);
            active.add(pos);
        }
    }

    public static void releaseTicket(ServerWorld world, ChunkPos pos) {
        List<ChunkPos> active = activeChunks.get(world.func_201675_m().func_186058_p().func_186068_a());
        if (active != null && active.contains(pos)) {
            world.func_217458_b(pos.field_77276_a, pos.field_77275_b, false);
            active.remove(pos);
        }
    }
}

