/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.client.gui.ScreenUtils;
import sonar.fluxnetworks.client.gui.basic.GuiTabPages;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.popups.PopUpNetworkPassword;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.item.FluxConfiguratorItem;

public class GuiTabSelection
extends GuiTabPages<IFluxNetwork> {
    public InvisibleButton redirectButton;
    public IFluxNetwork selectedNetwork;
    protected int timer2;

    public GuiTabSelection(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
        this.gridStartX = 15;
        this.gridStartY = 22;
        this.gridHeight = 13;
        this.gridPerPage = 10;
        this.elementHeight = 12;
        this.elementWidth = 146;
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_SELECTION;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.elements.size() == 0) {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_NETWORK.t(), FluxTranslate.TAB_CREATE.t());
        } else {
            String amount = FluxTranslate.TOTAL.t() + ": " + this.elements.size();
            this.font.func_211126_b(amount, (float)(158 - this.font.func_78256_a(amount)), 10.0f, 0xFFFFFF);
            this.font.func_211126_b(FluxTranslate.SORT_BY.t() + ": " + TextFormatting.AQUA + this.sortType.getTranslatedName(), 19.0f, 10.0f, 0xFFFFFF);
            if (!this.hasActivePopup()) {
                this.drawCenteredString(this.font, TextFormatting.RED + FluxNetworks.proxy.getFeedback(false).getInfo(), 88, 150, 0xFFFFFF);
            }
        }
    }

    @Override
    protected void onElementClicked(IFluxNetwork element, int mouseButton) {
        if (mouseButton == 0) {
            this.selectedNetwork = element;
            this.setConnectedNetwork(element.getNetworkID(), "");
        }
    }

    @Override
    public void init() {
        super.init();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_SELECTION, this.navigationTabs);
        if (!this.networkValid) {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTabs.TAB_CREATE.getTranslatedName(), b -> GuiTabSelection.switchTab(EnumNavigationTabs.TAB_CREATE, this.player, this.connector));
            this.addButton((Widget)this.redirectButton);
        }
    }

    @Override
    public void renderElement(IFluxNetwork element, int x, int y) {
        GlStateManager.func_227626_N_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227709_e_();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(ScreenUtils.GUI_BAR);
        int color = element.getSetting(NetworkSettings.NETWORK_COLOR);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        boolean selected = this.connector.getNetworkID() == element.getNetworkID();
        boolean isEncrypted = element.getSetting(NetworkSettings.NETWORK_SECURITY).isEncrypted();
        if (isEncrypted) {
            if (selected) {
                this.blit(x + 131, y, 159, 16, 16, this.elementHeight);
            } else {
                this.blit(x + 131, y, 175, 16, 16, this.elementHeight);
            }
        }
        String text = element.getSetting(NetworkSettings.NETWORK_NAME);
        if (selected) {
            RenderSystem.color3f((float)f, (float)f1, (float)f2);
            this.blit(x, y, 0, 16, this.elementWidth, this.elementHeight);
            this.minecraft.field_71466_p.func_211126_b(text, (float)(x + 4), (float)(y + 2), 0xFFFFFF);
        } else {
            RenderSystem.color3f((float)(f * 0.75f), (float)(f1 * 0.75f), (float)(f2 * 0.75f));
            this.blit(x, y, 0, 16, this.elementWidth, this.elementHeight);
            this.minecraft.field_71466_p.func_211126_b(text, (float)(x + 4), (float)(y + 2), 0x404040);
        }
        GlStateManager.func_227627_O_();
    }

    @Override
    public void renderElementTooltip(IFluxNetwork element, int mouseX, int mouseY) {
        if (this.hasActivePopup()) {
            return;
        }
    }

    @Override
    public boolean mouseClickedMain(double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedMain(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && mouseX > (double)(this.field_147003_i + 45) && mouseX < (double)(this.field_147003_i + 75) && mouseY > (double)(this.field_147009_r + 10) && mouseY < (double)(this.getGuiTop() + 17)) {
            this.sortType = (GuiTabPages.SortType)FluxUtils.incrementEnum((Enum)this.sortType, (Enum[])GuiTabPages.SortType.values());
            this.sortGrids(this.sortType);
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.timer2 == 0) {
            this.refreshPages(FluxNetworkCache.instance.getAllClientNetworks());
        }
        if (this.selectedNetwork != null && FluxNetworks.proxy.getFeedback(true) == EnumFeedbackInfo.SUCCESS) {
            this.closePopUp();
            if (this.connector instanceof FluxConfiguratorItem.ContainerProvider) {
                FluxConfiguratorItem.ContainerProvider networkConnector = (FluxConfiguratorItem.ContainerProvider)this.connector;
                networkConnector.network = this.selectedNetwork;
                networkConnector.networkID = this.selectedNetwork.getNetworkID();
                this.network = this.selectedNetwork;
                boolean bl = this.networkValid = !this.selectedNetwork.isInvalid();
            }
        }
        if (FluxNetworks.proxy.getFeedback(true) == EnumFeedbackInfo.PASSWORD_REQUIRE) {
            this.openPopUp(new PopUpNetworkPassword(this, this.player, this.connector));
            FluxNetworks.proxy.setFeedback(EnumFeedbackInfo.NONE, true);
        }
        ++this.timer2;
        this.timer2 %= 10;
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        switch (sortType) {
            case ID: {
                this.elements.sort(Comparator.comparing(IFluxNetwork::getNetworkID));
                this.refreshCurrentPageInternal();
                break;
            }
            case NAME: {
                this.elements.sort(Comparator.comparing(IFluxNetwork::getNetworkName));
                this.refreshCurrentPageInternal();
            }
        }
    }
}

