/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.magic.ModDamages;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.compatibility.CompatibilityMinecolonies;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.DummyTargetEntity;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.PhantomSpawnerHandler;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.VillageSiegeHandler;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.item.ItemVoodooPoppet;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.TombstoneActivatedMessage;
import ovh.corail.tombstone.network.UpdateClientMessage;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityGrave;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LootTables.field_186388_am)) {
            ((ThreadTaskExecutor)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER)).func_213165_a(() -> {
                LootHelper.addLostEntries(event.getTable());
                LootHelper.addChestEntries(event.getLootTableManager());
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerLogued(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidPlayerMP(event.getPlayer())) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            assert (player.func_184102_h() != null);
            CompoundNBT persistantData = player.getPersistentData();
            if (Helper.isAprilFoolsDay()) {
                persistantData.func_74757_a("pass_april_fool", true);
            } else if (persistantData.func_74764_b("pass_april_fool")) {
                persistantData.func_82580_o("pass_april_fool");
                ModTriggers.PASS_APRIL_FOOL.trigger(player);
            }
            BlockPos spawnPos = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_175694_M();
            int range = player.func_184102_h().func_71262_S() ? player.func_184102_h().func_82357_ak() : 0;
            PacketHandler.sendToPlayer(new UpdateClientMessage(spawnPos, range, Helper.isDateAroundHalloween(LocalDate.now()), Helper.isContributor((PlayerEntity)player)), player);
            PacketHandler.sendToPlayer(CooldownHandler.INSTANCE.getCooldownPacket(player), player);
            EntityHelper.syncTBCapability(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            long systemTicks = TimeHelper.systemTicks();
            if (TimeHelper.atInterval(systemTicks, TimeHelper.tickFromMinute(1))) {
                if (((Boolean)ConfigTombstone.recovery.recoveryPlayerEnable.get()).booleanValue() && TimeHelper.atInterval(systemTicks, TimeHelper.tickFromMinute((Integer)ConfigTombstone.recovery.recoveryPlayerTimer.get()))) {
                    CommandTBRecovery.saveAllPlayers(server, success -> ModTombstone.LOGGER.info((success != false ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).asLog(new Object[0])));
                }
                CommandTBAcceptTeleport.cleanTickets(systemTicks);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> {
            Block block = event.getWorld().func_180495_p(blockPos).func_177230_c();
            return block.func_203417_a(ModTags.Blocks.graves) || block.func_203417_a(ModTags.Blocks.grave_marbles);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBreak(BlockEvent.BreakEvent event) {
        if (((Boolean)ConfigTombstone.general.nerfGhostlyShape.get()).booleanValue() && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape)) {
            event.getPlayer().func_195063_d(ModEffects.ghostly_shape);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRightClickChest(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getHand() == Hand.MAIN_HAND && ((Boolean)ConfigTombstone.general.nerfGhostlyShape.get()).booleanValue() && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape) && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof ChestBlock) {
            event.getPlayer().func_195063_d(ModEffects.ghostly_shape);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            VillageSiegeHandler.instance.checkWorld((ServerWorld)event.getWorld());
            PhantomSpawnerHandler.instance.checkWorld((ServerWorld)event.getWorld());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        if (EffectHelper.isUnstableIntangiblenessActive(event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.ghostly_shape, 5) && Helper.isValidPos(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_180425_c())) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource() != null && EntityHelper.isValidPlayer(event.getSource().func_76346_g())) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            if (event.getEntityLiving() != player) {
                if (EffectHelper.isPotionActive((LivingEntity)player, ModEffects.ghostly_shape)) {
                    player.func_195063_d(ModEffects.ghostly_shape);
                    if (EntityHelper.isValidPlayerMP(player)) {
                        ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayerEntity)player);
                    }
                }
                if (EffectHelper.isPotionActive((LivingEntity)player, ModEffects.diversion)) {
                    player.func_195063_d(ModEffects.diversion);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPreventDeath(LivingDamageEvent event) {
        if (EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving()) && event.getEntityLiving().func_70089_S() && event.getEntityLiving().func_110143_aJ() <= event.getAmount()) {
            Location spawnPos;
            ItemStack soul;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            ItemVoodooPoppet.PoppetProtections prot = ModItems.voodoo_poppet.getPoppetProtections(event.getSource());
            if (prot != null && ModItems.voodoo_poppet.preventDeath((PlayerEntity)player, InventoryHelper.findItemInMainInventory((PlayerEntity)player, p -> ModItems.voodoo_poppet.canPreventDeath((ItemStack)p, prot)), prot)) {
                event.setCanceled(true);
                player.func_145747_a(prot.getLangKey().getTranslation(new Object[0]).func_150255_a(StyleType.MESSAGE_SPECIAL));
                ModTriggers.PREVENT_DEATH.get((Object)prot).trigger(player);
                return;
            }
            boolean preventDeathOutsideWorld = (Boolean)ConfigTombstone.general.preventDeathOutsideWorld.get() != false && !Helper.isValidPos(player.field_70170_p, player.func_180425_c());
            ItemStack itemStack = soul = !preventDeathOutsideWorld ? InventoryHelper.findItemInMainInventory((PlayerEntity)player, p -> p.func_77973_b() == ModItems.soul_receptacle) : ItemStack.field_190927_a;
            if (!(!preventDeathOutsideWorld && soul.func_190926_b() || (spawnPos = new SpawnHelper((ServerWorld)player.field_70170_p, Helper.getCloserValidPos(player.field_70170_p, new BlockPos((Entity)player))).findSpawnPlace(false)).isOrigin())) {
                event.setCanceled(true);
                if (!preventDeathOutsideWorld) {
                    soul.func_190918_g(1);
                }
                player.func_70606_j(player.func_110138_aP());
                EffectHelper.clearBadEffects((LivingEntity)player);
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76443_y, 1200, 10, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, 1200, 10, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.diversion, 1200);
                player.func_145747_a((preventDeathOutsideWorld ? LangKey.MESSAGE_CONFIG_PREVENT_DEATH : LangKey.MESSAGE_SOUL_PREVENT_DEATH).getTranslation(new Object[0]));
                Helper.teleportEntity(player, spawnPos);
                player.field_70143_R = 0.0f;
                return;
            }
            if (((Boolean)ConfigTombstone.recovery.backupOnDeath.get()).booleanValue() && !event.getEntityLiving().func_175149_v()) {
                CommandTBRecovery.savePlayer((ServerPlayerEntity)event.getEntityLiving(), success -> ModTombstone.LOGGER.info((success != false ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getTranslation(event.getEntityLiving().func_200200_C_()).getString()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onCheckAttack(LivingAttackEvent event) {
        Entity immediateSource;
        if (Helper.isAprilFoolsDay() && EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving()) && event.getSource() != null && (immediateSource = event.getSource().func_76364_f()) != null && immediateSource.func_200600_R() == EntityType.field_200746_al && immediateSource.getPersistentData().func_74764_b("april_fool_slowness")) {
            EffectHelper.addEffect(event.getEntityLiving(), Effects.field_76421_d, 200, 1, new boolean[0]);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckAttack(LivingSetAttackTargetEvent event) {
        int lvl;
        if (EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) || event.getTarget() == null) {
            return;
        }
        LivingEntity attacker = event.getEntityLiving();
        if (EffectHelper.isPotionActive(event.getTarget(), ModEffects.ghostly_shape) || EffectHelper.isPotionActive(event.getTarget(), ModEffects.diversion)) {
            ((MobEntity)attacker).field_70696_bz = null;
            if (attacker.field_70755_b == event.getTarget()) {
                attacker.field_70755_b = new DummyTargetEntity(attacker.field_70170_p);
            }
            return;
        }
        if (!((Boolean)SharedConfigTombstone.enchantments.enableEnchantmentShadowStep.get()).booleanValue() || ((Boolean)ConfigTombstone.enchantments.restrictShadowStepToPlayer.get()).booleanValue() && !EntityHelper.isValidPlayer((Entity)event.getTarget())) {
            return;
        }
        if (((Boolean)SharedConfigTombstone.enchantments.nerfShadowStep.get()).booleanValue() && !event.getTarget().func_225608_bj_()) {
            return;
        }
        if (attacker.field_70755_b != event.getTarget() && !event.getTarget().func_184218_aH() && (lvl = Math.min(EntityHelper.getEnchantmentLevel(event.getTarget(), ModEnchantments.shadow_step), 5)) > 0) {
            IAttributeInstance attribute = attacker.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b);
            double range = attribute == null ? 16.0 : attribute.func_111126_e();
            double mult = MathHelper.func_151237_a((double)((event.getTarget().func_225608_bj_() ? 0.6 : 1.0) - (double)lvl * 0.2 + (attacker.field_70170_p.func_72935_r() ? 0.5 : 0.0)), (double)0.05, (double)1.0);
            if ((double)attacker.func_70032_d((Entity)event.getTarget()) < range * mult) {
                attacker.field_70755_b = event.getTarget();
                attacker.field_70756_c = attacker.field_70173_aa;
            } else {
                ((MobEntity)attacker).field_70696_bz = null;
                if (attacker.field_70755_b == event.getTarget()) {
                    attacker.field_70755_b = new DummyTargetEntity(attacker.field_70170_p);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!EntityHelper.isValidPlayerMP(event.getPlayer()) || event.getPlayer().func_175149_v()) {
            return;
        }
        EntityHelper.syncTBCapability((ServerPlayerEntity)event.getPlayer());
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        if (deathHandler.isPlayerDead(event.getPlayer())) {
            if (((Boolean)ConfigTombstone.general.autoEquipOnDeathRespawn.get()).booleanValue()) {
                ListIterator it = event.getPlayer().field_71071_by.field_70462_a.listIterator();
                while (it.hasNext()) {
                    if (!InventoryHelper.autoequip((ItemStack)it.next(), event.getPlayer())) continue;
                    it.set(ItemStack.field_190927_a);
                }
            }
            deathHandler.restorePlayerDead(event.getPlayer());
            event.getPlayer().field_71069_bz.func_75142_b();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onUndeadDrops(LivingDropsEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            LootHelper.handleMobDrops(event.getDrops(), event.getEntityLiving(), event.getSource());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void give(PlayerEvent.Clone event) {
        boolean hasPreservation;
        if (!EntityHelper.isValidPlayer(event.getOriginal()) || !EntityHelper.isValidPlayer(event.getPlayer())) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        PlayerEntity original = event.getOriginal();
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(capPlayer -> {
            LazyOptional capHolder = original.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
            if (!capHolder.isPresent()) {
                original.revive();
            }
            capHolder.ifPresent(capPlayer::copyCapability);
        });
        if (!event.isWasDeath()) {
            return;
        }
        if (EntityHelper.isSurvivalPlayer(player) && ((hasPreservation = EffectHelper.isPotionActive((LivingEntity)player, ModEffects.preservation)) || ((Boolean)SharedConfigTombstone.general.handlePlayerXp.get()).booleanValue())) {
            original.field_71067_cb = EntityHelper.getPlayerTotalXp(original);
            if (hasPreservation || (Integer)SharedConfigTombstone.general.xpLoss.get() == 0 || player.func_184812_l_()) {
                player.field_71067_cb = original.field_71067_cb;
                player.field_71106_cc = original.field_71106_cc;
                player.field_71068_ca = original.field_71068_ca;
            } else {
                int bonus = EntityHelper.getPerkLevelWithBonus(player, ModPerks.memento_mori) * 20;
                EntityHelper.setPlayerXp(player, original.field_71067_cb * MathHelper.func_76125_a((int)(100 + bonus - (Integer)SharedConfigTombstone.general.xpLoss.get()), (int)0, (int)100) / 100);
            }
        }
        if (Helper.isRuleKeepInventory(player)) {
            return;
        }
        ArrayList<ItemStack> misplaced_stacks = new ArrayList<ItemStack>();
        IItemHandler inventPlayer = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse((Object)new ItemStackHandler());
        if (inventPlayer.getSlots() == 1) {
            ModTombstone.LOGGER.warn("The player has no capability inventory in the clone event");
            return;
        }
        for (int currentSlot = 0; currentSlot < event.getOriginal().field_71071_by.field_70462_a.size(); ++currentSlot) {
            ItemStack originalStack = (ItemStack)event.getOriginal().field_71071_by.field_70462_a.get(currentSlot);
            if (originalStack.func_190926_b() || originalStack.func_77973_b() != ModItems.grave_key && EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.soulbound, (ItemStack)originalStack) <= 0) continue;
            ItemStack playerStack = inventPlayer.getStackInSlot(currentSlot);
            if (!playerStack.func_190926_b()) {
                if (ItemStack.func_77989_b((ItemStack)originalStack, (ItemStack)playerStack)) continue;
                ModTombstone.LOGGER.warn("An item was different from the original in the clone event");
                misplaced_stacks.add(inventPlayer.extractItem(currentSlot, playerStack.func_190916_E(), false));
                inventPlayer.insertItem(currentSlot, originalStack.func_77946_l(), false);
                continue;
            }
            inventPlayer.insertItem(currentSlot, originalStack.func_77946_l(), false);
        }
        for (ItemStack stack : misplaced_stacks) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving())) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
        if (event.isCanceled()) {
            if (((Boolean)ConfigTombstone.general.handlePlayerDeath.get()).booleanValue()) {
                ModTombstone.LOGGER.warn("The death event of the player " + player.func_200200_C_() + " was cancelled by another mod");
            }
        } else {
            player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                int knowledgeLoss;
                int n = knowledgeLoss = (Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get() != false && event.getSource() == ModDamages.BEYOND_THE_GRAVE ? 10 : 0;
                if ((Integer)ConfigTombstone.general.knowledgeLoss.get() > 0) {
                    knowledgeLoss += ((Integer)ConfigTombstone.general.knowledgeLoss.get()).intValue();
                }
                if (knowledgeLoss > 0) {
                    cap.removeKnowledgeAndSync(player, knowledgeLoss);
                }
            });
            DeathHandler.INSTANCE.addPlayerDead((PlayerEntity)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() != null && event.getSource() != null && EntityHelper.isValidPlayerMP(event.getSource().func_76346_g())) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getSource().func_76346_g();
            assert (player != null);
            if (!CompatibilityMinecolonies.instance.applyKillResult(player, event.getEntityLiving().func_200600_R())) {
                if (event.getEntityLiving() instanceof VillagerEntity) {
                    EntityHelper.addAlignment((ServerPlayerEntity)event.getSource().func_76346_g(), -1);
                } else if (EntityTypeTags.field_219765_b.func_199685_a_((Object)event.getEntityLiving().func_200600_R()) || event.getEntityLiving() instanceof ZombieEntity && event.getEntityLiving().getPersistentData().func_74767_n("siege") || event.getEntityLiving() instanceof PhantomEntity) {
                    EntityHelper.addAlignment((ServerPlayerEntity)event.getSource().func_76346_g(), 1, 0.3f);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (((Boolean)SharedConfigTombstone.general.handlePlayerXp.get()).booleanValue() && EntityHelper.isValidPlayer((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    private static void storeSoulboundsOnBody(PlayerEntity player, List<ItemStack> keys, List<ItemStack> soulbounds) {
        for (ItemStack key : keys) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)key);
        }
        keys.clear();
        for (ItemStack soulbound : soulbounds) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)soulbound);
        }
        soulbounds.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDrops(LivingDropsEvent event) {
        boolean needAccess;
        BlockState state;
        boolean hasGrave;
        TileEntity tile;
        Location lastGrave;
        boolean hasDrop;
        if (!EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving())) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
        if (Helper.isRuleKeepInventory((PlayerEntity)player)) {
            return;
        }
        ServerWorld world = player.func_71121_q();
        if (event.isCanceled()) {
            ModTombstone.LOGGER.warn("The drop event of the player " + player.func_146103_bH().getName() + " was cancelled by another mod");
            return;
        }
        Iterator it = event.getDrops().iterator();
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        ArrayList<ItemStack> soulbounds = new ArrayList<ItemStack>();
        while (it.hasNext()) {
            ItemEntity entityItem = (ItemEntity)it.next();
            if (entityItem == null || entityItem.func_92059_d().func_190926_b()) continue;
            ItemStack stack = entityItem.func_92059_d();
            if (stack.func_77973_b() == ModItems.grave_key) {
                keys.add(stack.func_77946_l());
                it.remove();
                continue;
            }
            if (!((Boolean)SharedConfigTombstone.enchantments.enableEnchantmentSoulbound.get()).booleanValue() || EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.soulbound, (ItemStack)stack) <= 0) continue;
            soulbounds.add(stack.func_77946_l());
            it.remove();
        }
        double range = ((Integer)ConfigTombstone.general.snifferRange.get()).intValue();
        List itemList = player.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(player.func_226277_ct_() - range, player.func_226278_cu_() - range, player.func_226281_cx_() - range, player.func_226277_ct_() + range, player.func_226278_cu_() + range, player.func_226281_cx_() + range));
        it = itemList.listIterator();
        while (it.hasNext()) {
            ItemEntity entityItem = (ItemEntity)it.next();
            if (entityItem == null || entityItem.func_92059_d().func_190926_b()) continue;
            ItemStack stack = entityItem.func_92059_d();
            if (stack.func_77973_b() == ModItems.grave_key) {
                keys.add(stack.func_77946_l());
                it.remove();
                continue;
            }
            if (!((Boolean)SharedConfigTombstone.enchantments.enableEnchantmentSoulbound.get()).booleanValue() || EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.soulbound, (ItemStack)stack) <= 0) continue;
            soulbounds.add(stack.func_77946_l());
            it.remove();
        }
        boolean bl = hasDrop = itemList.size() > 0 || event.getDrops().size() > 0;
        if (!((Boolean)ConfigTombstone.general.handlePlayerDeath.get()).booleanValue() || !hasDrop) {
            ModItems.grave_key.reenchantOnDeath((PlayerEntity)player, keys.stream().filter(p -> !ModItems.grave_key.isEnchanted((ItemStack)p)).findFirst().orElse(ItemStack.field_190927_a));
            EventHandler.storeSoulboundsOnBody((PlayerEntity)player, keys, soulbounds);
            if (!hasDrop) {
                player.func_145747_a(LangKey.MESSAGE_NO_LOOT_FOR_GRAVE.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, new Object[0]));
            }
            return;
        }
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        if (deathHandler.isNoGraveLocation(new Location((Entity)player))) {
            player.func_145747_a(LangKey.MESSAGE_NO_GRAVE_LOCATION.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, new Object[0]));
            EventHandler.storeSoulboundsOnBody((PlayerEntity)player, keys, soulbounds);
            return;
        }
        BlockPos initPos = Helper.getCloserValidPos((World)world, new BlockPos((Entity)player));
        Location spawnPos = Location.ORIGIN;
        TileEntityGrave tileGrave = ((Chunk)world.func_217349_x(initPos)).func_177434_r().values().stream().filter(grave -> grave instanceof TileEntityGrave && ((TileEntityGrave)((Object)grave)).getOwnerName().equals(player.func_146103_bH().getName()) && ((TileEntityGrave)((Object)grave)).hasEmptySlots(event.getDrops().size())).map(grave -> (TileEntityGrave)((Object)grave)).findFirst().orElse(null);
        if (tileGrave != null) {
            if (ModBlocks.graves.containsValue(world.func_180495_p(tileGrave.func_174877_v()).func_177230_c())) {
                spawnPos = new Location(tileGrave.func_174877_v(), (IWorld)world);
            } else {
                tileGrave.dropOnGroundAndRemove();
            }
        }
        if (spawnPos.isOrigin() && !(lastGrave = deathHandler.getLastGrave(player.func_146103_bH().getName())).isOrigin() && lastGrave.dim == Helper.getDimensionId((IWorld)world) && Helper.getDistanceSq((Vec3i)lastGrave.getPos(), (Vec3i)initPos) <= 400.0 && (tile = world.func_175625_s(lastGrave.getPos())) instanceof TileEntityGrave) {
            TileEntityGrave grave2 = (TileEntityGrave)tile;
            if (world.func_180495_p(lastGrave.getPos()).func_203425_a(ModTags.Blocks.player_graves)) {
                if (grave2.hasEmptySlots(event.getDrops().size())) {
                    spawnPos = lastGrave;
                }
            } else {
                grave2.dropOnGroundAndRemove();
            }
        }
        boolean bl2 = hasGrave = !spawnPos.isOrigin();
        if (!hasGrave && (spawnPos = new SpawnHelper(world, initPos).findSpawnPlace(true)).isOrigin()) {
            EventHandler.storeSoulboundsOnBody((PlayerEntity)player, keys, soulbounds);
            player.func_145747_a(LangKey.MESSAGE_NO_PLACE_FOR_GRAVE.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, new Object[0]));
            ModTombstone.LOGGER.info("There was nowhere to place the grave!");
            return;
        }
        if (!hasGrave) {
            deathHandler.logLastGrave((PlayerEntity)player, spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim);
            Direction facing = player.func_174811_aO().func_176734_d();
            Pair<GraveModel, BlockGraveMarble.MarbleType> favoriteGrave = deathHandler.getFavoriteGrave(player);
            Block graveBlock = ModBlocks.graves.get(favoriteGrave.getLeft());
            state = (BlockState)((BlockState)((BlockState)graveBlock.func_176223_P().func_206870_a((IProperty)BlockGraveBase.FACING, (Comparable)facing)).func_206870_a((IProperty)BlockGraveBase.IS_ENGRAVED, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)BlockGraveBase.MODEL_TEXTURE, (Comparable)Integer.valueOf(((BlockGraveMarble.MarbleType)((Object)favoriteGrave.getRight())).ordinal()));
            Helper.placeNoEvent((World)world, spawnPos.getPos(), state);
        } else {
            state = world.func_180495_p(spawnPos.getPos());
        }
        TileEntity tile2 = world.func_175625_s(spawnPos.getPos());
        if (!(tile2 instanceof TileEntityGrave)) {
            EventHandler.storeSoulboundsOnBody((PlayerEntity)player, keys, soulbounds);
            player.func_145747_a(LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, new Object[0]));
            ModTombstone.LOGGER.info((Object)LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.getTranslation(new Object[0]));
            return;
        }
        deathHandler.setLastDeathLocation((PlayerEntity)player, new Location(spawnPos.x, spawnPos.y + 1, spawnPos.z, spawnPos.dim));
        TileEntityGrave grave3 = (TileEntityGrave)tile2;
        if (hasGrave) {
            grave3.resetDeathTime();
            grave3.countTicks = 0;
        }
        boolean bl3 = needAccess = (Boolean)ConfigTombstone.general.playerGraveAccess.get() != false && (Integer)SharedConfigTombstone.general.decayTime.get() != 0;
        if (needAccess && ((Boolean)ConfigTombstone.general.pvpMode.get()).booleanValue() && event.getSource() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            needAccess = false;
        }
        player.func_145747_a((hasGrave ? LangKey.MESSAGE_EXISTING_GRAVE : LangKey.MESSAGE_NEW_GRAVE).getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, LangKey.MESSAGE_JOURNEYMAP.getTranslationWithStyle(StyleType.TOOLTIP_DESC, LangKey.MESSAGE_LAST_GRAVE.getTranslation(new Object[0]), spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim), LangKey.createComponentTranslationWithStyle((PlayerEntity)player, needAccess ? StyleType.COLOR_OFF : StyleType.COLOR_ON, needAccess ? LangKey.MESSAGE_LOCKED : LangKey.MESSAGE_UNLOCKED, needAccess && (Integer)SharedConfigTombstone.general.decayTime.get() > 0 ? SharedConfigTombstone.general.decayTime.get() + " min" : "")));
        if (((Boolean)ConfigTombstone.general.playerGraveAccess.get()).booleanValue() || ((Boolean)ConfigTombstone.general.graveKeyOnDeath.get()).booleanValue()) {
            ItemStack key;
            if (hasGrave) {
                key = ItemStack.field_190927_a;
                for (ItemStack aKey : keys) {
                    if (!ModItems.grave_key.getTombPos(aKey).equals(spawnPos)) continue;
                    ModItems.grave_key.reenchantOnDeath((PlayerEntity)player, aKey);
                    key = aKey;
                    break;
                }
                if (key.func_190926_b()) {
                    key = new ItemStack((IItemProvider)ModItems.grave_key);
                    ModItems.grave_key.setTombPos(key, spawnPos);
                    ModItems.grave_key.reenchantOnDeath((PlayerEntity)player, key);
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)key);
                }
            } else {
                key = new ItemStack((IItemProvider)ModItems.grave_key);
                ModItems.grave_key.setTombPos(key, spawnPos);
                ModItems.grave_key.reenchantOnDeath((PlayerEntity)player, key);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)key);
            }
        }
        EventHandler.storeSoulboundsOnBody((PlayerEntity)player, keys, soulbounds);
        grave3.setOwner((Entity)player, TimeHelper.systemTime(), needAccess);
        for (ItemEntity entityItem : event.getDrops()) {
            if (entityItem == null || entityItem.func_92059_d().func_190926_b()) continue;
            grave3.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(itemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d().func_77946_l(), (boolean)false));
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        for (ItemEntity entityItem : itemList) {
            grave3.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(itemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d().func_77946_l(), (boolean)false));
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        world.func_184138_a(spawnPos.getPos(), Blocks.field_150350_a.func_176223_P(), state, 2);
        ModTriggers.FIRST_GRAVE.trigger(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        if (event.getName() == null || event.getLeft().func_190926_b() || event.getRight().func_190926_b()) {
            return;
        }
        if (!event.getName().isEmpty() && event.getRight().func_77973_b().func_206844_a(Tags.Items.INGOTS_IRON) && event.getLeft().func_77973_b() instanceof ItemBlockGrave) {
            ItemStack output = event.getLeft().func_77946_l();
            if (ItemBlockGrave.setEngravedName(output, event.getName())) {
                event.setCost(2);
                event.setOutput(output);
                event.setMaterialCost(1);
            } else {
                EventHandler.cancelAnvilRecipe(event);
            }
        } else if (!event.getName().isEmpty() && ModItems.tablet_of_assistance.isEnchanted(event.getLeft()) && event.getRight().func_77973_b() == ModItems.grave_dust) {
            ItemStack output = event.getLeft().func_77946_l();
            if (ModItems.tablet_of_assistance.setEngravedName(output, event.getName())) {
                event.setCost(2);
                event.setOutput(output);
                event.setMaterialCost(1);
            } else {
                EventHandler.cancelAnvilRecipe(event);
            }
        }
    }

    private static void cancelAnvilRecipe(AnvilUpdateEvent event) {
        event.setCost(0);
        event.setMaterialCost(0);
        event.setOutput(ItemStack.field_190927_a);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilRepair(AnvilRepairEvent event) {
        if (EntityHelper.isValidPlayerMP(event.getPlayer()) && event.getItemInput().func_77973_b() instanceof ItemBlockGrave && event.getIngredientInput().func_77973_b().func_206844_a(Tags.Items.INGOTS_IRON) && ItemBlockGrave.isEngraved(event.getItemResult())) {
            ModTriggers.ENGRAVE_DECORATIVE_GRAVE.trigger((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void uncancelGraveRightClick(PlayerInteractEvent.RightClickBlock event) {
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        if (block instanceof BlockGrave) {
            if (event.isCanceled()) {
                event.setCanceled(false);
                event.setUseBlock(Event.Result.DEFAULT);
                event.setUseItem(Event.Result.DEFAULT);
            }
            if (event.getWorld().field_72995_K && SpawnProtectionHandler.getInstance().isBlockProtected(Helper.getDimensionId((IWorld)event.getWorld()), event.getPos())) {
                PacketHandler.sendToServer(new TombstoneActivatedMessage(event.getPos()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onUpdateShadowStep(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K && ((Boolean)SharedConfigTombstone.enchantments.enableEnchantmentShadowStep.get()).booleanValue() && ((Boolean)ConfigTombstone.client.showShadowStep.get()).booleanValue() && (!((Boolean)SharedConfigTombstone.enchantments.nerfShadowStep.get()).booleanValue() || event.getEntity().func_225608_bj_()) && EntityHelper.hasEnchantment(event.getEntityLiving(), ModEnchantments.shadow_step)) {
            ModTombstone.PROXY.produceShadowStep(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        if (event.getItem().func_77973_b() == Items.field_151068_bn && EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving()) && PotionUtils.func_185189_a((ItemStack)event.getItem()).size() > 0) {
            event.getEntityLiving().getPersistentData().func_74757_a("is_drinking_potion", true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseStop(LivingEntityUseItemEvent.Stop event) {
        if (EventHandler.isDrinking(event.getEntityLiving())) {
            EventHandler.resetDrinking(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (EventHandler.isDrinking(event.getEntityLiving())) {
            EventHandler.resetDrinking(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        if (EventHandler.isDrinking(event.getEntityLiving()) && event.getPotionEffect().field_76460_b > 1200 && EffectHelper.isAllowedEffect(event.getPotionEffect().func_188419_a())) {
            float bonus = 1.0f + (float)EntityHelper.getPerkLevelWithBonus((PlayerEntity)event.getEntityLiving(), ModPerks.alchemist) * 0.1f;
            EffectHelper.modifyEffectDuration(event.getPotionEffect(), e -> MathHelper.func_76141_d((float)((float)e.field_76460_b * bonus)));
        }
    }

    private static boolean isDrinking(LivingEntity entityLiving) {
        return entityLiving.getPersistentData().func_150297_b("is_drinking_potion", 1);
    }

    private static void resetDrinking(LivingEntity entityLiving) {
        entityLiving.getPersistentData().func_82580_o("is_drinking_potion");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreventFamiliarDeath(LivingDamageEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().func_70089_S() && event.getEntityLiving().func_110143_aJ() <= event.getAmount() && ModItems.familiar_receptacle.captureSoul(event.getEntityLiving())) {
            event.setCanceled(true);
            event.getEntityLiving().remove(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityDamage(LivingDamageEvent event) {
        if (event.getSource() == null || !EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving()) || !event.getEntityLiving().func_70089_S()) {
            return;
        }
        if (event.getSource() == ModDamages.BEYOND_THE_GRAVE) {
            if (((Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get()).booleanValue()) {
                event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                    int knowledgeLevel = cap.getTotalPerkPoints();
                    if (knowledgeLevel > 0) {
                        event.setAmount(event.getAmount() * (1.0f - (float)Math.min(20, knowledgeLevel) * 0.05f));
                    }
                });
            }
        } else {
            int alignmentLevel = (Integer)event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(ITBCapability::getAlignmentLevel).orElse((Object)0);
            if (alignmentLevel != 0 && event.getSource().func_76346_g() instanceof MobEntity) {
                boolean valid;
                boolean bl = ((MobEntity)event.getSource().func_76346_g()).func_70662_br() ? alignmentLevel > 0 : (valid = alignmentLevel < 0);
                if (valid) {
                    float amount = event.getAmount() * (1.0f - 0.1f * (float)Math.abs(alignmentLevel));
                    if (amount < 0.5f) {
                        event.setCanceled(true);
                    } else {
                        event.setAmount(amount);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        Item heldItem = event.getPlayer().func_184586_b(event.getHand()).func_77973_b();
        if (heldItem == ModItems.dust_of_vanishing || heldItem instanceof ItemGraveMagic) {
            event.setCancellationResult(ActionResultType.PASS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("tombstone", "cap_tombstone"), (ICapabilityProvider)new TBCapabilityProvider());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSyncOnChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (EntityHelper.isValidPlayer(event.getPlayer()) && !event.getPlayer().field_70170_p.field_72995_K) {
            ServerWorld toDim;
            long toTime;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            EntityHelper.syncTBCapability(player);
            MinecraftServer server = event.getPlayer().func_184102_h();
            if (server == null) {
                return;
            }
            ServerWorld fromDim = server.func_71218_a(event.getFrom());
            long fromTime = fromDim.func_82737_E();
            if (fromTime != (toTime = (toDim = server.func_71218_a(event.getTo())).func_82737_E())) {
                CooldownHandler.INSTANCE.updateWorldTime(player, toTime - fromTime);
                event.getPlayer().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(inventPlayer -> IntStream.range(0, inventPlayer.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inventPlayer).getStackInSlot(arg_0)).filter(stack -> stack.func_77973_b() == ModItems.lost_tablet).forEach(stack -> ModItems.lost_tablet.setCooldown((World)toDim, (ItemStack)stack, Math.min(ModItems.lost_tablet.getCooldown((World)fromDim, (ItemStack)stack), TimeHelper.tickFromMinute(10)))));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack mainHandStack;
        if (event.getHand() == Hand.MAIN_HAND && EntityHelper.isValidPlayer(event.getPlayer()) && (mainHandStack = event.getPlayer().func_184614_ca()).func_77973_b() == ModItems.bone_needle && event.getTarget() instanceof LivingEntity && mainHandStack.func_111282_a(event.getPlayer(), (LivingEntity)event.getTarget(), event.getHand())) {
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }
    }
}

