/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.GameData;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.SupportStructures;

public class CommandTBTeleportDiscovery
extends TombstoneCommand {
    private static final ResourceLocation DEFAULT_STRUCTURE = new ResourceLocation("minecraft", "village");

    public CommandTBTeleportDiscovery(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbteleportdiscovery";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        ((LiteralArgumentBuilder)builder.executes(c -> this.showUsage((CommandSource)c.getSource()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(c -> this.teleportDiscovery((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), DEFAULT_STRUCTURE))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"structure", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGESTION_STRUCTURE).executes(c -> this.teleportDiscovery((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), ResourceLocationArgument.func_197195_e((CommandContext)c, (String)"structure")))).then(Commands.func_197056_a((String)"dim", (ArgumentType)IntegerArgumentType.integer()).suggests(SUGGESTION_DIM_IDS).executes(c -> this.teleportDiscovery((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), ResourceLocationArgument.func_197195_e((CommandContext)c, (String)"structure"), ((CommandSource)c.getSource()).func_197028_i().func_71218_a(this.getOrThrowDimensionType(IntegerArgumentType.getInteger((CommandContext)c, (String)"dim"))))))));
        return builder;
    }

    private int teleportDiscovery(CommandSource sender, Entity target, ResourceLocation structureRL) {
        return this.teleportDiscovery(sender, target, structureRL, (ServerWorld)target.field_70170_p);
    }

    private int teleportDiscovery(CommandSource sender, Entity target, ResourceLocation structureRL, ServerWorld world) {
        CommandTBTeleportDiscovery.checkAlive(target);
        CommandTBTeleportDiscovery.checkNotSpectator(target);
        if (!GameData.getStructureFeatures().func_148742_b().contains(structureRL)) {
            throw LangKey.MESSAGE_INVALID_STRUCTURE.asCommandException(new Object[0]);
        }
        if (!world.func_72912_H().func_76089_r()) {
            throw LangKey.MESSAGE_NO_STRUCTURE.asCommandException(new Object[0]);
        }
        int y = SupportStructures.getY(structureRL);
        BlockPos targetPos = new BlockPos(target.func_226277_ct_(), (double)y, target.func_226281_cx_());
        Location structureLoc = Helper.findNearestStructure(world, targetPos, structureRL, y, true);
        if (structureLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_STRUCTURE.asCommandException(new Object[0]);
        }
        Location spawnLoc = new SpawnHelper(world, structureLoc.getPos()).findPlaceInStructure(structureRL);
        if (spawnLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        this.runNextTick(() -> {
            Entity newEntity = Helper.teleportEntity(target, spawnLoc);
            this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getTranslation(newEntity.func_200200_C_(), LangKey.MESSAGE_HERE.getTranslation(new Object[0]), spawnLoc.x, spawnLoc.y, spawnLoc.z, spawnLoc.dim), false);
            if (EntityHelper.isValidPlayer(newEntity)) {
                newEntity.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslationWithStyle(StyleType.MESSAGE_SPELL, new Object[0]));
            }
        });
        return 1;
    }
}

