/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.world.BOPLayerUtil;
import biomesoplenty.init.ModBiomes;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.traits.IAreaTransformer2;
import net.minecraft.world.gen.layer.traits.IDimOffset1Transformer;

public enum SubBiomeLayer implements IAreaTransformer2,
IDimOffset1Transformer
{
    INSTANCE;

    private static final int BIRCH_FOREST;
    private static final int BIRCH_FOREST_HILLS;
    private static final int DESERT;
    private static final int DESERT_HILLS;
    private static final int MOUNTAINS;
    private static final int WOODED_MOUNTAINS;
    private static final int FOREST;
    private static final int WOODED_HILLS;
    private static final int SNOWY_TUNDRA;
    private static final int SNOWY_MOUNTAINS;
    private static final int JUNGLE;
    private static final int JUNGLE_HILLS;
    private static final int BAMBOO_JUNGLE;
    private static final int BAMBOO_JUNGLE_HILLS;
    private static final int BADLANDS;
    private static final int WOODED_BADLANDS_PLATEAU;
    private static final int PLAINS;
    private static final int GIANT_TREE_TAIGA;
    private static final int GIANT_TREE_TAIGA_HILLS;
    private static final int DARK_FOREST;
    private static final int SAVANNA;
    private static final int SAVANA_PLATEAU;
    private static final int TAIGA;
    private static final int SNOWY_TAIGA;
    private static final int SNOWY_TAIGA_HILLS;
    private static final int TAIGA_HILLS;

    public int func_215723_a(INoiseRandom context, IArea biomeArea, IArea riverAndSubBiomesInitArea, int x, int z) {
        Biome biome;
        boolean tryRareBiome;
        int biomeId = biomeArea.func_202678_a(this.func_215721_a(x + 1), this.func_215722_b(z + 1));
        int initVal = riverAndSubBiomesInitArea.func_202678_a(this.func_215721_a(x + 1), this.func_215722_b(z + 1));
        int subBiomeType = (initVal - 2) % 29;
        boolean tryRareHillsBiome = subBiomeType == 0;
        boolean bl = tryRareBiome = subBiomeType == 1;
        if (!(BOPLayerUtil.isShallowOcean(biomeId) || initVal < 2 || !tryRareBiome || (biome = (Biome)Registry.field_212624_m.func_148745_a(biomeId)) != null && biome.func_185363_b())) {
            Biome mutatedBiome = Biome.func_185356_b((Biome)biome);
            return mutatedBiome == null ? biomeId : Registry.field_212624_m.func_148757_b((Object)mutatedBiome);
        }
        if (context.func_202696_a(3) == 0 || tryRareHillsBiome) {
            int mutatedBiomeId = this.getCommonSubBiomeId(context, biomeId);
            if (mutatedBiomeId != biomeId) {
                return mutatedBiomeId;
            }
            mutatedBiomeId = this.getRareSubBiomeId(context, biomeId);
            if (subBiomeType == 0 && mutatedBiomeId != biomeId) {
                Biome mutatedBiome = Biome.func_185356_b((Biome)((Biome)Registry.field_212624_m.func_148745_a(mutatedBiomeId)));
                int n = mutatedBiomeId = mutatedBiome == null ? biomeId : Registry.field_212624_m.func_148757_b((Object)mutatedBiome);
            }
            if (mutatedBiomeId != biomeId) {
                int surroundingSimilarCount = 0;
                if (LayerUtil.func_202826_a((int)biomeArea.func_202678_a(x + 1, z + 0), (int)biomeId)) {
                    ++surroundingSimilarCount;
                }
                if (LayerUtil.func_202826_a((int)biomeArea.func_202678_a(x + 2, z + 1), (int)biomeId)) {
                    ++surroundingSimilarCount;
                }
                if (LayerUtil.func_202826_a((int)biomeArea.func_202678_a(x + 0, z + 1), (int)biomeId)) {
                    ++surroundingSimilarCount;
                }
                if (LayerUtil.func_202826_a((int)biomeArea.func_202678_a(x + 1, z + 2), (int)biomeId)) {
                    ++surroundingSimilarCount;
                }
                if (surroundingSimilarCount >= 3) {
                    return mutatedBiomeId;
                }
            }
        }
        return biomeId;
    }

    public int getCommonSubBiomeId(INoiseRandom context, int originalBiomeId) {
        BOPClimates.WeightedBiomeEntry item;
        float rarity = (float)context.func_202696_a(100) / 100.0f;
        ArrayList weightedBiomeEntryList = Lists.newArrayList();
        int selectedBiomeId = originalBiomeId;
        int totalWeight = 0;
        for (ModBiomes.WeightedSubBiome entry : ModBiomes.subBiomes.get((Object)originalBiomeId)) {
            if (!(entry.rarity >= rarity)) continue;
            weightedBiomeEntryList.add(new BOPClimates.WeightedBiomeEntry(entry.weight, entry.biome));
            totalWeight += entry.weight;
        }
        if (totalWeight <= 0) {
            return selectedBiomeId;
        }
        int weight = context.func_202696_a(totalWeight);
        Iterator iterator = weightedBiomeEntryList.iterator();
        do {
            item = (BOPClimates.WeightedBiomeEntry)iterator.next();
        } while ((weight -= item.weight) >= 0);
        selectedBiomeId = Registry.field_212624_m.func_148757_b((Object)item.biome);
        return selectedBiomeId;
    }

    public int getRareSubBiomeId(INoiseRandom context, int originalBiomeId) {
        int mutatedBiomeId = originalBiomeId;
        if (originalBiomeId == DESERT) {
            mutatedBiomeId = DESERT_HILLS;
        } else if (originalBiomeId == FOREST) {
            mutatedBiomeId = WOODED_HILLS;
        } else if (originalBiomeId == BIRCH_FOREST) {
            mutatedBiomeId = BIRCH_FOREST_HILLS;
        } else if (originalBiomeId == DARK_FOREST) {
            mutatedBiomeId = PLAINS;
        } else if (originalBiomeId == TAIGA) {
            mutatedBiomeId = TAIGA_HILLS;
        } else if (originalBiomeId == GIANT_TREE_TAIGA) {
            mutatedBiomeId = GIANT_TREE_TAIGA_HILLS;
        } else if (originalBiomeId == SNOWY_TAIGA) {
            mutatedBiomeId = SNOWY_TAIGA_HILLS;
        } else if (originalBiomeId == PLAINS && BOPBiomes.orchard.isPresent()) {
            mutatedBiomeId = Registry.field_212624_m.func_148757_b((Object)BOPBiomes.orchard.get());
        } else if (originalBiomeId == SNOWY_TUNDRA) {
            mutatedBiomeId = SNOWY_MOUNTAINS;
        } else if (originalBiomeId == JUNGLE) {
            mutatedBiomeId = JUNGLE_HILLS;
        } else if (originalBiomeId == BAMBOO_JUNGLE) {
            mutatedBiomeId = BAMBOO_JUNGLE_HILLS;
        } else if (originalBiomeId == BOPLayerUtil.OCEAN) {
            mutatedBiomeId = BOPLayerUtil.DEEP_OCEAN;
        } else if (originalBiomeId == BOPLayerUtil.LUKEWARM_OCEAN) {
            mutatedBiomeId = BOPLayerUtil.DEEP_LUKEWARM_OCEAN;
        } else if (originalBiomeId == BOPLayerUtil.COLD_OCEAN) {
            mutatedBiomeId = BOPLayerUtil.DEEP_COLD_OCEAN;
        } else if (originalBiomeId == BOPLayerUtil.FROZEN_OCEAN) {
            mutatedBiomeId = BOPLayerUtil.DEEP_FROZEN_OCEAN;
        } else if (originalBiomeId == MOUNTAINS) {
            mutatedBiomeId = WOODED_MOUNTAINS;
        } else if (originalBiomeId == SAVANNA) {
            mutatedBiomeId = SAVANA_PLATEAU;
        } else if (LayerUtil.func_202826_a((int)originalBiomeId, (int)WOODED_BADLANDS_PLATEAU)) {
            mutatedBiomeId = BADLANDS;
        }
        return mutatedBiomeId;
    }

    static {
        BIRCH_FOREST = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150583_P);
        BIRCH_FOREST_HILLS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150582_Q);
        DESERT = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76769_d);
        DESERT_HILLS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76786_s);
        MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76770_e);
        WOODED_MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150580_W);
        FOREST = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76767_f);
        WOODED_HILLS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76785_t);
        SNOWY_TUNDRA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76774_n);
        SNOWY_MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76775_o);
        JUNGLE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76782_w);
        JUNGLE_HILLS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76792_x);
        BAMBOO_JUNGLE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_222370_aw);
        BAMBOO_JUNGLE_HILLS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_222371_ax);
        BADLANDS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150589_Z);
        WOODED_BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150607_aa);
        PLAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76772_c);
        GIANT_TREE_TAIGA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150578_U);
        GIANT_TREE_TAIGA_HILLS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150581_V);
        DARK_FOREST = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150585_R);
        SAVANNA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150588_X);
        SAVANA_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150587_Y);
        TAIGA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76768_g);
        SNOWY_TAIGA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150584_S);
        SNOWY_TAIGA_HILLS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150579_T);
        TAIGA_HILLS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76784_u);
    }
}

