/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;

public class BigTreeFeature
extends TreeFeatureBase {
    private double trunkHeightScale = 0.618;
    private double branchSlope = 0.381;
    private double widthScale = 1.0;
    private int trunkWidth = 1;
    private int foliageHeight;
    private double foliageDensity;

    protected BigTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight, int trunkWidth, int foliageHeight, double foliageDensity) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.foliageHeight = foliageHeight;
        this.foliageDensity = foliageDensity;
        this.trunkWidth = trunkWidth;
    }

    private void crossSection(IWorld world, BlockPos pos, float radius, MutableBoundingBox boundingBox, Set<BlockPos> changedBlocks) {
        int r = (int)((double)radius + this.trunkHeightScale);
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                BlockPos blockpos;
                if (!(Math.pow((double)Math.abs(dx) + 0.5, 2.0) + Math.pow((double)Math.abs(dz) + 0.5, 2.0) <= (double)(radius * radius)) || !this.replace.matches(world, blockpos = pos.func_177982_a(dx, 0, dz))) continue;
                if (this.altLeaves != Blocks.field_150350_a.func_176223_P()) {
                    int rand = new Random().nextInt(4);
                    if (rand == 0) {
                        this.placeBlock(world, blockpos, this.altLeaves, changedBlocks, boundingBox);
                        continue;
                    }
                    this.placeBlock(world, blockpos, this.leaves, changedBlocks, boundingBox);
                    continue;
                }
                this.placeBlock(world, blockpos, this.leaves, changedBlocks, boundingBox);
            }
        }
    }

    private float treeShape(int height, int y) {
        if ((float)y < (float)height * 0.3f) {
            return -1.0f;
        }
        float radius = (float)height / 2.0f;
        float adjacent = radius - (float)y;
        float distance = MathHelper.func_76129_c((float)(radius * radius - adjacent * adjacent));
        if (adjacent == 0.0f) {
            distance = radius;
        } else if (Math.abs(adjacent) >= radius) {
            return 0.0f;
        }
        return distance * 0.5f;
    }

    private float foliageShape(int y) {
        if (y < 0 || y >= this.foliageHeight) {
            return -1.0f;
        }
        if (y == 0 || y == this.foliageHeight - 1) {
            return 2.0f;
        }
        return 3.0f;
    }

    private void foliageCluster(IWorld world, BlockPos pos, MutableBoundingBox boundingBox, Set<BlockPos> changedBlocks) {
        for (int y = 0; y < this.foliageHeight; ++y) {
            this.crossSection(world, pos.func_177981_b(y), this.foliageShape(y), boundingBox, changedBlocks);
        }
    }

    private int checkLineAndOptionallySet(Set<BlockPos> changedBlocks, IWorld world, BlockPos startPos, BlockPos endPos, boolean set, MutableBoundingBox boundingBox) {
        if (!set && Objects.equals(startPos, endPos)) {
            return -1;
        }
        BlockPos delta = endPos.func_177982_a(-startPos.func_177958_n(), -startPos.func_177956_o(), -startPos.func_177952_p());
        int steps = this.getGreatestDistance(delta);
        float dx = (float)delta.func_177958_n() / (float)steps;
        float dy = (float)delta.func_177956_o() / (float)steps;
        float dz = (float)delta.func_177952_p() / (float)steps;
        for (int j = 0; j <= steps; ++j) {
            BlockPos deltaPos = startPos.func_177963_a((double)(0.5f + (float)j * dx), (double)(0.5f + (float)j * dy), (double)(0.5f + (float)j * dz));
            if (set) {
                this.placeLog(world, deltaPos, this.getLogAxis(startPos, deltaPos), changedBlocks, boundingBox);
                continue;
            }
            if (BigTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)deltaPos)) continue;
            return j;
        }
        return -1;
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = MathHelper.func_76130_a((int)posIn.func_177958_n());
        int j = MathHelper.func_76130_a((int)posIn.func_177956_o());
        int k = MathHelper.func_76130_a((int)posIn.func_177952_p());
        return k > i && k > j ? k : (j > i ? j : i);
    }

    private Direction.Axis getLogAxis(BlockPos startPos, BlockPos endPos) {
        int zDiff;
        Direction.Axis axis = Direction.Axis.Y;
        int xDiff = Math.abs(endPos.func_177958_n() - startPos.func_177958_n());
        int maxDiff = Math.max(xDiff, zDiff = Math.abs(endPos.func_177952_p() - startPos.func_177952_p()));
        if (maxDiff > 0) {
            if (xDiff == maxDiff) {
                axis = Direction.Axis.X;
            } else if (zDiff == maxDiff) {
                axis = Direction.Axis.Z;
            }
        }
        return axis;
    }

    private void makeFoliage(IWorld worldIn, int height, BlockPos pos, List<FoliageCoordinates> coordinates, MutableBoundingBox boundingBox, Set<BlockPos> changedBlocks) {
        for (FoliageCoordinates coordinate : coordinates) {
            if (!this.trimBranches(height, coordinate.getBranchBase() - pos.func_177956_o())) continue;
            this.foliageCluster(worldIn, coordinate, boundingBox, changedBlocks);
        }
    }

    private boolean trimBranches(int height, int localY) {
        return (double)localY >= (double)height * 0.2;
    }

    private void makeTrunk(Set<BlockPos> changedBlocks, IWorld world, BlockPos pos, int height, MutableBoundingBox boundingBox) {
        this.checkLineAndOptionallySet(changedBlocks, world, pos, pos.func_177981_b(height), true, boundingBox);
        if (this.trunkWidth == 2) {
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177974_f(), pos.func_177981_b(height).func_177974_f(), true, boundingBox);
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177974_f().func_177968_d(), pos.func_177981_b(height).func_177974_f().func_177968_d(), true, boundingBox);
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177968_d(), pos.func_177981_b(height).func_177968_d(), true, boundingBox);
        }
        if (this.trunkWidth == 4) {
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177974_f(), pos.func_177981_b(height).func_177974_f(), true, boundingBox);
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177974_f().func_177968_d(), pos.func_177981_b(height).func_177974_f().func_177968_d(), true, boundingBox);
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177968_d(), pos.func_177981_b(height).func_177968_d(), true, boundingBox);
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177978_c(), pos.func_177981_b(height).func_177978_c(), true, boundingBox);
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177978_c().func_177974_f(), pos.func_177981_b(height).func_177978_c().func_177974_f(), true, boundingBox);
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177974_f().func_177974_f(), pos.func_177981_b(height).func_177974_f().func_177974_f(), true, boundingBox);
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177968_d().func_177974_f().func_177974_f(), pos.func_177981_b(height).func_177968_d().func_177974_f().func_177974_f(), true, boundingBox);
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177968_d().func_177968_d().func_177974_f(), pos.func_177981_b(height).func_177968_d().func_177968_d().func_177974_f(), true, boundingBox);
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177968_d().func_177968_d(), pos.func_177981_b(height).func_177968_d().func_177968_d(), true, boundingBox);
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177976_e().func_177968_d(), pos.func_177981_b(height).func_177976_e().func_177968_d(), true, boundingBox);
            this.checkLineAndOptionallySet(changedBlocks, world, pos.func_177976_e(), pos.func_177981_b(height).func_177976_e(), true, boundingBox);
        }
    }

    private void makeBranches(Set<BlockPos> changedBlocks, IWorld world, int height, BlockPos origin, List<FoliageCoordinates> coordinates, MutableBoundingBox boundingBox) {
        for (FoliageCoordinates coordinate : coordinates) {
            int branchBase = coordinate.getBranchBase();
            BlockPos baseCoord = new BlockPos(origin.func_177958_n(), branchBase, origin.func_177952_p());
            if (baseCoord.equals((Object)coordinate) || !this.trimBranches(height, branchBase - origin.func_177956_o())) continue;
            this.checkLineAndOptionallySet(changedBlocks, world, baseCoord, coordinate, true, boundingBox);
        }
    }

    @Override
    protected boolean place(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, IWorld world, Random rand, BlockPos pos, MutableBoundingBox boundingBox) {
        int relativeY;
        int clustersPerY;
        Random random = new Random(rand.nextLong());
        int height = this.checkLocation(changedLogs, world, pos, this.minHeight + random.nextInt(this.maxHeight), boundingBox);
        if (height == -1) {
            return false;
        }
        this.setDirtAt((IWorldGenerationReader)world, pos.func_177977_b(), pos);
        int trunkHeight = (int)((double)height * this.trunkHeightScale);
        if (trunkHeight >= height) {
            trunkHeight = height - 1;
        }
        if ((clustersPerY = (int)(1.382 + Math.pow(this.foliageDensity * (double)height / 13.0, 2.0))) < 1) {
            clustersPerY = 1;
        }
        int trunkTop = pos.func_177956_o() + trunkHeight;
        ArrayList foliageCoords = Lists.newArrayList();
        foliageCoords.add(new FoliageCoordinates(pos.func_177981_b(relativeY), trunkTop));
        for (relativeY = height - this.foliageHeight; relativeY >= 0; --relativeY) {
            float treeShape = this.treeShape(height, relativeY);
            if (treeShape < 0.0f) continue;
            for (int i = 0; i < clustersPerY; ++i) {
                BlockPos checkEnd;
                double z;
                double angle;
                double radius = 1.0 * (double)treeShape * ((double)random.nextFloat() + 0.328);
                double x = radius * Math.sin(angle = (double)(random.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos checkStart = pos.func_177963_a(x, (double)(relativeY - 1), z = radius * Math.cos(angle) + 0.5);
                if (this.checkLineAndOptionallySet(changedLogs, world, checkStart, checkEnd = checkStart.func_177981_b(5), false, boundingBox) != -1) continue;
                int dx = pos.func_177958_n() - checkStart.func_177958_n();
                int dz = pos.func_177952_p() - checkStart.func_177952_p();
                double branchHeight = (double)checkStart.func_177956_o() - Math.sqrt(dx * dx + dz * dz) * this.branchSlope;
                int branchTop = branchHeight > (double)trunkTop ? trunkTop : (int)branchHeight;
                BlockPos checkBranchBase = new BlockPos(pos.func_177958_n(), branchTop, pos.func_177952_p());
                if (this.checkLineAndOptionallySet(changedLogs, world, checkBranchBase, checkStart, false, boundingBox) != -1) continue;
                foliageCoords.add(new FoliageCoordinates(checkStart, checkBranchBase.func_177956_o()));
            }
        }
        this.makeFoliage(world, height, pos, foliageCoords, boundingBox, changedLeaves);
        this.makeTrunk(changedLogs, world, pos, trunkHeight, boundingBox);
        this.makeBranches(changedLogs, world, height, pos, foliageCoords, boundingBox);
        return true;
    }

    private int checkLocation(Set<BlockPos> changedBlocks, IWorld world, BlockPos pos, int height, MutableBoundingBox boundingBox) {
        if (!this.placeOn.matches(world, pos.func_177977_b())) {
            return -1;
        }
        int step = this.checkLineAndOptionallySet(changedBlocks, world, pos, pos.func_177981_b(height - 1), false, boundingBox);
        if (step == -1) {
            return height;
        }
        return step < 6 ? -1 : step;
    }

    static class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public FoliageCoordinates(BlockPos pos, int branchBase) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.branchBase = branchBase;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, BigTreeFeature> {
        private int trunkWidth;
        private int foliageHeight;
        private double foliageDensity;

        public Builder trunkWidth(int a) {
            this.trunkWidth = a;
            return this;
        }

        public Builder foliageHeight(int a) {
            this.foliageHeight = a;
            return this;
        }

        public Builder foliageDensity(int a) {
            this.foliageDensity = a;
            return this;
        }

        public Builder() {
            this.minHeight = 5;
            this.maxHeight = 12;
            this.trunkWidth = 1;
            this.foliageHeight = 5;
            this.foliageDensity = 1.0;
        }

        @Override
        public BigTreeFeature create() {
            return new BigTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.trunkWidth, this.foliageHeight, this.foliageDensity);
        }
    }
}

