/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import owmii.lib.block.AbstractBlock;
import owmii.lib.compat.top.ITOPInfoProvider;
import owmii.lib.inventory.Inventory;
import owmii.lib.util.IVariant;
import owmii.lib.util.math.V3d;
import owmii.powah.api.wrench.IWrench;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRecipe;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.config.Configs;
import owmii.powah.item.WrenchItem;

public class EnergizingOrbBlock
extends AbstractBlock<IVariant.Single>
implements IWaterLoggable,
IWrenchable,
ITOPInfoProvider {
    private static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)EnergizingOrbBlock.func_208617_a((double)3.5, (double)5.0, (double)3.5, (double)12.5, (double)14.23, (double)12.5), (VoxelShape)EnergizingOrbBlock.func_208617_a((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)1.0, (double)13.5), (IBooleanFunction)IBooleanFunction.field_223244_o_);

    public EnergizingOrbBlock(Block.Properties properties) {
        super(properties);
        this.setDefaultState();
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnergizingOrbTile();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack held = player.func_184586_b(hand);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof EnergizingOrbTile) {
            EnergizingOrbTile orb = (EnergizingOrbTile)tileentity;
            Inventory inv = orb.getInventory();
            ItemStack output = inv.getStackInSlot(0);
            ItemStack off = player.func_184592_cb();
            if (!(off.func_77973_b() instanceof IWrench) || !((IWrench)off.func_77973_b()).getWrenchMode(off).link()) {
                if (held.func_190926_b() || !output.func_190926_b()) {
                    if (!world.field_72995_K) {
                        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)inv.removeNext());
                    }
                    return ActionResultType.SUCCESS;
                }
                if (!world.field_72995_K) {
                    ItemStack copy = held.func_77946_l();
                    copy.func_190920_e(1);
                    if (!inv.addNext(copy).func_190926_b() && !player.func_184812_l_()) {
                        held.func_190918_g(1);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, result);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.search(worldIn, pos);
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof EnergizingOrbTile) {
            EnergizingOrbTile orb = (EnergizingOrbTile)tileentity;
            return orb.getInventory().getNonEmptyStacks().size();
        }
        return super.func_180641_l(state, world, pos);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        int range = (Integer)Configs.ENERGIZING.range.get();
        List<BlockPos> list = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range)).map(BlockPos::func_185334_h).filter(pos1 -> !pos.equals(pos1)).collect(Collectors.toList());
        list.forEach(pos1 -> {
            TileEntity tileEntity1 = worldIn.func_175625_s(pos1);
            if (tileEntity1 instanceof EnergizingRodTile && pos.equals((Object)((EnergizingRodTile)tileEntity1).getOrbPos())) {
                ((EnergizingRodTile)tileEntity1).setOrbPos(BlockPos.field_177992_a);
            }
        });
        list.forEach(pos1 -> {
            BlockState state1 = worldIn.func_180495_p(pos1);
            if (state1.func_177230_c() instanceof EnergizingOrbBlock) {
                ((EnergizingOrbBlock)state1.func_177230_c()).search(worldIn, (BlockPos)pos1);
            }
        });
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void search(World worldIn, BlockPos pos) {
        int range = (Integer)Configs.ENERGIZING.range.get();
        List<BlockPos> list = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range)).map(BlockPos::func_185334_h).filter(pos1 -> !pos.equals(pos1)).collect(Collectors.toList());
        list.forEach(pos1 -> {
            TileEntity tileEntity1 = worldIn.func_175625_s(pos1);
            if (tileEntity1 instanceof EnergizingRodTile && !((EnergizingRodTile)tileEntity1).hasOrb()) {
                ((EnergizingRodTile)tileEntity1).setOrbPos(pos);
            }
        });
    }

    @Override
    public boolean onWrench(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, WrenchMode mode, Vec3d hit) {
        ItemStack stack;
        if (mode.link() && (stack = player.func_184586_b(hand)).func_77973_b() instanceof WrenchItem) {
            WrenchItem wrench = (WrenchItem)stack.func_77973_b();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof EnergizingOrbTile) {
                EnergizingOrbTile orb = (EnergizingOrbTile)tileEntity;
                CompoundNBT nbt = wrench.getWrenchNBT(stack);
                if (nbt.func_150297_b("RodPos", 10)) {
                    BlockPos rodPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("RodPos"));
                    TileEntity tileEntity1 = world.func_175625_s(rodPos);
                    if (tileEntity1 instanceof EnergizingRodTile) {
                        EnergizingRodTile rod = (EnergizingRodTile)tileEntity1;
                        V3d v3d = V3d.from((Vec3i)rodPos);
                        if ((int)v3d.distance((Vec3i)pos) <= (Integer)Configs.ENERGIZING.range.get()) {
                            rod.setOrbPos(pos);
                            player.func_146105_b(new TranslationTextComponent("chat.powah.wrench.link.done", new Object[0]).func_211708_a(TextFormatting.GOLD), true);
                        } else {
                            player.func_146105_b(new TranslationTextComponent("chat.powah.wrench.link.fail", new Object[0]).func_211708_a(TextFormatting.RED), true);
                        }
                    }
                    nbt.func_82580_o("RodPos");
                } else {
                    nbt.func_218657_a("OrbPos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
                    player.func_146105_b(new TranslationTextComponent("chat.powah.wrench.link.start", new Object[0]).func_211708_a(TextFormatting.YELLOW), true);
                }
                return true;
            }
        }
        return false;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, PlayerEntity player, World world, BlockPos pos, BlockState state, IProbeHitData hitData) {
        EnergizingOrbTile orb;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof EnergizingOrbTile && (orb = (EnergizingOrbTile)te).getRequiredEnergy() > 0L) {
            info.progress(orb.getEnergy(), orb.getRequiredEnergy());
            EnergizingRecipe recipe = orb.currRecipe();
            if (recipe != null) {
                info.item(recipe.func_77571_b());
            }
        }
    }
}

