/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.energy.IEnergyStorage;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.energy.Energy;
import owmii.lib.item.ItemBase;
import owmii.lib.util.IVariant;
import owmii.lib.util.Text;

public abstract class EnergyItem<E extends IVariant>
extends ItemBase {
    private final E variant;

    public EnergyItem(Item.Properties properties, E variant) {
        super(properties);
        this.variant = variant;
    }

    public EnergyItem(Item.Properties properties) {
        this(properties, IVariant.getEmpty());
    }

    public abstract IEnergyConfig<E> getEnergyConfig();

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Energy.ifPresent(stack, (NonNullConsumer<? super IEnergyStorage>)((NonNullConsumer)storage -> {
            if (storage instanceof Energy.Item) {
                Energy.Item energy = (Energy.Item)storage;
                this.addEnergyInfo(energy, tooltip);
                this.addEnergyTransferInfo(energy, tooltip);
                tooltip.add((ITextComponent)new StringTextComponent(""));
            }
        }));
    }

    public void addEnergyInfo(Energy.Item storage, List<ITextComponent> tooltip) {
        if (storage.getCapacity() > 0L) {
            tooltip.add(new TranslationTextComponent("info.lollipop.stored.energy.fe", new Object[]{TextFormatting.DARK_GRAY + Text.addCommas(storage.getStored()), Text.numFormat(storage.getCapacity())}).func_211708_a(TextFormatting.GRAY));
        }
    }

    public void addEnergyTransferInfo(Energy.Item storage, List<ITextComponent> tooltip) {
        long re;
        long ext = storage.getMaxExtract();
        if (ext + (re = storage.getMaxReceive()) > 0L) {
            if (ext == re) {
                tooltip.add(new TranslationTextComponent("info.lollipop.max.transfer.fe", new Object[]{TextFormatting.DARK_GRAY + Text.numFormat(ext)}).func_211708_a(TextFormatting.GRAY));
            } else {
                if (ext > 0L) {
                    tooltip.add(new TranslationTextComponent("info.lollipop.max.extract.fe", new Object[]{TextFormatting.DARK_GRAY + Text.numFormat(ext)}).func_211708_a(TextFormatting.GRAY));
                }
                if (re > 0L) {
                    tooltip.add(new TranslationTextComponent("info.lollipop.max.receive.fe", new Object[]{TextFormatting.DARK_GRAY + Text.numFormat(re)}).func_211708_a(TextFormatting.GRAY));
                }
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        IEnergyConfig<E> config = this.getEnergyConfig();
        return new Energy.Item.Provider(stack, config.getCapacity(this.getVariant()), config.getTransfer(this.getVariant()), config.getTransfer(this.getVariant()));
    }

    public E getVariant() {
        return this.variant;
    }
}

