/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.buzzierbees.common.blocks;

import com.bagel.buzzierbees.core.registry.BBBlocks;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class HangingFlowerPotBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    private final Supplier<Block> flower;

    public HangingFlowerPotBlock(Supplier<Block> flower, Block.Properties properties) {
        super(properties);
        this.flower = flower;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        ResourceLocation pot = new ResourceLocation("buzzierbees:hanging_potted_" + itemstack.func_77973_b().getRegistryName().func_110623_a());
        if (ForgeRegistries.BLOCKS.containsKey(pot) && this.getBlock() == BBBlocks.HANGING_FLOWER_POT.get()) {
            Block potBlock = (Block)ForgeRegistries.BLOCKS.getValue(pot);
            worldIn.func_180501_a(pos, potBlock.func_176223_P(), 3);
            player.func_195066_a(Stats.field_188088_V);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (player.func_184586_b(handIn).func_77973_b() == Blocks.field_150350_a.func_199767_j()) {
            player.func_184611_a(handIn, new ItemStack((IItemProvider)this.flower.get().func_199767_j()));
            worldIn.func_175656_a(pos, ((Block)BBBlocks.HANGING_FLOWER_POT.get()).func_176223_P());
        }
        return ActionResultType.CONSUME;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)blockpos, (Direction)Direction.DOWN);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return this.flower == Blocks.field_150350_a ? new ItemStack((IItemProvider)Blocks.field_150457_bL) : new ItemStack((IItemProvider)this.flower.get().func_199767_j());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.UP && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

