/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.manasteel;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.model.armor.ModelArmorManasteel;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemManasteelArmor
extends ArmorItem
implements IManaUsingItem,
IPhantomInkable {
    private static final int MANA_PER_DAMAGE = 70;
    private static final String TAG_PHANTOM_INK = "phantomInk";
    private final LazyValue<BipedModel> model;
    public final EquipmentSlotType type;
    private static final LazyValue<ItemStack[]> armorSet = new LazyValue(() -> new ItemStack[]{new ItemStack((IItemProvider)ModItems.manasteelHelm), new ItemStack((IItemProvider)ModItems.manasteelChest), new ItemStack((IItemProvider)ModItems.manasteelLegs), new ItemStack((IItemProvider)ModItems.manasteelBoots)});

    public ItemManasteelArmor(EquipmentSlotType type, Item.Properties props) {
        this(type, BotaniaAPI.instance().getManasteelArmorMaterial(), props);
    }

    public ItemManasteelArmor(EquipmentSlotType type, IArmorMaterial mat, Item.Properties props) {
        super(mat, type, props);
        this.type = type;
        this.model = (LazyValue)DistExecutor.runForDist(() -> () -> new LazyValue(() -> this.provideArmorModelForSlot(type)), () -> () -> null);
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int slot, boolean selected) {
        if (player instanceof PlayerEntity) {
            this.onArmorTick(stack, world, (PlayerEntity)player);
        }
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!world.field_72995_K && stack.func_77952_i() > 0 && ManaItemHandler.instance().requestManaExact(stack, player, 140, true)) {
            stack.func_196085_b(stack.func_77952_i() - 1);
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return ToolCommons.damageItemIfPossible(stack, amount, entity, 70);
    }

    @Nonnull
    public final String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return this.hasPhantomInk(stack) ? "botania:textures/model/armor_invisible.png" : this.getArmorTextureAfterInk(stack, slot);
    }

    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlotType slot) {
        return (Boolean)ConfigHandler.CLIENT.enableArmorModels.get() != false ? "botania:textures/model/armor_manasteel.png" : (slot == EquipmentSlotType.LEGS ? "botania:textures/model/manasteel_1.png" : "botania:textures/model/manasteel_0.png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel original) {
        if (((Boolean)ConfigHandler.CLIENT.enableArmorModels.get()).booleanValue()) {
            return (BipedModel)this.model.func_179281_c();
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, original);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel provideArmorModelForSlot(EquipmentSlotType slot) {
        return new ModelArmorManasteel(slot);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        if (Screen.hasShiftDown()) {
            this.addInformationAfterShift(stack, world, list, flags);
        } else {
            list.add((ITextComponent)new TranslationTextComponent("botaniamisc.shiftinfo", new Object[0]));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformationAfterShift(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        ItemStack[] stacks;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        list.add(this.getArmorSetTitle((PlayerEntity)player));
        this.addArmorSetDescription(stack, list);
        for (ItemStack armor : stacks = this.getArmorSetStacks()) {
            ITextComponent cmp = new StringTextComponent(" - ").func_150257_a(armor.func_200301_q());
            EquipmentSlotType slot = ((ArmorItem)armor.func_77973_b()).func_185083_B_();
            cmp.func_211708_a(this.hasArmorSetItem((PlayerEntity)player, slot) ? TextFormatting.GREEN : TextFormatting.GRAY);
            list.add(cmp);
        }
        if (this.hasPhantomInk(stack)) {
            list.add(new TranslationTextComponent("botaniamisc.hasPhantomInk", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    public ItemStack[] getArmorSetStacks() {
        return (ItemStack[])armorSet.func_179281_c();
    }

    public boolean hasArmorSet(PlayerEntity player) {
        return this.hasArmorSetItem(player, EquipmentSlotType.HEAD) && this.hasArmorSetItem(player, EquipmentSlotType.CHEST) && this.hasArmorSetItem(player, EquipmentSlotType.LEGS) && this.hasArmorSetItem(player, EquipmentSlotType.FEET);
    }

    public boolean hasArmorSetItem(PlayerEntity player, EquipmentSlotType slot) {
        if (player == null || player.field_71071_by == null || player.field_71071_by.field_70460_b == null) {
            return false;
        }
        ItemStack stack = player.func_184582_a(slot);
        if (stack.func_190926_b()) {
            return false;
        }
        switch (slot) {
            case HEAD: {
                return stack.func_77973_b() == ModItems.manasteelHelm || stack.func_77973_b() == ModItems.manasteelHelmRevealing;
            }
            case CHEST: {
                return stack.func_77973_b() == ModItems.manasteelChest;
            }
            case LEGS: {
                return stack.func_77973_b() == ModItems.manasteelLegs;
            }
            case FEET: {
                return stack.func_77973_b() == ModItems.manasteelBoots;
            }
        }
        return false;
    }

    private int getSetPiecesEquipped(PlayerEntity player) {
        int pieces = 0;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR || !this.hasArmorSetItem(player, slot)) continue;
            ++pieces;
        }
        return pieces;
    }

    public ITextComponent getArmorSetName() {
        return new TranslationTextComponent("botania.armorset.manasteel.name", new Object[0]);
    }

    private ITextComponent getArmorSetTitle(PlayerEntity player) {
        ITextComponent end = this.getArmorSetName().func_150258_a(" (" + this.getSetPiecesEquipped(player) + "/" + this.getArmorSetStacks().length + ")").func_211708_a(TextFormatting.GRAY);
        return new TranslationTextComponent("botaniamisc.armorset", new Object[0]).func_150258_a(" ").func_150257_a(end);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<ITextComponent> list) {
        list.add(new TranslationTextComponent("botania.armorset.manasteel.desc", new Object[0]).func_211708_a(TextFormatting.GRAY));
    }

    @Override
    public boolean hasPhantomInk(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_PHANTOM_INK, false);
    }

    @Override
    public void setPhantomInk(ItemStack stack, boolean ink) {
        ItemNBTHelper.setBoolean(stack, TAG_PHANTOM_INK, ink);
    }
}

