/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.intake;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.layout.FlowLayout;
import vswe.stevesfactory.library.gui.screen.DisplayListCaches;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.Checkbox;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.NumberField;
import vswe.stevesfactory.library.gui.widget.TextButton;
import vswe.stevesfactory.library.gui.widget.TextField;
import vswe.stevesfactory.library.gui.window.AbstractWindow;
import vswe.stevesfactory.network.NetworkHandler;
import vswe.stevesfactory.network.PacketSyncIntakeData;
import vswe.stevesfactory.ui.intake.ItemIntakeContainer;

public class ItemIntakeGUI
extends WidgetScreen<ItemIntakeContainer> {
    public ItemIntakeGUI(ItemIntakeContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    protected void init() {
        super.init();
        this.initializePrimaryWindow(new PrimaryWindow());
    }

    @Override
    public void removed() {
        NetworkHandler.sendToServer(new PacketSyncIntakeData(Objects.requireNonNull(((ItemIntakeContainer)this.field_147002_h).intake.func_145831_w()).func_201675_m().func_186058_p(), ((ItemIntakeContainer)this.field_147002_h).intake.func_174877_v(), ((ItemIntakeContainer)this.field_147002_h).intake.getRadius(), ((ItemIntakeContainer)this.field_147002_h).intake.isRendering(), ((ItemIntakeContainer)this.field_147002_h).intake.getMode()));
        super.removed();
    }

    @Override
    public PrimaryWindow getPrimaryWindow() {
        return (PrimaryWindow)super.getPrimaryWindow();
    }

    public class PrimaryWindow
    extends AbstractWindow {
        public static final int WIDTH = 180;
        public static final int HEIGHT = 120;
        private int backgroundDL;
        private NumberField<Integer> radius;
        private TextButton mode;
        private Checkbox rendering;
        private List<IWidget> children = new ArrayList<IWidget>();

        public PrimaryWindow() {
            this.setContents(180, 120);
            this.updatePosAndDL();
            this.radius = NumberField.integerFieldRanged(33, 12, 1, 0, ((ItemIntakeContainer)((ItemIntakeGUI)ItemIntakeGUI.this).field_147002_h).intake.getMaximumRadius());
            this.radius.setWindow(this);
            this.radius.setValue(((ItemIntakeContainer)((ItemIntakeGUI)ItemIntakeGUI.this).field_147002_h).intake.getRadius());
            this.radius.setBackgroundStyle(TextField.BackgroundStyle.RED_OUTLINE);
            this.radius.onValueUpdated = ((ItemIntakeContainer)((ItemIntakeGUI)ItemIntakeGUI.this).field_147002_h).intake::setRadius;
            this.mode = TextButton.of(((ItemIntakeContainer)((ItemIntakeGUI)ItemIntakeGUI.this).field_147002_h).intake.getMode().statusTranslationKey);
            this.mode.setWindow(this);
            this.mode.onClick = b -> {
                ((ItemIntakeContainer)((ItemIntakeGUI)ItemIntakeGUI.this).field_147002_h).intake.cycleMode();
                this.mode.setText(I18n.func_135052_a((String)((ItemIntakeContainer)((ItemIntakeGUI)ItemIntakeGUI.this).field_147002_h).intake.getMode().statusTranslationKey, (Object[])new Object[0]));
            };
            this.rendering = new Checkbox(0, 0, 8, 8);
            this.rendering.setWindow(this);
            this.rendering.setLabel(I18n.func_135052_a((String)"gui.sfm.ItemIntake.RenderWorkingArea", (Object[])new Object[0]));
            this.rendering.setChecked(((ItemIntakeContainer)((ItemIntakeGUI)ItemIntakeGUI.this).field_147002_h).intake.isRendering());
            this.rendering.onStateChange = ((ItemIntakeContainer)((ItemIntakeGUI)ItemIntakeGUI.this).field_147002_h).intake::setRendering;
            TextButton btnSaveData = TextButton.of("gui.sfm.ItemIntake.SaveData", b -> ItemIntakeGUI.this.onClose());
            btnSaveData.setWindow(this);
            btnSaveData.setWidth(this.getContentWidth());
            this.children.add(this.radius);
            this.children.add(this.mode);
            this.children.add(this.rendering);
            this.children.add(btnSaveData);
            FlowLayout.vertical(this.children, 0, 0, 2);
            btnSaveData.alignBottom(this.getContentHeight());
        }

        private void updatePosAndDL() {
            this.centralize();
            this.backgroundDL = DisplayListCaches.createVanillaStyleBackground(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }

        @Override
        public int getBorderSize() {
            return 4;
        }

        @Override
        public List<? extends IWidget> getChildren() {
            return this.children;
        }

        @Override
        public void render(int mouseX, int mouseY, float particleTicks) {
            RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
            GL11.glCallList((int)this.backgroundDL);
            this.renderChildren(mouseX, mouseY, particleTicks);
            RenderingHelper.drawTextCenteredVertically(I18n.func_135052_a((String)"gui.sfm.ItemIntake.Radius", (Object[])new Object[0]), this.radius.getAbsoluteXRight() + 2, this.radius.getAbsoluteY(), this.radius.getAbsoluteYBottom(), -12566464);
            RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
        }
    }
}

