/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget;

import java.util.function.IntConsumer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.IButton;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;

public class TextButton
extends AbstractWidget
implements IButton,
LeafWidgetMixin {
    public static final IntConsumer DUMMY = i -> {};
    public IntConsumer onClick = DUMMY;
    protected String text;
    private boolean hovered = false;
    private boolean clicked = false;

    public static TextButton of(String key) {
        return TextButton.ofText(I18n.func_135052_a((String)key, (Object[])new Object[0]));
    }

    public static TextButton of(String key, IntConsumer action) {
        return TextButton.ofText(I18n.func_135052_a((String)key, (Object[])new Object[0]), action);
    }

    public static TextButton of(String key, Object ... args) {
        return TextButton.ofText(I18n.func_135052_a((String)key, (Object[])args));
    }

    public static TextButton of(String key, IntConsumer action, Object ... args) {
        return TextButton.ofText(I18n.func_135052_a((String)key, (Object[])args), action);
    }

    public static TextButton ofText(String text) {
        TextButton button = new TextButton();
        button.setText(text);
        button.expandToTextWidth();
        return button;
    }

    public static TextButton ofText(String text, IntConsumer action) {
        TextButton button = new TextButton();
        button.setText(text);
        button.expandToTextWidth();
        button.onClick = action;
        return button;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        RenderingHelper.usePlainColorGLStates();
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int x1 = this.getAbsoluteX();
        int y1 = this.getAbsoluteY();
        int x2 = this.getAbsoluteXRight();
        int y2 = this.getAbsoluteYBottom();
        boolean hovered = this.isInside(mouseX, mouseY);
        RenderingHelper.rectVertices(x1, y1, x2, y2, hovered ? this.getHoveredBorderColor() : this.getNormalBorderColor());
        RenderingHelper.rectVertices(x1 + 1, y1 + 1, x2 - 1, y2 - 1, hovered ? this.getHoveredBackgroundColor() : this.getNormalBackgroundColor());
        Tessellator.func_178181_a().func_78381_a();
        this.renderText();
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    protected void renderText() {
        RenderingHelper.drawTextCentered(this.getText(), this.getAbsoluteY(), this.getAbsoluteYBottom(), this.getAbsoluteX(), this.getAbsoluteXRight(), this.getTextColor());
    }

    public int getTextColor() {
        return 0xFFFFFF;
    }

    public int getNormalBorderColor() {
        return -7566196;
    }

    public int getHoveredBorderColor() {
        return -7566196;
    }

    public int getNormalBackgroundColor() {
        return -9211021;
    }

    public int getHoveredBackgroundColor() {
        return -3552823;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.clicked = true;
        this.onClick.accept(button);
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.clicked = false;
        return true;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        this.hovered = this.isInside(mouseX, mouseY);
    }

    public void expandToTextWidth() {
        this.setWidth(Math.max(this.getWidth(), 4 + RenderingHelper.fontRenderer().func_78256_a(this.text) + 4));
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.setDimensions(3 + RenderingHelper.fontRenderer().func_78256_a(text) + 3, 3 + RenderingHelper.fontHeight() + 2);
    }

    public void setTextRaw(String text) {
        this.text = text;
    }

    public boolean hasClickAction() {
        return this.onClick != DUMMY;
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public boolean isClicked() {
        return this.clicked;
    }
}

