/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget;

import java.awt.Dimension;
import java.awt.Point;
import javax.annotation.Nullable;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.debug.Inspections;
import vswe.stevesfactory.library.gui.layout.ILayoutDataProvider;
import vswe.stevesfactory.library.gui.layout.properties.BoxSizing;
import vswe.stevesfactory.library.gui.layout.properties.HorizontalAlignment;
import vswe.stevesfactory.library.gui.layout.properties.Side;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.window.IWindow;

public abstract class AbstractWidget
implements IWidget,
Inspections.IInspectionInfoProvider,
ILayoutDataProvider {
    private Point location;
    private Dimension dimensions;
    private boolean enabled = true;
    private IWindow window;
    private IWidget parent;
    private int absX;
    private int absY;

    public AbstractWidget(IWindow window) {
        this(0, 0, window.getContentDimensions().width, window.getContentDimensions().height);
        this.window = window;
    }

    public AbstractWidget() {
        this(0, 0, 0, 0);
    }

    public AbstractWidget(int x, int y, int width, int height) {
        this(new Point(x, y), new Dimension(width, height));
    }

    public AbstractWidget(Point location, Dimension dimensions) {
        this.location = location;
        this.dimensions = dimensions;
    }

    @Override
    public void setParentWidget(IWidget newParent) {
        this.parent = newParent;
        this.window = newParent.getWindow();
        this.onParentPositionChanged();
    }

    public void setWindow(IWindow window) {
        this.window = window;
        this.onParentPositionChanged();
    }

    @Override
    public void onParentPositionChanged() {
        this.updateAbsolutePosition();
    }

    @Override
    public void onRelativePositionChanged() {
        this.updateAbsolutePosition();
    }

    private void updateAbsolutePosition() {
        this.absX = this.getParentAbsXSafe() + this.getX();
        this.absY = this.getParentAbsYSafe() + this.getY();
    }

    private int getParentAbsXSafe() {
        if (this.parent != null) {
            return this.parent.getAbsoluteX();
        }
        if (this.window != null) {
            return this.window.getContentX();
        }
        return 0;
    }

    private int getParentAbsYSafe() {
        if (this.parent != null) {
            return this.parent.getAbsoluteY();
        }
        if (this.window != null) {
            return this.window.getContentY();
        }
        return 0;
    }

    public int getParentHeight() {
        if (this.parent != null) {
            return this.parent.getHeight();
        }
        if (this.window != null) {
            return this.window.getContentHeight();
        }
        return 0;
    }

    public int getParentWidth() {
        if (this.parent != null) {
            return this.parent.getWidth();
        }
        if (this.window != null) {
            return this.window.getContentWidth();
        }
        return 0;
    }

    public void fillParentContainer() {
        this.setLocation(0, 0);
        this.setDimensions(this.parent.getDimensions());
    }

    public void expandHorizontally() {
        this.setWidth(Math.max(this.getWidth(), this.getParentWidth()));
    }

    public void expandVertically() {
        this.setHeight(Math.max(this.getHeight(), this.getParentHeight()));
    }

    @Override
    public boolean isFocused() {
        return this.getWindow().getFocusedWidget() == this;
    }

    @Override
    public Point getPosition() {
        return this.location;
    }

    @Override
    public int getAbsoluteX() {
        return this.absX;
    }

    @Override
    public int getAbsoluteY() {
        return this.absY;
    }

    public int getAbsoluteXRight() {
        return this.getAbsoluteX() + this.getWidth();
    }

    public int getAbsoluteYBottom() {
        return this.getAbsoluteY() + this.getHeight();
    }

    public void alignTo(IWidget other, Side side, HorizontalAlignment alignment) {
        int otherLeft = other.getX();
        int otherTop = other.getY();
        int otherRight = otherLeft + other.getWidth();
        int otherBottom = otherTop + other.getHeight();
        this.alignTo(otherLeft, otherTop, otherRight, otherBottom, side, alignment);
    }

    public void alignTo(int otherLeft, int otherTop, int otherRight, int otherBottom, Side side, HorizontalAlignment alignment) {
        switch (side) {
            case TOP: {
                this.alignBottom(otherTop);
                this.alignHorizontally(alignment, otherLeft, otherRight);
                break;
            }
            case BOTTOM: {
                this.alignTop(otherBottom);
                this.alignHorizontally(alignment, otherLeft, otherRight);
                break;
            }
            case LEFT: {
                this.alignRight(otherLeft);
                this.alignVertically(alignment, otherTop, otherBottom);
                break;
            }
            case RIGHT: {
                this.alignLeft(otherRight);
                this.alignVertically(alignment, otherTop, otherBottom);
            }
        }
    }

    private void alignHorizontally(HorizontalAlignment alignment, int left, int right) {
        switch (alignment) {
            case LEFT: {
                this.alignLeft(left);
                break;
            }
            case CENTER: {
                this.alignCenterX(left, right);
                break;
            }
            case RIGHT: {
                this.alignRight(right);
            }
        }
    }

    private void alignVertically(HorizontalAlignment alignment, int top, int bottom) {
        switch (alignment) {
            case LEFT: {
                this.alignTop(top);
                break;
            }
            case CENTER: {
                this.alignCenterY(top, bottom);
                break;
            }
            case RIGHT: {
                this.alignBottom(bottom);
            }
        }
    }

    public void alignLeft(int left) {
        this.setX(left);
    }

    public void alignCenterX(int left, int right) {
        this.setX(left + (right - left) / 2 - this.getWidth() / 2);
    }

    public void alignRight(int right) {
        this.setX(right - this.getWidth());
    }

    public void alignTop(int top) {
        this.setY(top);
    }

    public void alignCenterY(int top, int bottom) {
        this.setY(top + (bottom - top) / 2 - this.getHeight() / 2);
    }

    public void alignBottom(int bottom) {
        this.setY(bottom - this.getHeight());
    }

    @Override
    public Dimension getDimensions() {
        return this.dimensions;
    }

    @Override
    @Nullable
    public IWidget getParentWidget() {
        return this.parent;
    }

    @Override
    public IWindow getWindow() {
        return this.window;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isInside(double x, double y) {
        return (double)this.getAbsoluteX() <= x && (double)this.getAbsoluteXRight() > x && (double)this.getAbsoluteY() <= y && (double)this.getAbsoluteYBottom() > y;
    }

    @Override
    public BoxSizing getBoxSizing() {
        return BoxSizing.BORDER_BOX;
    }

    @Override
    public int getX() {
        return this.getPosition().x;
    }

    public int getXRight() {
        return this.getX() + this.getWidth();
    }

    @Override
    public int getY() {
        return this.getPosition().y;
    }

    public int getYBottom() {
        return this.getY() + this.getHeight();
    }

    @Override
    public int getWidth() {
        return this.getDimensions().width;
    }

    @Override
    public int getHeight() {
        return this.getDimensions().height;
    }

    @Override
    public void provideInformation(ITextReceiver receiver) {
        receiver.line(this.toString());
        receiver.line("X=" + this.getX());
        receiver.line("Y=" + this.getY());
        receiver.line("AbsX=" + this.getAbsoluteX());
        receiver.line("AbsY=" + this.getAbsoluteY());
        receiver.line("Width=" + this.getWidth());
        receiver.line("Height=" + this.getHeight());
        receiver.line("Enabled=" + this.isEnabled());
    }
}

