/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.colossalchests.Advancements;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.IBlockChestMaterial;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.colossalchests.tileentity.TileInterface;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class ItemUpgradeTool
extends Item {
    private final boolean upgrade;

    public ItemUpgradeTool(Item.Properties properties, boolean upgrade) {
        super(properties);
        this.upgrade = upgrade;
    }

    public ActionResultType onItemUseFirst(ItemStack itemStack, ItemUseContext context) {
        BlockState blockState = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (blockState.func_177230_c() instanceof IBlockChestMaterial && ((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (IProperty)ColossalChest.ENABLED, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockPos tileLocation = ColossalChest.getCoreLocation(((IBlockChestMaterial)blockState.func_177230_c()).getMaterial(), (IWorldReader)context.func_195991_k(), context.func_195995_a());
            TileColossalChest tile = TileHelpers.getSafeTile((IBlockReader)context.func_195991_k(), (BlockPos)tileLocation, TileColossalChest.class).orElse(null);
            ChestMaterial newType = this.transformType(itemStack, tile.getMaterial());
            if (newType == null) {
                if (context.func_195991_k().func_201670_d()) {
                    return ActionResultType.PASS;
                }
                ColossalChest.addPlayerChatError(context.func_195999_j(), (ITextComponent)new TranslationTextComponent("multiblock.colossalchests.error.upgradeLimit", new Object[0]));
                return ActionResultType.FAIL;
            }
            ITextComponent firstError = null;
            do {
                ITextComponent error;
                if ((error = this.attemptTransform(context.func_195991_k(), context.func_195995_a(), context.func_195999_j(), tile, newType, tile.getMaterial(), context.func_221531_n())) != null) {
                    if (firstError != null) continue;
                    firstError = error;
                    continue;
                }
                return context.func_195991_k().func_201670_d() ? ActionResultType.PASS : ActionResultType.SUCCESS;
            } while ((newType = this.transformType(itemStack, newType)) != null);
            ColossalChest.addPlayerChatError(context.func_195999_j(), firstError);
            return context.func_195991_k().func_201670_d() ? ActionResultType.PASS : ActionResultType.FAIL;
        }
        return context.func_195991_k().func_201670_d() ? ActionResultType.PASS : ActionResultType.SUCCESS;
    }

    protected ITextComponent attemptTransform(World world, BlockPos pos, PlayerEntity player, TileColossalChest tile, ChestMaterial newType, ChestMaterial currentType, Hand hand) {
        Vec3i size = tile.getSize();
        ChestMaterial validMaterial = null;
        Wrapper requiredCoresCount = new Wrapper((Object)0);
        Wrapper requiredInterfacesCount = new Wrapper((Object)0);
        Wrapper requiredWallsCount = new Wrapper((Object)0);
        for (ChestMaterial material : ChestMaterial.VALUES) {
            DetectionResult result = material.getChestDetector().detect((IWorldReader)world, pos, null, (location, blockState) -> {
                if (blockState.func_177230_c() instanceof ColossalChest) {
                    requiredCoresCount.set((Object)((Integer)requiredCoresCount.get() + 1));
                } else if (blockState.func_177230_c() instanceof Interface) {
                    requiredInterfacesCount.set((Object)((Integer)requiredCoresCount.get() + 1));
                } else if (blockState.func_177230_c() instanceof ChestWall) {
                    requiredWallsCount.set((Object)((Integer)requiredCoresCount.get() + 1));
                }
                return null;
            }, false);
            if (result.getError() != null) continue;
            validMaterial = material;
            break;
        }
        ItemStack requiredCores = new ItemStack((IItemProvider)newType.getBlockCore(), ((Integer)requiredCoresCount.get()).intValue());
        ItemStack requiredInterfaces = new ItemStack((IItemProvider)newType.getBlockInterface(), ((Integer)requiredInterfacesCount.get()).intValue());
        ItemStack requiredWalls = new ItemStack((IItemProvider)newType.getBlockWall(), ((Integer)requiredWallsCount.get()).intValue());
        if (validMaterial == null) {
            return new TranslationTextComponent("multiblock.colossalchests.error.unexpected", new Object[0]);
        }
        if (!(this.consumeItems(player, requiredCores, true) && this.consumeItems(player, requiredInterfaces, true) && this.consumeItems(player, requiredWalls, true))) {
            return new TranslationTextComponent("multiblock.colossalchests.error.upgrade", new Object[]{requiredCores.func_190916_E(), requiredInterfaces.func_190916_E(), requiredWalls.func_190916_E(), new TranslationTextComponent(newType.getUnlocalizedName(), new Object[0])});
        }
        this.consumeItems(player, requiredCores.func_77946_l(), false);
        this.consumeItems(player, requiredInterfaces.func_77946_l(), false);
        this.consumeItems(player, requiredWalls.func_77946_l(), false);
        if (!world.field_72995_K) {
            tile.setSize(Vec3i.field_177959_e);
            SimpleInventory oldInventory = tile.getLastValidInventory();
            Direction oldRotation = tile.getRotation();
            Vec3d oldRenderOffset = tile.getRenderOffset();
            List<Vec3i> oldInterfaceLocations = tile.getInterfaceLocations();
            Wrapper coreLocation = new Wrapper(null);
            ArrayList interfaceLocations = Lists.newArrayList();
            validMaterial.getChestDetector().detect((IWorldReader)world, pos, null, (location, blockState) -> {
                BlockState blockStateNew = null;
                if (blockState.func_177230_c() instanceof ColossalChest) {
                    coreLocation.set((Object)location);
                    blockStateNew = newType.getBlockCore().func_176223_P();
                } else if (blockState.func_177230_c() instanceof Interface) {
                    blockStateNew = newType.getBlockInterface().func_176223_P();
                    interfaceLocations.add(location);
                } else if (blockState.func_177230_c() instanceof ChestWall) {
                    blockStateNew = newType.getBlockWall().func_176223_P();
                }
                world.func_180501_a(location, (BlockState)blockStateNew.func_206870_a((IProperty)ColossalChest.ENABLED, blockState.func_177229_b((IProperty)ColossalChest.ENABLED)), 2);
                if (blockState.func_177230_c() instanceof ColossalChest || blockState.func_177230_c() instanceof Interface) {
                    tile.addInterface((Vec3i)location);
                }
                return null;
            }, false);
            TileColossalChest tileNew = (TileColossalChest)((Object)TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)((BlockPos)coreLocation.get()), TileColossalChest.class).orElseThrow(() -> new IllegalStateException("Could not find a colossal chest core location during upgrading.")));
            tileNew.setLastValidInventory(oldInventory);
            tileNew.setMaterial(newType);
            tileNew.setRotation(oldRotation);
            tileNew.setRenderOffset(oldRenderOffset);
            for (Vec3i oldInterfaceLocation : oldInterfaceLocations) {
                tileNew.addInterface(oldInterfaceLocation);
            }
            tileNew.setSize(size);
            for (BlockPos interfaceLocation : interfaceLocations) {
                TileInterface tileInterface = (TileInterface)((Object)TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)interfaceLocation, TileInterface.class).orElseThrow(() -> new IllegalStateException("Could not find a colossal chest interface location during upgrading.")));
                tileInterface.setCorePosition((Vec3i)coreLocation.get());
            }
            Advancements.CHEST_FORMED.trigger((ServerPlayerEntity)player, Pair.of((Object)((Object)newType), (Object)(size.func_177958_n() + 1)));
        }
        ItemStack returnedCores = new ItemStack((IItemProvider)currentType.getBlockCore(), requiredCores.func_190916_E());
        ItemStack returnedInterfaces = new ItemStack((IItemProvider)currentType.getBlockInterface(), requiredInterfaces.func_190916_E());
        ItemStack returnedWalls = new ItemStack((IItemProvider)currentType.getBlockWall(), requiredWalls.func_190916_E());
        InventoryHelpers.tryReAddToStack((PlayerEntity)player, (ItemStack)ItemStack.field_190927_a, (ItemStack)returnedCores, (Hand)hand);
        InventoryHelpers.tryReAddToStack((PlayerEntity)player, (ItemStack)ItemStack.field_190927_a, (ItemStack)returnedInterfaces, (Hand)hand);
        InventoryHelpers.tryReAddToStack((PlayerEntity)player, (ItemStack)ItemStack.field_190927_a, (ItemStack)returnedWalls, (Hand)hand);
        return null;
    }

    protected boolean consumeItems(PlayerEntity player, ItemStack consumeStack, boolean simulate) {
        if (player.func_184812_l_()) {
            return true;
        }
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        int validItems = 0;
        while (it.hasNext()) {
            ItemStack stack = it.next();
            if (stack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)consumeStack)) continue;
            int previousValidItems = validItems;
            validItems += stack.func_190916_E();
            validItems = Math.min(consumeStack.func_190916_E(), validItems);
            if (simulate) continue;
            stack.func_190918_g(validItems - previousValidItems);
            it.replace(stack.func_190916_E() == 0 ? ItemStack.field_190927_a : stack);
        }
        return validItems == consumeStack.func_190916_E();
    }

    protected ChestMaterial transformType(ItemStack itemStack, ChestMaterial type) {
        if (this.upgrade && type.ordinal() < ChestMaterial.VALUES.size() - 1) {
            return ChestMaterial.VALUES.get(type.ordinal() + 1);
        }
        if (!this.upgrade && type.ordinal() > 0) {
            return ChestMaterial.VALUES.get(type.ordinal() - 1);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemUpgradeTool)) {
            return false;
        }
        ItemUpgradeTool other = (ItemUpgradeTool)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.isUpgrade() == other.isUpgrade();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemUpgradeTool;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUpgrade() ? 79 : 97);
        return result;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public String toString() {
        return "ItemUpgradeTool(upgrade=" + this.isUpgrade() + ")";
    }
}

