/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.mekanism.MekanismHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"mekanism@[9.9.20,)"})
public class MekanismCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(Arrays.asList("bronze", "charcoal", "coal", "copper", "diamond", "emerald", "gold", "iron", "lapis", "osmium", "quartz", "refined_glowstone", "refined_obsidian", "steel", "tin"));
    private static final Set<String> TO_CRYSTAL_BLACKLIST = new TreeSet<String>(Arrays.asList("charcoal", "coal", "diamond", "emerald", "lapis", "quartz"));
    private static final Set<String> TO_ORE_BLACKLIST = new TreeSet<String>(Arrays.asList("coal", "copper", "diamond", "emerald", "gold", "iron", "lapis", "osmium", "quartz", "redstone", "tin"));
    private static final TreeMap<IMaterial, Object> ORE_BASES = new TreeMap();
    private Map<IMaterial, IDynamicSpecConfig> configs;

    @Override
    public String getName() {
        return "mekanism_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        MekanismHelper helper = MekanismHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            int inputCount;
            ResourceLocation dustLocation;
            MaterialType type = material.getType();
            if (!ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)type)) && !TO_DUST_BLACKLIST.contains(material.getName())) {
                ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation dustLocation2 = miscHelper.getTagLocation("dusts", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(dustLocation2)) {
                    helper.registerCrushingRecipe(new ResourceLocation("jaopca", "mekanism.material_to_dust." + material.getName()), materialLocation, 1, dustLocation2, 1);
                }
            }
            if ((ArrayUtils.contains((Object[])MaterialType.GEMS, (Object)((Object)type)) || ArrayUtils.contains((Object[])MaterialType.CRYSTALS, (Object)((Object)type))) && !TO_CRYSTAL_BLACKLIST.contains(material.getName())) {
                dustLocation = miscHelper.getTagLocation("dusts", material.getName());
                ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(dustLocation)) {
                    helper.registerEnrichingRecipe(new ResourceLocation("jaopca", "mekanism.dust_to_material." + material.getName()), dustLocation, 1, materialLocation, 1);
                }
            }
            if (!ArrayUtils.contains((Object[])MaterialType.ORE, (Object)((Object)type)) || TO_ORE_BLACKLIST.contains(material.getName())) continue;
            dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            if (!((JAOPCAApi)api).getItemTags().contains(dustLocation)) continue;
            IDynamicSpecConfig config = this.configs.get(material);
            String configOreBase = config.getDefinedString("mekanism.ore_base", "#forge:cobblestone", this::isTagOrItemValid, "The base to use in Mekanism's Combiner to recreate ores.");
            Object oreBase = this.getTagOrItem(configOreBase);
            switch (type) {
                default: {
                    inputCount = 8;
                    break;
                }
                case GEM: 
                case CRYSTAL: {
                    inputCount = 5;
                }
            }
            helper.registerCombiningRecipe(new ResourceLocation("jaopca", "mekanism.dust_to_ore." + material.getName()), dustLocation, inputCount, oreBase, 1, oreLocation, 1);
        }
    }

    public boolean isTagOrItemValid(String s) {
        if (StringUtils.startsWith((CharSequence)s, (CharSequence)"#")) {
            return ApiImpl.INSTANCE.getItemTags().contains(new ResourceLocation(s.substring(1)));
        }
        return ForgeRegistries.ITEMS.containsKey(new ResourceLocation(s));
    }

    public Object getTagOrItem(String s) {
        if (StringUtils.startsWith((CharSequence)s, (CharSequence)"#")) {
            return new ItemTags.Wrapper(new ResourceLocation(s.substring(1)));
        }
        return ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
    }
}

