/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui;

import com.bluepowermod.client.gui.widget.BaseWidget;
import com.bluepowermod.client.gui.widget.GuiAnimatedStat;
import com.bluepowermod.client.gui.widget.IGuiAnimatedStat;
import com.bluepowermod.client.gui.widget.IGuiWidget;
import com.bluepowermod.client.gui.widget.IWidgetListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;

public class GuiContainerBase<T extends Container>
extends ContainerScreen<T>
implements IWidgetListener {
    protected static final int COLOR_TEXT = 0x404040;
    protected final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
    protected IInventory inventory;
    protected final Container field_147002_h;
    protected final ITextComponent title;
    protected final ResourceLocation resLoc;
    protected IGuiAnimatedStat lastLeftStat;
    protected IGuiAnimatedStat lastRightStat;

    public GuiContainerBase(T container, PlayerInventory playerInventory, ITextComponent title, ResourceLocation resLoc) {
        super(container, playerInventory, title);
        this.field_147002_h = container;
        this.title = title;
        this.resLoc = resLoc;
    }

    protected boolean isInfoStatLeftSided() {
        return true;
    }

    protected GuiAnimatedStat addAnimatedStat(String title, ItemStack icon, int color, boolean leftSided) {
        GuiAnimatedStat stat = new GuiAnimatedStat((Screen)this, title, icon, this.field_147003_i + (leftSided ? 0 : this.field_146999_f), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : this.field_147009_r + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        this.addWidget(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        return stat;
    }

    protected GuiAnimatedStat addAnimatedStat(String title, String icon, int color, boolean leftSided) {
        GuiAnimatedStat stat = new GuiAnimatedStat((Screen)this, title, icon, this.field_147003_i + (leftSided ? 0 : this.field_146999_f), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : this.field_147009_r + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        this.addWidget(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        return stat;
    }

    protected void addWidget(IGuiWidget widget) {
        this.widgets.add(widget);
        widget.setListener(this);
    }

    public void setSize(int par2, int par3) {
        this.widgets.clear();
        this.lastRightStat = null;
        this.lastLeftStat = null;
        super.setSize(par2, par3);
    }

    public void drawHorizontalAlignedString(int xOffset, int yOffset, int w, String text, boolean useShadow) {
        int stringWidth = this.font.func_78256_a(text);
        int newX = xOffset;
        if (stringWidth < w) {
            newX = w / 2 - stringWidth / 2 + xOffset;
        }
        this.font.func_211126_b(text, (float)newX, (float)yOffset, 0x404040);
    }

    public void drawString(int xOffset, int yOffset, String text, boolean useShadow) {
        this.font.func_211126_b(text, (float)xOffset, (float)yOffset, 0x404040);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(I18n.func_135052_a((String)("block.bluepower." + this.title.func_150254_d()), (Object[])new Object[0]), (float)(this.field_146999_f / 2 - this.font.func_78256_a(I18n.func_135052_a((String)("block.bluepower." + this.title.func_150254_d()), (Object[])new Object[0])) / 2), 6.0f, 0x404040);
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.resLoc);
        int x = (this.width - this.field_146999_f) / 2;
        int y = (this.height - this.field_147000_g) / 2;
        this.blit(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        for (IGuiWidget widget : this.widgets) {
            widget.render(i, j, f);
        }
    }

    public void render(int x, int y, float partialTick) {
        this.renderBackground();
        super.render(x, y, partialTick);
        this.func_191948_b(x, y);
    }

    public boolean mouseClicked(double x, double y, int button) {
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y) || widget instanceof BaseWidget && !((BaseWidget)widget).enabled) continue;
            widget.onMouseClicked((int)x, (int)y, button);
        }
        return super.mouseClicked(x, y, button);
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget instanceof GuiAnimatedStat && ((GuiAnimatedStat)widget).isClicked()) {
            for (IGuiWidget w : this.widgets) {
                if (w == widget || !(w instanceof GuiAnimatedStat) || ((GuiAnimatedStat)w).isLeftSided() != ((GuiAnimatedStat)widget).isLeftSided()) continue;
                ((GuiAnimatedStat)w).closeWindow();
            }
        }
    }

    public void tick() {
        super.tick();
        for (IGuiWidget widget : this.widgets) {
            widget.update();
        }
    }

    public void resize(Minecraft minecraft, int x, int y) {
        super.resize(minecraft, x, y);
        this.redraw();
    }

    public void redraw() {
        this.buttons.clear();
        this.widgets.clear();
        this.init();
    }
}

