/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class RemoveWaystoneButton
extends Button
implements ITooltipProvider {
    private static final ResourceLocation BEACON = new ResourceLocation("textures/gui/container/beacon.png");
    private final List<String> tooltip;
    private final List<String> activeTooltip;
    private final int visibleRegionStart;
    private final int visibleRegionHeight;
    private static boolean shiftGuard;

    public RemoveWaystoneButton(int x, int y, int visibleRegionStart, int visibleRegionHeight, Button.IPressable pressable) {
        super(x, y, 13, 13, "", pressable);
        this.visibleRegionStart = visibleRegionStart;
        this.visibleRegionHeight = visibleRegionHeight;
        this.tooltip = Collections.singletonList(I18n.func_135052_a((String)"gui.waystones.waystone_selection.hold_shift_to_delete", (Object[])new Object[0]));
        this.activeTooltip = Collections.singletonList(I18n.func_135052_a((String)"gui.waystones.waystone_selection.click_to_delete", (Object[])new Object[0]));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            shiftGuard = true;
            return true;
        }
        return false;
    }

    public void renderButton(int mouseX, int mouseY, float partial) {
        boolean shiftDown = Screen.hasShiftDown();
        if (!shiftDown) {
            shiftGuard = false;
        }
        boolean bl = this.active = !shiftGuard && shiftDown;
        if (mouseY >= this.visibleRegionStart && mouseY < this.visibleRegionStart + this.visibleRegionHeight) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(BEACON);
            if (this.isHovered && this.active) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
            }
            this.blit(this.x, this.y, 114, 223, 13, 13);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public boolean shouldShowTooltip() {
        return this.isHovered;
    }

    @Override
    public List<String> getTooltip() {
        return this.active ? this.activeTooltip : this.tooltip;
    }
}

