/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockCompDrawers
extends BlockDrawers
implements INetworked {
    public static final EnumProperty<EnumCompDrawer> SLOTS = EnumProperty.func_177709_a((String)"slots", EnumCompDrawer.class);

    public BlockCompDrawers(int storageUnits, Block.Properties properties) {
        super(3, false, storageUnits, properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(SLOTS, (Comparable)((Object)EnumCompDrawer.OPEN1)));
    }

    public BlockCompDrawers(Block.Properties properties) {
        this(32, properties);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{SLOTS});
    }

    public boolean func_229869_c_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    @Override
    protected int getDrawerSlot(Direction side, Vec3d hit) {
        if (this.hitTop(hit.field_72448_b)) {
            return 0;
        }
        if (this.hitLeft(side, hit.field_72450_a, hit.field_72449_c)) {
            return 1;
        }
        return 2;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        TileEntityDrawers tile = this.getTileEntity((IBlockReader)world, pos);
        if (tile != null) {
            IDrawerGroup group = tile.getGroup();
            for (int i = group.getDrawerCount() - 1; i >= 0; --i) {
                if (group.getDrawer(i).isEmpty()) continue;
                world.func_180501_a(pos, (BlockState)state.func_206870_a(SLOTS, (Comparable)((Object)EnumCompDrawer.byOpenSlots(i + 1))), 3);
                break;
            }
        }
    }

    public TileEntityDrawers createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityDrawersComp.Slot3();
    }
}

