/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.serialization.packetbuffer;

import com.davenonymous.libnonymous.serialization.FieldUtils;
import com.davenonymous.libnonymous.serialization.Sync;
import com.davenonymous.libnonymous.serialization.packetbuffer.PacketBufferFieldHandlers;
import com.davenonymous.libnonymous.serialization.packetbuffer.PacketBufferFieldSerializationData;
import com.davenonymous.libnonymous.utils.Logz;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.PacketBuffer;

public class PacketBufferUtils {
    private static Map<Class, List<PacketBufferFieldSerializationData>> classByteBufCache = new HashMap<Class, List<PacketBufferFieldSerializationData>>();

    public static List<PacketBufferFieldSerializationData> initSerializableSyncFields(Class clz) {
        if (classByteBufCache.containsKey(clz)) {
            return classByteBufCache.get(clz);
        }
        ArrayList<PacketBufferFieldSerializationData> actionList = new ArrayList<PacketBufferFieldSerializationData>();
        for (Field field : FieldUtils.getAllDeclaredFields(clz)) {
            Sync annotation = field.getDeclaredAnnotation(Sync.class);
            if (annotation == null || !(annotation instanceof Sync)) continue;
            if (!PacketBufferFieldHandlers.hasIOHandler(field.getType())) {
                Logz.warn("No PacketBuffer serialization methods for field='{}' (type='{}') in class='{}' exists.", field.getName(), field.getType().getSimpleName(), clz.getSimpleName());
                continue;
            }
            Sync syncAnnotation = annotation;
            actionList.add(new PacketBufferFieldSerializationData(field));
            field.setAccessible(true);
        }
        classByteBufCache.put(clz, actionList);
        return actionList;
    }

    public static void writeFieldsToByteBuf(List<PacketBufferFieldSerializationData> ioActions, Object source, PacketBuffer targetBuffer, Predicate<PacketBufferFieldSerializationData> test) {
        for (PacketBufferFieldSerializationData data : ioActions) {
            if (!test.test(data)) continue;
            try {
                Object value = data.field.get(source);
                data.writer.write(value, targetBuffer);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void readFieldsFromByteBuf(List<PacketBufferFieldSerializationData> ioActions, Object target, PacketBuffer sourceBuffer, Predicate<PacketBufferFieldSerializationData> test) {
        for (PacketBufferFieldSerializationData data : ioActions) {
            if (!test.test(data)) continue;
            try {
                Object value = data.reader.read(sourceBuffer);
                data.field.set(target, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

