/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.config.types;

import com.davenonymous.libnonymous.gui.config.types.SettingListEntry;
import com.davenonymous.libnonymous.gui.framework.ColorHelper;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.util.FontAwesomeIcons;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetFontAwesome;
import net.minecraftforge.common.ForgeConfigSpec;

public class BooleanSettingListEntry
extends SettingListEntry {
    WidgetFontAwesome toggleButtonOn;
    WidgetFontAwesome toggleButtonOff;

    public BooleanSettingListEntry(String optionKey, String comment, ForgeConfigSpec.ConfigValue value, Object defaultValue, int columnWidth) {
        super(optionKey, comment, value, defaultValue, columnWidth);
    }

    @Override
    public void fillPanel(int baseEntryHeight) {
        this.setSize(this.columnWidth, baseEntryHeight);
        boolean val = (Boolean)this.value.get();
        int buttonX = this.columnWidth - 16;
        int buttonY = (baseEntryHeight - 16) / 2 - 2;
        this.toggleButtonOn = new WidgetFontAwesome(FontAwesomeIcons.REGULAR_CheckCircle, WidgetFontAwesome.IconSize.MEDIUM);
        this.toggleButtonOn.setColor(ColorHelper.COLOR_ENABLED);
        this.toggleButtonOn.setPosition(buttonX, buttonY);
        this.add(this.toggleButtonOn);
        this.toggleButtonOff = new WidgetFontAwesome(FontAwesomeIcons.REGULAR_Circle, WidgetFontAwesome.IconSize.MEDIUM);
        this.toggleButtonOff.setColor(ColorHelper.COLOR_DISABLED);
        this.toggleButtonOff.setPosition(buttonX, buttonY);
        this.add(this.toggleButtonOff);
        this.toggleButtonOff.addListener(MouseClickEvent.class, (event, widget) -> {
            this.value.set((Object)true);
            this.value.save();
            this.updateDefaultIconState();
            this.toggleButtonOn.setVisible(true);
            this.toggleButtonOff.setVisible(false);
            return WidgetEventResult.HANDLED;
        });
        this.toggleButtonOn.addListener(MouseClickEvent.class, (event, widget) -> {
            this.value.set((Object)false);
            this.value.save();
            this.updateDefaultIconState();
            this.toggleButtonOn.setVisible(false);
            this.toggleButtonOff.setVisible(true);
            return WidgetEventResult.HANDLED;
        });
        this.toggleButtonOn.setVisible(val);
        this.toggleButtonOff.setVisible(!val);
    }

    @Override
    public void setValueInInputField(Object defaultValue) {
        if (defaultValue == null) {
            this.toggleButtonOn.setVisible(false);
            this.toggleButtonOff.setVisible(true);
        } else {
            boolean realVal = (Boolean)defaultValue;
            this.toggleButtonOn.setVisible(realVal);
            this.toggleButtonOff.setVisible(!realVal);
        }
    }
}

