/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.ElementPosition;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.ui.theme.client.ThemeRegistryClient;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;

public abstract class VLScreen
extends Screen
implements IElementContainer,
IElementInput,
IElementDraw {
    protected Theme theme = ThemeRegistryClient.getInstance().getTheme(ThemeRegistry.DEFAULT);
    protected Map<IElement, ElementPosition> elements = new HashMap<IElement, ElementPosition>();
    protected List<IElement> elementList = new ArrayList<IElement>();
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;

    protected VLScreen(ITextComponent titleIn) {
        super(titleIn);
    }

    public final void addElement(IElement ele, int x, int y) {
        if (ele != null) {
            ElementPosition pos = new ElementPosition(x, y);
            this.elements.put(ele, pos);
            this.elementList.add(ele);
            ele.setOwner(this);
        }
    }

    protected abstract void addElements();

    protected final void init() {
        this.guiLeft = (int)Math.floor((double)this.width / 2.0) - this.xSize / 2;
        this.guiTop = (int)Math.floor((double)this.height / 2.0) - this.ySize / 2;
        this.initContainer();
    }

    public final void tick() {
        super.tick();
        this.update();
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        this.drawGuiContainerBackgroundLayer(p_render_3_, p_render_1_, p_render_2_);
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }

    protected final void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(mouseX, mouseY, partialTicks);
    }

    protected final void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.drawForeground(mouseX, mouseY);
        this.drawTooltips(mouseX, mouseY);
    }

    public final void closeGui() {
        super.onClose();
    }

    @Override
    public final Screen getGui() {
        return this;
    }

    @Override
    public final void initContainer() {
        this.addElements();
        this.onThemeChanged(this.theme);
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseReleasedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseDraggedResponse(IElement element, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
    }

    @Override
    public void mouseScrolledResponse(IElement element, double mouseX, double mouseY, double scrolled) {
    }

    @Override
    public void keyPressedResponse(IElement element, int key, int scanCode, int modifiers) {
    }

    @Override
    public void keyReleasedResponse(IElement element, int key, int scanCode, int modifiers) {
    }

    @Override
    public void charTypedResponse(IElement element, char ch, int modifiers) {
    }

    @Override
    public final int getContainerOffsetX(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return this.elements.get(ele).getX();
        }
        return 0;
    }

    @Override
    public final int getContainerOffsetY(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return this.elements.get(ele).getY();
        }
        return 0;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawBackground(this.elementList, mouseX, mouseY, partialTicks, this);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        GuiUtils.drawForeground(this.elementList, mouseX, mouseY, this);
    }

    @Override
    public void drawTooltips(int mouseX, int mouseY) {
        GuiUtils.drawTooltips(this.elementList, mouseX, mouseY, this);
    }

    @Override
    public final String getID() {
        return this.getRawID();
    }

    @Override
    public String getRawID() {
        return "main";
    }

    @Override
    public final int getActualX() {
        return this.guiLeft;
    }

    @Override
    public final int getActualY() {
        return this.guiTop;
    }

    @Override
    public final int getSizeX() {
        return this.xSize;
    }

    @Override
    public final int getSizeY() {
        return this.ySize;
    }

    @Override
    public final void onThemeChanged(Theme current) {
        GuiUtils.onThemeChangedAll(this.elementList, current);
    }

    @Override
    public final Theme getTheme() {
        return this.theme;
    }

    @Override
    public void update() {
        GuiUtils.updateAll(this.elementList);
    }
}

