/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.blocks.buzzierbees;

import com.bagel.buzzierbees.common.blocks.CandleBlock;
import com.endlesnights.torchslabsmod.blocks.buzzierbees.entities.FallingCandleSlabEntity;
import com.endlesnights.torchslabsmod.blocks.buzzierbees.util.GetCandle;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockCandleSlab
extends Block
implements IWaterLoggable {
    public static final IntegerProperty CANDLES = CandleBlock.CANDLES;
    public static final BooleanProperty WATERLOGGED = CandleBlock.WATERLOGGED;
    public static final DirectionProperty FACING = CandleBlock.FACING;
    protected static final VoxelShape ONE_SHAPE = Block.func_208617_a((double)6.0, (double)-8.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    protected static final VoxelShape TWO_SHAPE = Block.func_208617_a((double)3.0, (double)-8.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    protected static final VoxelShape THREE_SHAPE = Block.func_208617_a((double)3.0, (double)-8.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    protected static final VoxelShape FOUR_SHAPE = Block.func_208617_a((double)3.0, (double)-8.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);

    public BlockCandleSlab(Block.Properties properties) {
        super(properties.func_200943_b(0.1f));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)CANDLES, (Comparable)Integer.valueOf(1))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
    }

    public int func_149750_m(BlockState state) {
        return this.isInBadEnvironment(state) ? 0 : super.func_149750_m(state) + (11 + 1 * (Integer)state.func_177229_b((IProperty)CANDLES));
    }

    private boolean isInBadEnvironment(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.isValidGround(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() instanceof SlabBlock && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM;
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        return 0.1f * (float)((Integer)state.func_177229_b((IProperty)CANDLES)).intValue();
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.func_196260_a(state, (IWorldReader)worldIn, currentPos)) {
            if (worldIn.func_180495_p(currentPos.func_177977_b()).func_177230_c() instanceof SlabBlock && worldIn.func_180495_p(currentPos.func_177977_b()).func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.BOTTOM) {
                return Blocks.field_150350_a.func_176223_P();
            }
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
            return super.func_196271_a(state, facing, facingState, worldIn, currentPos, facingPos);
        }
        return state;
    }

    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        if (p_225534_2_.func_175623_d(p_225534_3_.func_177977_b()) || BlockCandleSlab.canFallThrough(p_225534_2_.func_180495_p(p_225534_3_.func_177977_b())) && p_225534_3_.func_177956_o() >= 0) {
            FallingCandleSlabEntity fallingCandleEntity = new FallingCandleSlabEntity((World)p_225534_2_, (double)p_225534_3_.func_177958_n() + 0.5, p_225534_3_.func_177956_o(), (double)p_225534_3_.func_177952_p() + 0.5, p_225534_2_.func_180495_p(p_225534_3_));
            this.onStartFalling(fallingCandleEntity);
            p_225534_2_.func_217376_c((Entity)fallingCandleEntity);
        }
    }

    protected void onStartFalling(FallingCandleSlabEntity fallingEntity) {
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 2;
    }

    public static boolean canFallThrough(BlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return state.func_196958_f() || block == Blocks.field_150480_ab || material.func_76224_d();
    }

    public void onEndFalling(World worldIn, BlockPos pos, BlockState fallingState, BlockState hitState) {
    }

    public void breakFall(World worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingCandleSlabEntity entity) {
        if (worldIn.func_180495_p(pos).func_177230_c() instanceof SlabBlock && worldIn.func_180495_p(pos).func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM && (worldIn.func_175623_d(pos.func_177984_a()) || worldIn.func_204610_c(pos.func_177984_a()).func_206886_c() == Fluids.field_204546_a || worldIn.func_204610_c(pos.func_177984_a()).func_206886_c() == Fluids.field_207212_b)) {
            worldIn.func_175656_a(pos.func_177984_a(), fallingState);
        } else if (worldIn.func_175623_d(pos) || worldIn.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a || worldIn.func_204610_c(pos).func_206886_c() == Fluids.field_207212_b || worldIn.func_180495_p(pos).func_177230_c() instanceof TallGrassBlock || worldIn.func_180495_p(pos).func_177230_c() instanceof SnowBlock && (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)SnowBlock.field_176315_a) == 1) {
            worldIn.func_180501_a(pos, (BlockState)((BlockState)((BlockState)GetCandle.getParentSlab(fallingState).func_176223_P().func_206870_a((IProperty)CANDLES, fallingState.func_177229_b((IProperty)CANDLES))).func_206870_a((IProperty)WATERLOGGED, fallingState.func_177229_b((IProperty)WATERLOGGED))).func_206870_a((IProperty)FACING, fallingState.func_177229_b((IProperty)FACING)), 3);
        } else if (worldIn.func_180495_p(pos).func_177230_c() instanceof LilyPadBlock) {
            worldIn.func_180501_a(pos, (BlockState)((BlockState)GetCandle.getPadBlock(fallingState).func_176223_P().func_206870_a((IProperty)CANDLES, fallingState.func_177229_b((IProperty)CANDLES))).func_206870_a((IProperty)FACING, fallingState.func_177229_b((IProperty)FACING)), 3);
        } else {
            entity.func_199701_a_(new ItemStack((IItemProvider)GetCandle.getParentSlab(fallingState).func_199767_j(), ((Integer)fallingState.func_177229_b((IProperty)CANDLES)).intValue()));
        }
    }

    public void onBroken(World worldIn, BlockPos pos) {
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Integer)state.func_177229_b((IProperty)CANDLES)) {
            default: {
                return ONE_SHAPE;
            }
            case 2: {
                return TWO_SHAPE;
            }
            case 3: {
                return THREE_SHAPE;
            }
            case 4: 
        }
        return FOUR_SHAPE;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{CANDLES, WATERLOGGED, FACING});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.AIR && !this.field_196274_w ? true : super.func_196266_a(state, worldIn, pos, type);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)GetCandle.getParentSlab(state).func_199767_j());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            double x = pos.func_177958_n();
            double y = (double)pos.func_177956_o() - 0.5;
            double z = pos.func_177952_p();
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 1) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.5, y + 0.75, z + 0.5, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.5, y + 0.75, z + 0.5, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 2 && state.func_177229_b((IProperty)FACING) == Direction.NORTH) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.5625, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.5625, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 2 && state.func_177229_b((IProperty)FACING) == Direction.EAST) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.75, z + 0.5625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.75, z + 0.5625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 2 && state.func_177229_b((IProperty)FACING) == Direction.SOUTH) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.4375, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.4375, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 2 && state.func_177229_b((IProperty)FACING) == Direction.WEST) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.75, z + 0.4375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.75, z + 0.4375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 3 && state.func_177229_b((IProperty)FACING) == Direction.NORTH) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.75, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.75, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.5, y + 0.6875, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.5, y + 0.6875, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 3 && state.func_177229_b((IProperty)FACING) == Direction.EAST) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.6875, z + 0.5, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.6875, z + 0.5, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 3 && state.func_177229_b((IProperty)FACING) == Direction.SOUTH) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.75, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.75, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.5, y + 0.6875, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.5, y + 0.6875, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 3 && state.func_177229_b((IProperty)FACING) == Direction.WEST) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.6875, z + 0.5, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.6875, z + 0.5, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 4 && state.func_177229_b((IProperty)FACING) == Direction.NORTH) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.6875, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.6875, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.4375, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.4375, z + 0.6875, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 4 && state.func_177229_b((IProperty)FACING) == Direction.EAST) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.6875, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.6875, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.4375, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.4375, z + 0.3125, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 4 && state.func_177229_b((IProperty)FACING) == Direction.SOUTH) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.6875, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.6875, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.4375, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.4375, z + 0.3125, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 4 && state.func_177229_b((IProperty)FACING) == Direction.WEST) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.6875, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.6875, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.4375, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.4375, z + 0.6875, 0.002, 0.01, 0.002);
            }
        }
    }
}

