/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.api.event.GetStatModifierEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartDisplay;
import net.silentchaos512.gear.api.parts.IPartMaterial;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartDisplay;
import net.silentchaos512.gear.parts.PartMaterial;
import net.silentchaos512.gear.parts.RepairContext;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public abstract class AbstractGearPart
implements IGearPart {
    private final ResourceLocation name;
    PartMaterial materials = new PartMaterial();
    boolean visible = true;
    int tier = -1;
    List<String> blacklistedGearTypes = new ArrayList<String>();
    StatModifierMap stats = new StatModifierMap();
    List<PartTraitInstance> traits = new ArrayList<PartTraitInstance>();
    ITextComponent displayName;
    @Nullable
    ITextComponent namePrefix = null;
    final Map<String, PartDisplay> display = new HashMap<String, PartDisplay>();
    int modelIndex;
    private static int lastModelIndex;

    public AbstractGearPart(ResourceLocation location) {
        this.name = location;
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public IPartMaterial getMaterials() {
        return this.materials;
    }

    @Override
    public void retainData(@Nullable IGearPart oldPart) {
        if (oldPart instanceof AbstractGearPart) {
            this.traits.clear();
            this.traits.addAll(((AbstractGearPart)oldPart).traits);
        }
    }

    public void updateCraftingItems(PartMaterial material) {
        this.materials = material;
    }

    @Override
    public Collection<StatInstance> getStatModifiers(ItemStack gear, ItemStat stat, PartData part) {
        ArrayList<StatInstance> mods = new ArrayList<StatInstance>(this.stats.get(stat));
        GetStatModifierEvent event = new GetStatModifierEvent(part, stat, mods);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getModifiers();
    }

    @Override
    public List<PartTraitInstance> getTraits(ItemStack gear, PartData part) {
        return Collections.unmodifiableList(this.traits);
    }

    @Override
    public StatInstance.Operation getDefaultStatOperation(ItemStat stat) {
        return stat == ItemStats.HARVEST_LEVEL ? StatInstance.Operation.MAX : StatInstance.Operation.ADD;
    }

    @Override
    public float getRepairAmount(RepairContext context) {
        PartData material = context.getMaterial();
        if (material.getType() != PartType.MAIN) {
            return 0.0f;
        }
        if (material.getTier() < GearData.getTier(context.getGear())) {
            return 0.0f;
        }
        Collection<StatInstance> mods = this.getStatModifiers(context.getGear(), ItemStats.DURABILITY, material);
        float durability = ItemStats.DURABILITY.compute(0.0f, mods);
        switch (context.getRepairType()) {
            case QUICK: {
                return ((Double)Config.GENERAL.repairFactorQuick.get()).floatValue() * durability;
            }
            case ANVIL: {
                return ((Double)Config.GENERAL.repairFactorAnvil.get()).floatValue() * durability;
            }
        }
        throw new IllegalArgumentException("Unknown RepairContext: " + context);
    }

    @Override
    public boolean isCraftingAllowed(@Nullable GearType gearType) {
        if (gearType == null) {
            return true;
        }
        return this.blacklistedGearTypes.stream().noneMatch(gearType::matches) && IGearPart.super.isCraftingAllowed(gearType);
    }

    @Override
    public IPartDisplay getDisplayProperties(PartData part, ItemStack gear, int animationFrame) {
        if (!gear.func_190926_b()) {
            GearType gearType = ((ICoreItem)gear.func_77973_b()).getGearType();
            String typeName = gearType.getName();
            if (this.display.containsKey(typeName)) {
                return this.display.get(typeName);
            }
            for (String key : this.display.keySet()) {
                if (!gearType.matches(key, false)) continue;
                return this.display.get(key);
            }
        }
        return this.display.getOrDefault("all", PartDisplay.DEFAULT);
    }

    @Override
    @Nullable
    public ResourceLocation getTexture(PartData part, ItemStack gear, GearType gearClass, IPartPosition position, int animationFrame) {
        IPartDisplay props = this.getDisplayProperties(part, gear, animationFrame);
        String path = "item/" + gearClass + "/" + position.getTexturePrefix() + "_" + props.getTextureSuffix();
        return new ResourceLocation(props.getTextureDomain(), path);
    }

    @Override
    @Nullable
    public ResourceLocation getBrokenTexture(PartData part, ItemStack gear, GearType gearClass, IPartPosition position) {
        return this.getTexture(part, gear, gearClass, position, 0);
    }

    @Override
    public int getColor(PartData part, ItemStack gear, int animationFrame) {
        IPartDisplay props = this.getDisplayProperties(part, gear, animationFrame);
        if (!gear.func_190926_b()) {
            if (GearHelper.isBroken(gear)) {
                return props.getBrokenColor();
            }
            if (GearHelper.shouldUseFallbackColor(gear, part)) {
                return props.getFallbackColor();
            }
        }
        return props.getNormalColor();
    }

    @Override
    public ITextComponent getDisplayName(@Nullable PartData part, ItemStack gear) {
        if (this.displayName == null) {
            return new StringTextComponent("<error: missing name>");
        }
        return this.displayName.func_212638_h();
    }

    @Override
    public ITextComponent getDisplayNamePrefix(@Nullable PartData part, ItemStack gear) {
        return this.namePrefix != null ? this.namePrefix.func_212638_h() : null;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    @Override
    public String getModelIndex(PartData part, int animationFrame) {
        return this.modelIndex + (animationFrame == 3 ? "_3" : "");
    }

    @Override
    public void addInformation(PartData part, ItemStack gear, List<ITextComponent> tooltip, ITooltipFlag flag) {
    }

    public List<GearType> getBlacklistedGearTypes() {
        return this.blacklistedGearTypes.stream().map(GearType::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public String toString() {
        return "AbstractGearPart{" + this.name + "}";
    }

    public static class Serializer<T extends AbstractGearPart>
    implements IPartSerializer<T> {
        private final ResourceLocation serializerId;
        private final Function<ResourceLocation, T> function;

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> function) {
            this.serializerId = serializerId;
            this.function = function;
        }

        @Override
        public T read(ResourceLocation id, JsonObject json) {
            JsonElement elementDisplay;
            JsonElement craftingItems;
            JsonElement elementTraits;
            AbstractGearPart part = (AbstractGearPart)this.function.apply(id);
            JsonElement elementStats = json.get("stats");
            if (elementStats != null) {
                StatModifierMap statMap = StatModifierMap.read(part, elementStats);
                statMap.keySet().forEach(stat -> part.stats.removeAll(stat));
                statMap.forEach((stat, mod) -> part.stats.put((ItemStat)stat, (StatInstance)mod));
            }
            if ((elementTraits = json.get("traits")) != null && elementTraits.isJsonArray()) {
                JsonArray array = elementTraits.getAsJsonArray();
                ArrayList<PartTraitInstance> traitsList = new ArrayList<PartTraitInstance>();
                for (JsonElement element : array) {
                    traitsList.add(PartTraitInstance.deserialize(element.getAsJsonObject()));
                }
                if (!traitsList.isEmpty()) {
                    part.traits.clear();
                    part.traits.addAll(traitsList);
                }
            }
            if ((craftingItems = json.get("crafting_items")) == null || !craftingItems.isJsonObject()) {
                throw new JsonSyntaxException("Expected 'crafting_items' to be an object");
            }
            part.materials = PartMaterial.deserialize(id, craftingItems.getAsJsonObject());
            JsonElement elementName = json.get("name");
            if (elementName == null || !elementName.isJsonObject()) {
                throw new JsonSyntaxException("Expected 'name' element");
            }
            part.displayName = Serializer.deserializeText(elementName);
            JsonElement elementNamePrefix = json.get("name_prefix");
            if (elementNamePrefix != null) {
                part.namePrefix = Serializer.deserializeText(elementNamePrefix);
            }
            if ((elementDisplay = json.get("textures")) != null && elementDisplay.isJsonObject()) {
                JsonObject obj = elementDisplay.getAsJsonObject();
                PartDisplay defaultProps = part.display.getOrDefault("all", PartDisplay.DEFAULT);
                if (!part.display.containsKey("all")) {
                    part.display.put("all", defaultProps);
                }
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement value = (JsonElement)entry.getValue();
                    if (!value.isJsonObject()) continue;
                    JsonObject jsonObject = value.getAsJsonObject();
                    part.display.put(key, PartDisplay.from(jsonObject, defaultProps));
                }
            } else {
                throw new JsonSyntaxException("Expected 'textures' to be an object");
            }
            JsonElement elementAvailability = json.get("availability");
            if (elementAvailability != null && elementAvailability.isJsonObject()) {
                JsonObject obj = elementAvailability.getAsJsonObject();
                part.tier = JSONUtils.func_151208_a((JsonObject)obj, (String)"tier", (int)part.tier);
                part.visible = JSONUtils.func_151209_a((JsonObject)obj, (String)"visible", (boolean)part.visible);
                JsonArray blacklist = Serializer.getGearBlacklist(obj);
                if (blacklist != null) {
                    part.blacklistedGearTypes.clear();
                    blacklist.forEach(e -> part.blacklistedGearTypes.add(e.getAsString()));
                }
            } else {
                throw new JsonSyntaxException("Expected 'availability' to be an object");
            }
            return (T)part;
        }

        private static ITextComponent deserializeText(JsonElement json) {
            if (json.isJsonObject() && json.getAsJsonObject().has("name")) {
                boolean translate = JSONUtils.func_151209_a((JsonObject)json.getAsJsonObject(), (String)"translate", (boolean)false);
                String name = JSONUtils.func_151200_h((JsonObject)json.getAsJsonObject(), (String)"name");
                return translate ? new TranslationTextComponent(name, new Object[0]) : new StringTextComponent(name);
            }
            return Objects.requireNonNull(ITextComponent.Serializer.func_197672_a((JsonElement)json));
        }

        @Nullable
        private static JsonArray getGearBlacklist(JsonObject json) {
            if (json.has("gear_blacklist")) {
                return JSONUtils.func_151214_t((JsonObject)json, (String)"gear_blacklist");
            }
            if (json.has("tool_blacklist")) {
                return JSONUtils.func_151214_t((JsonObject)json, (String)"tool_blacklist");
            }
            return null;
        }

        @Override
        public T read(ResourceLocation id, PacketBuffer buffer) {
            AbstractGearPart part = (AbstractGearPart)this.function.apply(id);
            part.displayName = buffer.func_179258_d();
            if (buffer.readBoolean()) {
                part.namePrefix = buffer.func_179258_d();
            }
            part.materials = PartMaterial.read(buffer);
            part.tier = buffer.readByte();
            part.visible = buffer.readBoolean();
            part.blacklistedGearTypes.clear();
            int blacklistSize = buffer.readByte();
            for (int i = 0; i < blacklistSize; ++i) {
                part.blacklistedGearTypes.add(buffer.func_218666_n());
            }
            int displayCount = buffer.func_150792_a();
            for (int i = 0; i < displayCount; ++i) {
                String key = buffer.func_150789_c(255);
                PartDisplay display = PartDisplay.read(buffer);
                part.display.put(key, display);
            }
            part.stats = StatModifierMap.read(buffer);
            this.readTraits(buffer, part);
            return (T)part;
        }

        @Override
        public void write(PacketBuffer buffer, T part) {
            buffer.func_179256_a(((AbstractGearPart)part).getDisplayName(null, ItemStack.field_190927_a));
            buffer.writeBoolean(((AbstractGearPart)part).namePrefix != null);
            if (((AbstractGearPart)part).namePrefix != null) {
                buffer.func_179256_a(((AbstractGearPart)part).namePrefix);
            }
            ((AbstractGearPart)part).materials.write(buffer);
            buffer.writeByte(((AbstractGearPart)part).getTier());
            buffer.writeBoolean(((AbstractGearPart)part).visible);
            buffer.writeByte(((AbstractGearPart)part).blacklistedGearTypes.size());
            ((AbstractGearPart)part).blacklistedGearTypes.forEach(arg_0 -> ((PacketBuffer)buffer).func_180714_a(arg_0));
            buffer.func_150787_b(((AbstractGearPart)part).display.size());
            ((AbstractGearPart)part).display.forEach((s, partDisplay) -> {
                buffer.func_180714_a(s);
                PartDisplay.write(buffer, partDisplay);
            });
            ((AbstractGearPart)part).stats.write(buffer);
            this.writeTraits(buffer, part);
        }

        private void readTraits(PacketBuffer buffer, T part) {
            ((AbstractGearPart)part).traits.clear();
            int traitCount = buffer.func_150792_a();
            for (int i = 0; i < traitCount; ++i) {
                ((AbstractGearPart)part).traits.add(PartTraitInstance.read(buffer));
            }
        }

        private void writeTraits(PacketBuffer buffer, T part) {
            buffer.func_150787_b(((AbstractGearPart)part).traits.size());
            ((AbstractGearPart)part).traits.forEach(inst -> inst.write(buffer));
        }

        @Override
        public ResourceLocation getName() {
            return this.serializerId;
        }
    }
}

