/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class ValueNotifyPacket
extends PacketCodec {
    @CodecField
    private String containerType;
    @CodecField
    private int valueId;
    @CodecField
    private CompoundNBT value;

    public ValueNotifyPacket() {
    }

    public ValueNotifyPacket(ContainerType<?> containerType, int valueId, CompoundNBT value) {
        this.containerType = containerType.getRegistryName().toString();
        this.valueId = valueId;
        this.value = value;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    protected boolean isContainerValid(IValueNotifiable container) {
        return container.getType().getRegistryName().toString().equals(this.containerType);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
        IValueNotifiable container;
        if (player.field_71070_bA instanceof IValueNotifiable && this.isContainerValid(container = (IValueNotifiable)player.field_71070_bA)) {
            container.onUpdate(this.valueId, this.value);
        }
    }

    @Override
    public void actionServer(World world, ServerPlayerEntity player) {
        IValueNotifiable container;
        if (player.field_71070_bA instanceof IValueNotifiable && this.isContainerValid(container = (IValueNotifiable)player.field_71070_bA)) {
            container.onUpdate(this.valueId, this.value);
        }
    }
}

