/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.network.packet.RequestPlayerAdvancementUnlockedPacket;

public class AdvancementHelpers {
    public static final Set<ResourceLocation> ACHIEVED_ADVANCEMENTS = Sets.newHashSet();

    public static boolean hasAdvancementUnlocked(PlayerEntity player, Advancement advancement) {
        return player instanceof ServerPlayerEntity && ((ServerPlayerEntity)player).field_71133_b.func_184103_al().func_192054_h((ServerPlayerEntity)player).func_192747_a(advancement).func_192105_a();
    }

    public static boolean hasAdvancementUnlocked(PlayerEntity player, ResourceLocation advancementId) {
        return ACHIEVED_ADVANCEMENTS.contains(advancementId);
    }

    public static void requestAdvancementUnlockInfo(ResourceLocation advancementId) {
        CyclopsCore._instance.getPacketHandler().sendToServer(new RequestPlayerAdvancementUnlockedPacket(advancementId.toString()));
    }

    public static Advancement getAdvancement(Dist dist, ResourceLocation resourceLocation) {
        if (dist.isClient()) {
            return AdvancementHelpers.getAdvancementManagerClient().func_194229_a().func_192084_a(resourceLocation);
        }
        return AdvancementHelpers.getAdvancementManagerServer().func_192778_a(resourceLocation);
    }

    public static AdvancementManager getAdvancementManagerServer() {
        return ServerLifecycleHooks.getCurrentServer().func_191949_aK();
    }

    public static ClientAdvancementManager getAdvancementManagerClient() {
        return Minecraft.func_71410_x().field_71439_g.field_71174_a.func_191982_f();
    }

    public static <T extends ICriterionTrigger<?>> T registerCriteriaTrigger(T criterion) {
        return (T)CriteriaTriggers.func_192118_a(criterion);
    }
}

