/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.preview;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.region.Region;
import com.terraforged.core.region.gen.RegionGenerator;
import com.terraforged.core.settings.Settings;
import com.terraforged.core.util.concurrent.ThreadPool;
import com.terraforged.core.util.concurrent.cache.CacheEntry;
import com.terraforged.core.world.GeneratorContext;
import com.terraforged.core.world.WorldGeneratorFactory;
import com.terraforged.core.world.heightmap.Levels;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.core.world.terrain.Terrains;
import com.terraforged.mod.gui.preview.PreviewSettings;
import com.terraforged.mod.gui.preview.RenderMode;
import com.terraforged.mod.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.Random;
import me.dags.noise.util.NoiseUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.nbt.CompoundNBT;

public class Preview
extends Button {
    private static final int FACTOR = 4;
    public static final int WIDTH = 256;
    private static final int SLICE_HEIGHT = 64;
    public static final int HEIGHT = 320;
    private static final float[] LEGEND_SCALES = new float[]{1.0f, 0.9f, 0.75f, 0.6f};
    private final int offsetX;
    private final int offsetZ;
    private final Random random = new Random(System.currentTimeMillis());
    private final PreviewSettings previewSettings = new PreviewSettings();
    private final DynamicTexture texture = new DynamicTexture(new NativeImage(256, 320, true));
    private final String[] values = new String[]{"", "", ""};
    private final String[] labels = new String[]{"Area: ", "Terrain: ", "Biome: "};
    private int seed;
    private long lastUpdate = 0L;
    private Settings settings = new Settings();
    private CacheEntry<Region> task = null;
    private Region region = null;

    public Preview(int seed) {
        super(0, 0, 0, 0, "", b -> {});
        this.seed = seed == -1 ? this.random.nextInt() : seed;
        this.offsetX = 0;
        this.offsetZ = 0;
    }

    public int getSeed() {
        return this.seed;
    }

    public void regenerate() {
        this.seed = this.random.nextInt();
    }

    public void close() {
        this.texture.close();
    }

    public void render(int mx, int my, float partialTicks) {
        float scale = (float)this.width / 256.0f;
        this.height = this.width + NoiseUtil.round(64.0f * scale);
        this.preRender();
        this.texture.func_229148_d_();
        RenderSystem.enableBlend();
        RenderSystem.enableRescaleNormal();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        AbstractGui.blit((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
        RenderSystem.disableRescaleNormal();
        this.updateLegend(mx, my);
        this.renderLegend(this.labels, this.values, this.x, this.y + this.width, 10, 0xFFFFFF);
    }

    public void update(Settings settings, CompoundNBT prevSettings) {
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate < 50L) {
            return;
        }
        this.lastUpdate = time;
        NBTHelper.deserialize(prevSettings, this.previewSettings);
        settings.generator.seed = this.seed;
        this.task = this.generate(settings, prevSettings);
    }

    private void preRender() {
        if (this.task != null && this.task.isDone()) {
            try {
                this.region = this.task.get();
                this.render(this.region);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                this.task = null;
            }
        }
    }

    private void render(Region region) {
        NativeImage image = this.texture.func_195414_e();
        if (image == null) {
            return;
        }
        RenderMode renderer = this.previewSettings.mode;
        Levels levels = new Levels(this.settings.generator);
        int stroke = 2;
        int width = region.getBlockSize().size;
        int zoom = 101 - this.previewSettings.zoom;
        int half = width / 2;
        int sliceStartY = image.func_195714_b() - 1 - 64;
        float zoomUnit = 1.0f - (float)zoom / 100.0f;
        float zoomStrength = 0.5f;
        float unit = 1.0f - zoomStrength + zoomStrength * zoomUnit;
        float heightModifier = (float)this.settings.generator.world.worldHeight / 256.0f;
        float waterLevelModifier = (float)this.settings.generator.world.seaLevel / (float)this.settings.generator.world.worldHeight;
        float imageWaterLevelY = (float)(image.func_195714_b() - 1) - waterLevelModifier * 64.0f * unit;
        region.iterate((cell, x, z) -> {
            if (x < stroke || z < stroke || x >= width - stroke || z >= width - stroke) {
                image.func_195700_a(x, z, Color.BLACK.getRGB());
            } else {
                image.func_195700_a(x, z, renderer.getColor(cell, levels));
            }
            if (z == half) {
                int height = (int)(cell.value * 64.0f * unit * heightModifier);
                float imageSurfaceLevelY = image.func_195714_b() - 1 - height;
                for (int dy = sliceStartY; dy < image.func_195714_b(); ++dy) {
                    if (x < stroke || x >= width - stroke || dy > image.func_195714_b() - 1 - stroke) {
                        image.func_195700_a(x, dy, Color.BLACK.getRGB());
                        continue;
                    }
                    if ((float)dy > imageSurfaceLevelY) {
                        image.func_195700_a(x, dy, Color.BLACK.getRGB());
                        continue;
                    }
                    if ((float)dy > imageWaterLevelY) {
                        image.func_195700_a(x, dy, Color.GRAY.getRGB());
                        continue;
                    }
                    image.func_195700_a(x, dy, Color.WHITE.getRGB());
                }
            }
        });
        this.texture.func_110564_a();
    }

    private CacheEntry<Region> generate(Settings settings, CompoundNBT prevSettings) {
        NBTHelper.deserialize(prevSettings, this.previewSettings);
        settings.generator.seed = this.seed;
        this.settings = settings;
        GeneratorContext context = new GeneratorContext(Terrains.create(settings), settings);
        RegionGenerator renderer = RegionGenerator.builder().factory(new WorldGeneratorFactory(context)).pool(ThreadPool.getPool()).size(4, 0).build();
        return renderer.queue(this.offsetX, this.offsetZ, 101 - this.previewSettings.zoom, false);
    }

    private void updateLegend(int mx, int my) {
        if (this.region != null) {
            int left = this.x;
            int top = this.y;
            float size = this.width;
            int zoom = 101 - this.previewSettings.zoom;
            int width = Math.max(1, this.region.getBlockSize().size * zoom);
            int height = Math.max(1, this.region.getBlockSize().size * zoom);
            this.values[0] = width + "x" + height;
            if (mx >= left && (float)mx <= (float)left + size && my >= top && (float)my <= (float)top + size) {
                float fx = (float)(mx - left) / size;
                float fz = (float)(my - top) / size;
                int ix = NoiseUtil.round(fx * (float)this.region.getBlockSize().size);
                int iz = NoiseUtil.round(fz * (float)this.region.getBlockSize().size);
                Cell<Terrain> cell = this.region.getCell(ix, iz);
                this.values[1] = Preview.getTerrainName(cell);
                this.values[2] = Preview.getBiomeName(cell);
            }
        }
    }

    private float getLegendScale() {
        int index = Minecraft.func_71410_x().field_71474_y.field_74335_Z - 1;
        if (index < 0 || index >= LEGEND_SCALES.length) {
            index = LEGEND_SCALES.length - 1;
        }
        return LEGEND_SCALES[index];
    }

    private void renderLegend(String[] labels, String[] values, int left, int top, int lineHeight, int color) {
        float scale = this.getLegendScale();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)left + 3.75f * scale), (float)((float)top - (float)lineHeight * (3.2f * scale)), (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        int spacing = 0;
        for (String s : labels) {
            spacing = Math.max(spacing, renderer.func_78256_a(s));
        }
        float maxWidth = (float)(this.width - 4) / scale;
        for (int i = 0; i < labels.length && i < values.length; ++i) {
            String label = labels[i];
            String value = values[i];
            while (value.length() > 0 && (float)(spacing + Minecraft.func_71410_x().field_71466_p.func_78256_a(value)) > maxWidth) {
                value = value.substring(0, value.length() - 1);
            }
            this.drawString(renderer, label, 0, i * lineHeight, color);
            this.drawString(renderer, value, spacing, i * lineHeight, color);
        }
        RenderSystem.popMatrix();
    }

    private static String getTerrainName(Cell<Terrain> cell) {
        String terrain = ((Terrain)cell.tag).getName().toLowerCase();
        if (terrain.contains("river")) {
            return "river";
        }
        return terrain;
    }

    private static String getBiomeName(Cell<Terrain> cell) {
        String terrain = ((Terrain)cell.tag).getName().toLowerCase();
        if (terrain.contains("ocean")) {
            if ((double)cell.temperature < 0.3) {
                return "cold_ocean";
            }
            if ((double)cell.temperature > 0.6) {
                return "warm_ocean";
            }
            return "ocean";
        }
        if (terrain.contains("river")) {
            return "river";
        }
        return cell.biomeType.name().toLowerCase();
    }
}

