/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.page;

import com.terraforged.core.settings.Settings;
import com.terraforged.mod.gui.OverlayScreen;
import com.terraforged.mod.gui.page.BasePage;
import com.terraforged.mod.gui.page.Page;
import com.terraforged.mod.gui.preview.PreviewPage;
import com.terraforged.mod.util.nbt.NBTHelper;
import net.minecraft.nbt.CompoundNBT;

public class FilterPage
extends BasePage {
    private final Settings settings;
    private final PreviewPage preview;
    private final CompoundNBT filterSettings;

    public FilterPage(Settings settings, PreviewPage preview) {
        this.settings = settings;
        this.preview = preview;
        this.filterSettings = NBTHelper.serialize(settings.filters);
    }

    @Override
    public String getTitle() {
        return "Filter Settings";
    }

    @Override
    public void save() {
        NBTHelper.deserialize(this.filterSettings, this.settings.filters);
    }

    @Override
    public void init(OverlayScreen parent) {
        Page.Column column = this.getColumn(0);
        this.addElements(0, 0, column, this.filterSettings, true, column.scrollPane::addButton, this::update);
    }

    @Override
    protected void update() {
        super.update();
        this.preview.apply(settings -> NBTHelper.deserialize(this.filterSettings, settings.filters));
    }
}

