/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.heightmap;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.cell.Extent;
import com.terraforged.core.region.Region;
import com.terraforged.core.region.Size;
import com.terraforged.core.region.chunk.ChunkReader;
import com.terraforged.core.world.terrain.Terrain;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface RegionExtent
extends Extent {
    public int chunkToRegion(int var1);

    public Region getRegion(int var1, int var2);

    public CompletableFuture<Region> getRegionAsync(int var1, int var2);

    default public ChunkReader getChunk(int chunkX, int chunkZ) {
        int regionX = this.chunkToRegion(chunkX);
        int regionZ = this.chunkToRegion(chunkZ);
        Region region = this.getRegion(regionX, regionZ);
        return region.getChunk(chunkX, chunkZ);
    }

    default public List<CompletableFuture<Region>> getRegions(int minRegionX, int minRegionZ, int maxRegionX, int maxRegionZ) {
        LinkedList<CompletableFuture<Region>> regions = new LinkedList<CompletableFuture<Region>>();
        for (int rz = minRegionZ; rz <= maxRegionZ; ++rz) {
            for (int rx = minRegionX; rx <= maxRegionX; ++rx) {
                regions.add(this.getRegionAsync(rx, rz));
            }
        }
        return regions;
    }

    @Override
    default public void visit(int minX, int minZ, int maxX, int maxZ, Cell.Visitor<Terrain> visitor) {
        int minRegionX = this.chunkToRegion(Size.blockToChunk(minX));
        int minRegionZ = this.chunkToRegion(Size.blockToChunk(minZ));
        int maxRegionX = this.chunkToRegion(Size.blockToChunk(maxX));
        int maxRegionZ = this.chunkToRegion(Size.blockToChunk(maxZ));
        List<CompletableFuture<Region>> regions = this.getRegions(minRegionX, minRegionZ, maxRegionX, maxRegionZ);
        while (!regions.isEmpty()) {
            regions.removeIf(future -> {
                if (!future.isDone()) {
                    return false;
                }
                Region region = (Region)future.join();
                region.visit(minX, minZ, maxX, maxZ, visitor);
                return true;
            });
        }
    }
}

