/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.settings;

import com.terraforged.core.util.serialization.annotation.Comment;
import com.terraforged.core.util.serialization.annotation.Range;
import com.terraforged.core.util.serialization.annotation.Serializable;
import me.dags.noise.Module;
import me.dags.noise.Source;

@Serializable
public class ClimateSettings {
    public RangeValue moisture = new RangeValue(0.0f, 1.0f);
    public RangeValue temperature = new RangeValue(0.0f, 1.0f);

    @Serializable
    public static class RangeValue {
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"The lower limit of the range"})
        public float min;
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"The upper limit of the range"})
        public float max;

        public RangeValue() {
            this(0.0f, 1.0f);
        }

        public RangeValue(float min, float max) {
            this.min = min;
            this.max = max;
        }

        public float getMin() {
            return Math.min(this.min, this.max);
        }

        public float getMax() {
            return Math.max(this.min, this.max);
        }

        public Module clamp(Module module) {
            float min = this.getMin();
            float max = this.getMax();
            float range = max - min;
            if (range == 0.0f) {
                return Source.constant(min);
            }
            return module.scale(range).bias(min);
        }
    }
}

