/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.api.biome;

import com.terraforged.core.world.biome.BiomeType;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class BiomeTags {
    private static int generation;
    private static TagCollection<Biome> collection;
    private static final Map<BiomeType, BiomeWrapper> tags;
    public static final Tag<Biome> ALPINE;
    public static final Tag<Biome> COLD_STEPPE;
    public static final Tag<Biome> DESERT;
    public static final Tag<Biome> GRASSLAND;
    public static final Tag<Biome> SAVANNA;
    public static final Tag<Biome> STEPPE;
    public static final Tag<Biome> TAIGA;
    public static final Tag<Biome> TEMPERATE_FOREST;
    public static final Tag<Biome> TEMPERATE_RAINFOREST;
    public static final Tag<Biome> TROPICAL_RAINFOREST;
    public static final Tag<Biome> TUNDRA;

    public static Tag<Biome> getTag(BiomeType type) {
        return tags.get((Object)type);
    }

    public static void setCollection(TagCollection<Biome> collection) {
        BiomeTags.collection = collection;
        ++generation;
    }

    private static BiomeWrapper tag(BiomeType type) {
        BiomeWrapper wrapper = BiomeTags.tag(type.name().toLowerCase());
        tags.put(type, wrapper);
        return wrapper;
    }

    private static BiomeWrapper tag(String name) {
        return new BiomeWrapper(new ResourceLocation("terraforged", name));
    }

    static {
        collection = new TagCollection(path -> Optional.empty(), "", false, "");
        tags = new EnumMap<BiomeType, BiomeWrapper>(BiomeType.class);
        ALPINE = BiomeTags.tag(BiomeType.ALPINE);
        COLD_STEPPE = BiomeTags.tag(BiomeType.COLD_STEPPE);
        DESERT = BiomeTags.tag(BiomeType.DESERT);
        GRASSLAND = BiomeTags.tag(BiomeType.GRASSLAND);
        SAVANNA = BiomeTags.tag(BiomeType.SAVANNA);
        STEPPE = BiomeTags.tag(BiomeType.STEPPE);
        TAIGA = BiomeTags.tag(BiomeType.TAIGA);
        TEMPERATE_FOREST = BiomeTags.tag(BiomeType.TEMPERATE_FOREST);
        TEMPERATE_RAINFOREST = BiomeTags.tag(BiomeType.TEMPERATE_RAINFOREST);
        TROPICAL_RAINFOREST = BiomeTags.tag(BiomeType.TROPICAL_RAINFOREST);
        TUNDRA = BiomeTags.tag(BiomeType.TUNDRA);
    }

    private static class BiomeWrapper
    extends Tag<Biome> {
        private Tag<Biome> cachedTag = null;
        private int lastKnownGeneration = -1;

        public BiomeWrapper(ResourceLocation name) {
            super(name);
        }

        public boolean contains(Biome biome) {
            if (this.lastKnownGeneration != generation) {
                this.cachedTag = collection.func_199915_b(this.func_199886_b());
                this.lastKnownGeneration = generation;
            }
            return this.cachedTag.func_199685_a_((Object)biome);
        }

        public Collection<Biome> func_199885_a() {
            if (this.lastKnownGeneration != generation) {
                this.cachedTag = collection.func_199915_b(this.func_199886_b());
                this.lastKnownGeneration = generation;
            }
            return this.cachedTag.func_199885_a();
        }

        public Collection<Tag.ITagEntry<Biome>> func_200570_b() {
            if (this.lastKnownGeneration != generation) {
                this.cachedTag = collection.func_199915_b(this.func_199886_b());
                this.lastKnownGeneration = generation;
            }
            return this.cachedTag.func_200570_b();
        }
    }
}

