/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.RepeatType;
import java.util.EnumSet;

public class QuestTicker
implements ITickHandler {
    private int hours;
    private int ticks;

    public QuestTicker(boolean isClient) {
        if (isClient) {
            TickRegistry.registerTickHandler((ITickHandler)this, (Side)Side.CLIENT);
        } else {
            TickRegistry.registerTickHandler((ITickHandler)this, (Side)Side.SERVER);
        }
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        boolean isClient = type.contains(TickType.CLIENT);
        if (++this.ticks == 1000) {
            this.ticks = 0;
            ++this.hours;
            if (!isClient) {
                for (Quest quest : Quest.getQuests()) {
                    int total = quest.getRepeatInfo().getDays() * 24 + quest.getRepeatInfo().getHours();
                    if (quest.getRepeatInfo().getType() == RepeatType.INTERVAL) {
                        if (total == 0 || this.hours % total != 0) continue;
                        quest.resetAll();
                        continue;
                    }
                    if (quest.getRepeatInfo().getType() != RepeatType.TIME) continue;
                    quest.resetOnTime(this.hours - total);
                }
            }
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.CLIENT, TickType.SERVER);
    }

    public String getLabel() {
        return "HQMQuest";
    }

    public int getHours() {
        return this.hours;
    }

    public void save(DataWriter dw) {
        dw.writeData(this.ticks, DataBitHelper.TICKS);
        dw.writeData(this.hours, DataBitHelper.HOURS);
    }

    public void load(DataReader dr) {
        this.ticks = dr.readData(DataBitHelper.TICKS);
        this.hours = dr.readData(DataBitHelper.HOURS);
    }
}

