/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.QuestingData;
import hardcorequesting.client.interfaces.GuiEditMenuItem;
import hardcorequesting.network.DataReader;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestDataTaskItems;
import hardcorequesting.quests.QuestTaskItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class QuestTaskItemsDetect
extends QuestTaskItems
implements ICraftingHandler {
    private boolean disabled;

    public QuestTaskItemsDetect(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
        MinecraftForge.EVENT_BUS.register((Object)this);
        GameRegistry.registerCraftingHandler((ICraftingHandler)this);
    }

    @Override
    public void onDelete() {
        super.onDelete();
        this.disabled = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiEditMenuItem.Type getMenuTypeId() {
        return GuiEditMenuItem.Type.CRAFTING_TASK;
    }

    @Override
    public void onUpdate(EntityPlayer player, DataReader dr) {
        this.countItems(player, null);
    }

    @ForgeSubscribe
    public void onPickUp(EntityItemPickupEvent event) {
        if (event.entityPlayer.field_71071_by.field_70459_e) {
            this.countItems(event.entityPlayer, event.item.func_92059_d());
        }
    }

    public void onCrafting(EntityPlayer player, ItemStack item, IInventory craftMatrix) {
        item = item.func_77946_l();
        if (item.field_77994_a == 0) {
            item.field_77994_a = 1;
        }
        this.countItems(player, item);
    }

    private void countItems(EntityPlayer player, ItemStack item) {
        ItemStack[] items;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (item == null) {
            items = player.field_71071_by.field_70462_a;
        } else {
            items = new ItemStack[player.field_71071_by.field_70462_a.length + 1];
            ItemStack[] mainInventory = player.field_71071_by.field_70462_a;
            for (int i = 0; i < mainInventory.length; ++i) {
                items[i] = mainInventory[i];
            }
            items[items.length - 1] = item;
        }
        this.countItems(items, (QuestDataTaskItems)this.getData(player), QuestingData.getUserName(player));
    }

    public void countItems(ItemStack[] itemsToCount, QuestDataTaskItems data, String playerName) {
        if (!this.parent.isAvailable(playerName) || this.disabled) {
            return;
        }
        boolean updated = false;
        for (int i = 0; i < this.items.length; ++i) {
            QuestTaskItems.ItemRequirement item = this.items[i];
            if (!item.hasItem || item.required == data.progress[i]) continue;
            for (ItemStack itemStack : itemsToCount) {
                if (!item.precision.areItemsSame(itemStack, item.item)) continue;
                int amount = Math.min(itemStack.field_77994_a, item.required - data.progress[i]);
                int n = i;
                data.progress[n] = data.progress[n] + amount;
                updated = true;
            }
        }
        if (updated) {
            this.doCompletionCheck(data, playerName);
        }
    }

    @Override
    protected void doCompletionCheck(QuestDataTaskItems data, String playerName) {
        boolean isDone = true;
        for (int i = 0; i < this.items.length; ++i) {
            QuestTaskItems.ItemRequirement item = this.items[i];
            if (item.required <= data.progress[i]) continue;
            data.progress[i] = 0;
            isDone = false;
        }
        if (isDone) {
            this.completeTask(playerName);
        }
        this.parent.sendUpdatedDataToTeam(playerName);
    }

    public void onSmelting(EntityPlayer player, ItemStack item) {
    }
}

