/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.FileVersion;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestDataTask;
import hardcorequesting.quests.QuestDataTaskDeath;
import hardcorequesting.quests.QuestTask;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class QuestTaskDeath
extends QuestTask {
    private int deaths;
    private boolean disabled;

    @Override
    public void onDelete() {
        super.onDelete();
        this.disabled = true;
    }

    public QuestTaskDeath(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @ForgeSubscribe
    public void onDeath(LivingDeathEvent event) {
        EntityPlayer player;
        if (!this.disabled && event.entityLiving instanceof EntityPlayerMP && this.parent.isEnabled(player = (EntityPlayer)event.entityLiving) && this.parent.isAvailable(player) && this.isVisible(player) && !this.isCompleted(player)) {
            QuestDataTaskDeath deathData = (QuestDataTaskDeath)this.getData(player);
            if (deathData.deaths < this.deaths) {
                ++deathData.deaths;
                if (deathData.deaths == this.deaths) {
                    this.completeTask(StringUtils.func_76338_a((String)player.field_71092_bJ));
                }
                this.parent.sendUpdatedDataToTeam(player);
            }
        }
    }

    @Override
    public void write(DataWriter dw, QuestDataTask task, boolean light) {
        super.write(dw, task, light);
        dw.writeData(((QuestDataTaskDeath)task).deaths, DataBitHelper.DEATHS);
    }

    @Override
    public void read(DataReader dr, QuestDataTask task, FileVersion version, boolean light) {
        super.read(dr, task, version, light);
        ((QuestDataTaskDeath)task).deaths = dr.readData(DataBitHelper.DEATHS);
    }

    @Override
    public void save(DataWriter dw) {
        dw.writeData(this.deaths, DataBitHelper.DEATHS);
    }

    @Override
    public void load(DataReader dr, FileVersion version) {
        this.deaths = dr.readData(DataBitHelper.DEATHS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        int died = ((QuestDataTaskDeath)this.getData((EntityPlayer)player)).deaths;
        gui.drawString(gui.getLinesFromText(died == this.deaths ? (Object)((Object)GuiColor.GREEN) + "You've died " + this.deaths + " " + (this.deaths > 1 ? "times" : "time") + "." : "You've died " + died + " of " + this.deaths + " " + (this.deaths > 1 ? "times" : "time"), 1.0f, 130), 180, 95, 1.0f, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
    }

    @Override
    public void onUpdate(EntityPlayer player, DataReader dr) {
    }

    @Override
    public float getCompletedRatio(String playerName) {
        return (float)((QuestDataTaskDeath)this.getData((String)playerName)).deaths / (float)this.deaths;
    }

    @Override
    public void mergeProgress(String playerName, QuestDataTask own, QuestDataTask other) {
        ((QuestDataTaskDeath)own).deaths = Math.max(((QuestDataTaskDeath)own).deaths, ((QuestDataTaskDeath)other).deaths);
        if (((QuestDataTaskDeath)own).deaths == this.deaths) {
            this.completeTask(playerName);
        }
    }

    @Override
    public void copyProgress(QuestDataTask own, QuestDataTask other) {
        super.copyProgress(own, other);
        ((QuestDataTaskDeath)own).deaths = ((QuestDataTaskDeath)other).deaths;
    }

    @Override
    public void autoComplete(String playerName) {
        this.deaths = ((QuestDataTaskDeath)this.getData((String)playerName)).deaths;
    }

    @Override
    public Class<? extends QuestDataTask> getDataType() {
        return QuestDataTaskDeath.class;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public void setDeaths(int deaths) {
        this.deaths = deaths;
    }
}

