/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.FileVersion;
import hardcorequesting.QuestingData;
import hardcorequesting.Team;
import hardcorequesting.bag.Group;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiEditMenuDeathTask;
import hardcorequesting.client.interfaces.GuiEditMenuItem;
import hardcorequesting.client.interfaces.GuiEditMenuTextEditor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.LargeButton;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.FileHelper;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.network.PacketId;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.QuestData;
import hardcorequesting.quests.QuestDataTask;
import hardcorequesting.quests.QuestLine;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.quests.QuestTask;
import hardcorequesting.quests.QuestTaskDeath;
import hardcorequesting.quests.QuestTaskItems;
import hardcorequesting.quests.QuestTaskItemsConsume;
import hardcorequesting.quests.QuestTaskItemsConsumeQDS;
import hardcorequesting.quests.QuestTaskItemsCrafting;
import hardcorequesting.quests.QuestTaskItemsDetect;
import hardcorequesting.quests.QuestTaskLocation;
import hardcorequesting.quests.QuestTaskMob;
import hardcorequesting.quests.QuestTicker;
import hardcorequesting.quests.RepeatInfo;
import hardcorequesting.quests.RepeatType;
import hardcorequesting.quests.TriggerType;
import java.awt.Polygon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class Quest {
    public static boolean isEditing = false;
    public static int selectedQuestId;
    public static QuestTicker clientTicker;
    public static QuestTicker serverTicker;
    private short id;
    private String name;
    private String description;
    private List<Quest> requirement;
    private List<Integer> requirementIds;
    private List<Quest> reversedRequirement;
    private List<Quest> optionLinks;
    private List<Integer> optionLinkIds;
    private List<Quest> reversedOptionLinks;
    private List<QuestTask> tasks;
    private List<String> cachedDescription;
    int nextTaskId;
    private QuestTask selectedTask;
    private ItemStack[] reward;
    private ItemStack[] rewardChoice;
    private RepeatInfo repeatInfo = new RepeatInfo(RepeatType.NONE, 0, 0);
    private TriggerType triggerType = TriggerType.NONE;
    private int triggerTasks = 1;
    private int x;
    private int y;
    private boolean isBig;
    private ItemStack icon;
    private QuestSet set;
    private int selectedReward = -1;
    private final List<LargeButton> buttons = new ArrayList<LargeButton>();
    private Quest self;
    private final ScrollBar descriptionScroll;
    private final ScrollBar taskDescriptionScroll;
    private final ScrollBar taskScroll;
    private final List<ScrollBar> scrollBars;
    private static final int VISIBLE_DESCRIPTION_LINES = 7;
    private static final int VISIBLE_TASKS = 3;
    private static final int START_X = 20;
    private static final int TEXT_HEIGHT = 9;
    private static final int TASK_LABEL_START_Y = 100;
    private static final int TASK_MARGIN = 2;
    private static final int TITLE_START_Y = 15;
    private static final int DESCRIPTION_START_Y = 30;
    private static final int TASK_DESCRIPTION_X = 180;
    private static final int TASK_DESCRIPTION_Y = 20;
    private static final int REWARD_STR_Y = 140;
    private static final int REWARD_Y = 150;
    private static final int REWARD_Y_OFFSET = 40;
    private static final int REWARD_OFFSET = 20;
    private static final int ITEM_SIZE = 18;
    private static final TaskType[] taskTypes;
    public static FileHelper FILE_HELPER;

    public static Collection<Quest> getQuests() {
        return QuestLine.getActiveQuestLine().quests.values();
    }

    public static List<QuestSet> getQuestSets() {
        return QuestLine.getActiveQuestLine().questSets;
    }

    public static int size() {
        return QuestLine.getActiveQuestLine().questCount;
    }

    public Quest(int id, String name, String description, int x, int y, boolean isBig) {
        this.buttons.add(new LargeButton("Claim reward", 100, 190){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return Quest.this.canPlayerClaimReward(player);
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.hasReward(player);
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                DataWriter dw = PacketHandler.getWriter(PacketId.CLAIM_REWARD);
                dw.writeData((int)Quest.this.getId(), DataBitHelper.QUESTS);
                if (Quest.this.rewardChoice != null) {
                    dw.writeData(Quest.this.selectedReward, DataBitHelper.REWARDS);
                }
                PacketHandler.sendToServer(dw);
            }
        });
        this.buttons.add(new LargeButton("Manual submit", 185, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return ((QuestTaskItemsConsume)Quest.this.selectedTask).allowManual();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskItemsConsume && !Quest.this.selectedTask.isCompleted(player);
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                PacketHandler.sendToServer(Quest.this.selectedTask.getWriterForTask(PacketId.TASK_REQUEST));
            }
        });
        this.buttons.add(new LargeButton("Manual detect", 185, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskItemsDetect && !Quest.this.selectedTask.isCompleted(player);
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                PacketHandler.sendToServer(Quest.this.selectedTask.getWriterForTask(PacketId.TASK_REQUEST));
            }
        });
        this.buttons.add(new LargeButton("Requirement", 185, 200){

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskDeath && isEditing;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onClick(GuiBase gui, EntityPlayer player) {
                gui.setEditMenu(new GuiEditMenuDeathTask(gui, player, (QuestTaskDeath)Quest.this.selectedTask));
            }
        });
        this.buttons.add(new LargeButton("Select task", 250, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return QuestingData.getQuestingData((EntityPlayer)player).selectedQuest != Quest.this.getId() || QuestingData.getQuestingData((EntityPlayer)player).selectedTask != Quest.this.selectedTask.getId();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskItemsConsume && !Quest.this.selectedTask.isCompleted(player);
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                QuestingData.getQuestingData((EntityPlayer)player).selectedQuest = Quest.this.getId();
                QuestingData.getQuestingData((EntityPlayer)player).selectedTask = Quest.this.selectedTask.getId();
                PacketHandler.sendToServer(Quest.this.selectedTask.getWriterForTask(PacketId.SELECT_TASK));
            }
        });
        int itemIds = 0;
        for (int i = 0; i < taskTypes.length; ++i) {
            final TaskType taskType = taskTypes[i];
            this.buttons.add(new LargeButton(taskType.name, taskType.description, 185 + i % 2 * 65, 50 + i / 2 * 35){

                @Override
                public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                    return Quest.this.tasks.size() < DataBitHelper.TASKS.getMaximum();
                }

                @Override
                public boolean isVisible(GuiBase gui, EntityPlayer player) {
                    return isEditing && Quest.this.selectedTask == null && ((GuiQuestBook)gui).getCurrentMode() == GuiQuestBook.EditMode.TASK;
                }

                @Override
                public void onClick(GuiBase gui, EntityPlayer player) {
                    QuestTask prev = Quest.this.tasks.size() > 0 ? (QuestTask)Quest.this.tasks.get(Quest.this.tasks.size() - 1) : null;
                    Class clazz = taskType.clazz;
                    try {
                        Constructor constructor = clazz.getConstructor(Quest.class, String.class, String.class);
                        QuestTask task = (QuestTask)constructor.newInstance(Quest.this.self, taskType.name, taskType.description);
                        if (prev != null) {
                            task.addRequirement(prev);
                        }
                        Quest.this.tasks.add(task);
                        Quest.this.addTaskData(Quest.this.getQuestData(player));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            if (!QuestTaskItems.class.isAssignableFrom(taskType.clazz)) continue;
            this.buttons.add(new LargeButton(taskType.name, taskType.description, 185 + itemIds % 2 * 65, 50 + itemIds / 2 * 35){

                @Override
                public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                    return Quest.this.selectedTask instanceof QuestTaskItems;
                }

                @Override
                public boolean isVisible(GuiBase gui, EntityPlayer player) {
                    return isEditing && Quest.this.selectedTask != null && ((GuiQuestBook)gui).getCurrentMode() == GuiQuestBook.EditMode.CHANGE_TASK;
                }

                @Override
                public void onClick(GuiBase gui, EntityPlayer player) {
                    TaskType oldTaskType = null;
                    for (TaskType type : taskTypes) {
                        if (!type.clazz.equals(Quest.this.selectedTask.getClass())) continue;
                        oldTaskType = type;
                        break;
                    }
                    if (oldTaskType == null) {
                        return;
                    }
                    --Quest.this.nextTaskId;
                    Class clazz = taskType.clazz;
                    try {
                        Constructor constructor = clazz.getConstructor(Quest.class, String.class, String.class);
                        QuestTask task = (QuestTask)constructor.newInstance(Quest.this.self, taskType.name, taskType.description);
                        for (QuestTask questTask : Quest.this.selectedTask.getRequirements()) {
                            task.addRequirement(questTask);
                        }
                        for (QuestTask questTask : Quest.this.tasks) {
                            List<QuestTask> requirements = questTask.getRequirements();
                            for (int j = 0; j < requirements.size(); ++j) {
                                if (!requirements.get(j).equals(Quest.this.selectedTask)) continue;
                                requirements.set(j, task);
                            }
                        }
                        for (int j = 0; j < Quest.this.tasks.size(); ++j) {
                            if (!((QuestTask)Quest.this.tasks.get(j)).equals(Quest.this.selectedTask)) continue;
                            Quest.this.tasks.set(j, task);
                            break;
                        }
                        if (!Quest.this.selectedTask.getDescription().equals(oldTaskType.name)) {
                            task.setDescription(Quest.this.selectedTask.getDescription());
                        }
                        if (!Quest.this.selectedTask.getLongDescription().equals(oldTaskType.description)) {
                            task.setLongDescription(Quest.this.selectedTask.getLongDescription());
                        }
                        ((QuestTaskItems)task).setItems(((QuestTaskItems)Quest.this.selectedTask).getItems());
                        task.setId(Quest.this.selectedTask.getId());
                        Quest.this.selectedTask = task;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            ++itemIds;
        }
        this.self = this;
        this.scrollBars = new ArrayList<ScrollBar>();
        this.descriptionScroll = new ScrollBar(155, 28, 64, 249, 102, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return Quest.this.getCachedDescription(gui).size() > 7;
            }
        };
        this.scrollBars.add(this.descriptionScroll);
        this.taskDescriptionScroll = new ScrollBar(312, 18, 64, 249, 102, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask.getCachedLongDescription(gui).size() > 7;
            }
        };
        this.scrollBars.add(this.taskDescriptionScroll);
        this.taskScroll = new ScrollBar(155, 100, 29, 242, 102, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return Quest.this.tasks.size() > 3 && Quest.this.getVisibleTasks(gui) > 3;
            }
        };
        this.scrollBars.add(this.taskScroll);
        this.id = (short)id;
        this.name = name;
        this.x = x;
        this.y = y;
        this.isBig = isBig;
        this.description = description;
        this.requirement = new ArrayList<Quest>();
        this.reversedRequirement = new ArrayList<Quest>();
        this.optionLinks = new ArrayList<Quest>();
        this.reversedOptionLinks = new ArrayList<Quest>();
        this.tasks = new ArrayList<QuestTask>();
        QuestLine.getActiveQuestLine().quests.put(this.id, this);
        if (this.id >= QuestLine.getActiveQuestLine().questCount) {
            QuestLine.getActiveQuestLine().questCount = this.id + 1;
        }
    }

    public RepeatInfo getRepeatInfo() {
        return this.repeatInfo;
    }

    public void setRepeatInfo(RepeatInfo repeatInfo) {
        this.repeatInfo = repeatInfo;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getMainDescription(GuiBase gui) {
        if (QuestLine.getActiveQuestLine().cachedMainDescription == null) {
            QuestLine.getActiveQuestLine().cachedMainDescription = gui.getLinesFromText(QuestLine.getActiveQuestLine().mainDescription, 0.7f, 130);
        }
        return QuestLine.getActiveQuestLine().cachedMainDescription;
    }

    public static String getRawMainDescription() {
        return QuestLine.getActiveQuestLine().mainDescription;
    }

    public static void setMainDescription(String mainDescription) {
        QuestLine.getActiveQuestLine().mainDescription = mainDescription;
        QuestLine.getActiveQuestLine().cachedMainDescription = null;
    }

    public void addRequirement(int id) {
        for (Quest quest : this.requirement) {
            if (quest.id != id) continue;
            return;
        }
        for (Quest quest : this.reversedRequirement) {
            if (quest.id != id) continue;
            return;
        }
        Quest quest = QuestLine.getActiveQuestLine().quests.get((short)id);
        if (quest != null) {
            this.requirement.add(quest);
            quest.reversedRequirement.add(this);
        }
    }

    public void clearRequirements() {
        for (Quest quest : this.requirement) {
            quest.reversedRequirement.remove(this);
        }
        this.requirement.clear();
    }

    public void addOptionLink(int id) {
        for (Quest quest : this.optionLinks) {
            if (quest.id != id) continue;
            return;
        }
        for (Quest quest : this.reversedOptionLinks) {
            if (quest.id != id) continue;
            return;
        }
        Quest quest = QuestLine.getActiveQuestLine().quests.get((short)id);
        if (quest != null) {
            this.optionLinks.add(quest);
            quest.reversedOptionLinks.add(this);
        }
    }

    public void clearOptionLinks() {
        for (Quest quest : this.reversedOptionLinks) {
            quest.optionLinks.remove(this);
        }
        for (Quest quest : this.optionLinks) {
            quest.reversedOptionLinks.remove(this);
        }
        this.reversedRequirement.clear();
        this.optionLinks.clear();
    }

    public QuestData getQuestData(EntityPlayer player) {
        return QuestingData.getQuestingData(player).getQuestData(this.id);
    }

    public QuestData getQuestData(String playerName) {
        return QuestingData.getQuestingData(playerName).getQuestData(this.id);
    }

    public short getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible(EntityPlayer player) {
        return this.isVisible(QuestingData.getUserName(player));
    }

    public boolean isVisible(String playerName) {
        if (!this.triggerType.isQuestVisible(this, playerName)) {
            return false;
        }
        if (!this.isLinkFree(playerName)) {
            return false;
        }
        for (Quest quest : this.getRequirement()) {
            if (quest.isVisible(playerName) || quest.isCompleted(playerName)) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabled(EntityPlayer player) {
        return this.isEnabled(QuestingData.getUserName(player));
    }

    public boolean isEnabled(String playerName) {
        return this.isEnabled(playerName, true);
    }

    public boolean isLinkFree(EntityPlayer player) {
        return this.isLinkFree(QuestingData.getUserName(player));
    }

    public boolean isLinkFree(String playerName) {
        for (Quest optionLink : this.optionLinks) {
            if (!optionLink.isCompleted(playerName)) continue;
            return false;
        }
        for (Quest optionLink : this.reversedOptionLinks) {
            if (!optionLink.isCompleted(playerName)) continue;
            return false;
        }
        for (Quest quest : this.requirement) {
            if (quest.isLinkFree(playerName)) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabled(String playerName, boolean requiresVisible) {
        if (this.set == null || !this.isLinkFree(playerName) || requiresVisible && !this.triggerType.doesWorkAsInvisible() && !this.isVisible(playerName)) {
            return false;
        }
        for (Quest quest : this.getRequirement()) {
            if (quest.isCompleted(playerName)) continue;
            return false;
        }
        return true;
    }

    public boolean isAvailable(EntityPlayer player) {
        return this.isAvailable(QuestingData.getUserName(player));
    }

    public boolean isCompleted(EntityPlayer player) {
        return this.isCompleted(QuestingData.getUserName(player));
    }

    public boolean isAvailable(String playerName) {
        QuestData data = this.getQuestData(playerName);
        return data != null && data.available;
    }

    public boolean isCompleted(String playerName) {
        QuestData data = this.getQuestData(playerName);
        return data != null && data.completed;
    }

    public List<Quest> getRequirement() {
        return this.requirement;
    }

    public int getGuiX() {
        return this.x;
    }

    public int getGuiY() {
        return this.y;
    }

    public int getGuiU() {
        return this.isBig ? 195 : 170;
    }

    public int getGuiV(EntityPlayer player, int x, int y) {
        return this.isEnabled(player) && this.isMouseInObject(x, y) ? this.getGuiH() : 0;
    }

    public int getGuiW() {
        return this.isBig ? 31 : 25;
    }

    public int getGuiH() {
        return this.isBig ? 37 : 30;
    }

    public int getGuiCenterX() {
        return this.getGuiX() + this.getGuiW() / 2;
    }

    public int getGuiCenterY() {
        return this.getGuiY() + this.getGuiH() / 2;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public boolean useBigIcon() {
        return this.isBig;
    }

    public void setTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public void setTriggerTasks(int triggerTasks) {
        this.triggerTasks = triggerTasks;
    }

    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public int getTriggerTasks() {
        return this.triggerTasks;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFilter(EntityPlayer player, int tick) {
        if (isEditing && !this.isVisible(player)) {
            return 0x55FFFFFF;
        }
        if (!this.isEnabled(player)) {
            return -7829368;
        }
        if (!this.isAvailable(player) && !this.hasReward(player)) {
            return this.getRepeatInfo().getType() == RepeatType.NONE ? -1 : -52;
        }
        int componentBase = 187;
        int componentVariable = (int)(Math.abs(Math.sin((float)tick / 5.0f)) * 68.0);
        int component = componentBase + componentVariable;
        int red = this.hasReward(player) ? componentBase : component;
        int green = this.hasReward(player) ? component * 3 / 4 : component;
        int blue = component;
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isMouseInObject(int x, int y) {
        if (this.getGuiX() > x || x > this.getGuiX() + this.getGuiW() || this.getGuiY() > y || y > this.getGuiY() + this.getGuiH()) {
            return false;
        }
        Polygon poly = new Polygon();
        if (this.isBig) {
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 10);
            poly.addPoint(this.getGuiX() + 15, this.getGuiY() + 1);
            poly.addPoint(this.getGuiX() + 30, this.getGuiY() + 10);
            poly.addPoint(this.getGuiX() + 30, this.getGuiY() + 27);
            poly.addPoint(this.getGuiX() + 15, this.getGuiY() + 36);
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 27);
        } else {
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 12, this.getGuiY() + 2);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 21);
            poly.addPoint(this.getGuiX() + 12, this.getGuiY() + 27);
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 21);
        }
        return poly.contains(x, y);
    }

    public static Quest getQuest(int id) {
        return QuestLine.getActiveQuestLine().quests.get((short)id);
    }

    @SideOnly(value=Side.CLIENT)
    private List<String> getCachedDescription(GuiBase gui) {
        if (this.cachedDescription == null) {
            this.cachedDescription = gui.getLinesFromText(this.description, 0.7f, 130);
        }
        return this.cachedDescription;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawMenu(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        if (!isEditing && this.selectedTask != null && !this.selectedTask.isVisible(player)) {
            this.selectedTask = this.tasks.size() > 0 ? this.tasks.get(0) : null;
        }
        gui.drawString(this.name, 20, 15, 0x404040);
        int startLine = this.descriptionScroll.isVisible(gui) ? Math.round((float)(this.getCachedDescription(gui).size() - 7) * this.descriptionScroll.getScroll()) : 0;
        gui.drawString(this.getCachedDescription(gui), startLine, 7, 20, 30, 0.7f, 0x404040);
        int id = 0;
        int start = this.taskScroll.isVisible(gui) ? Math.round((float)(this.getVisibleTasks(gui) - 3) * this.taskScroll.getScroll()) : 0;
        int end = Math.min(start + 3, this.tasks.size());
        for (int i = start; i < end; ++i) {
            QuestTask task = this.tasks.get(i);
            boolean isVisible = task.isVisible(player);
            if (!isVisible && !isEditing) continue;
            boolean completed = task.isCompleted(player);
            int yPos = this.getTaskY(gui, id);
            boolean inBounds = gui.inBounds(20, yPos, gui.getStringWidth(task.getDescription()), 9, mX, mY);
            boolean isSelected = task == this.selectedTask;
            gui.drawString(task.getDescription(), 20, yPos, completed ? (isSelected ? (inBounds ? 0x40BB40 : 0x40A040) : (inBounds ? 0x10A010 : 0x107010)) : (isSelected ? (inBounds ? 0xAAAAAA : 0x888888) : (inBounds ? 0x666666 : (isVisible ? 0x404040 : 0xDDDDDD))));
            ++id;
        }
        if (this.selectedReward != -1 && !this.hasReward(player)) {
            this.selectedReward = -1;
        }
        if (this.reward != null || isEditing) {
            gui.drawString("Rewards", 20, 140, 0x404040);
            this.drawRewards(gui, this.reward, 150, -1, mX, mY);
            if (this.rewardChoice != null || isEditing) {
                gui.drawString("Pick one", 20, 180, 0x404040);
                this.drawRewards(gui, this.rewardChoice, 190, this.selectedReward, mX, mY);
            }
        } else if (this.rewardChoice != null) {
            gui.drawString("Pick one reward", 20, 140, 0x404040);
            this.drawRewards(gui, this.rewardChoice, 150, this.selectedReward, mX, mY);
        }
        for (LargeButton button : this.buttons) {
            button.draw(gui, player, mX, mY);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.draw(gui);
        }
        if (this.selectedTask != null) {
            if (isEditing && gui.getCurrentMode() == GuiQuestBook.EditMode.CHANGE_TASK) {
                if (this.selectedTask instanceof QuestTaskItems) {
                    gui.drawString(gui.getLinesFromText("Click on the item task type you want to change to.", 0.7f, 130), 180, 20, 0.7f, 0x404040);
                } else {
                    gui.drawString(gui.getLinesFromText("You can only change the type of item tasks.", 0.7f, 130), 180, 20, 0.7f, 0x404040);
                }
            } else {
                List<String> description = this.selectedTask.getCachedLongDescription(gui);
                int taskStartLine = this.taskDescriptionScroll.isVisible(gui) ? Math.round((float)(description.size() - 7) * this.taskDescriptionScroll.getScroll()) : 0;
                gui.drawString(description, taskStartLine, 7, 180, 20, 0.7f, 0x404040);
                this.selectedTask.draw(gui, player, mX, mY);
            }
        } else if (isEditing && gui.getCurrentMode() == GuiQuestBook.EditMode.TASK) {
            gui.drawString(gui.getLinesFromText("Create tasks of different types by using the buttons below", 0.7f, 130), 180, 20, 0.7f, 0x404040);
        } else if (isEditing && gui.getCurrentMode() == GuiQuestBook.EditMode.CHANGE_TASK) {
            gui.drawString(gui.getLinesFromText("Select an item task you want to change the type of.", 0.7f, 130), 180, 20, 0.7f, 0x404040);
        }
        if (this.reward != null || isEditing) {
            this.drawRewardMouseOver(gui, this.reward, 150, -1, mX, mY);
            if (this.rewardChoice != null || isEditing) {
                this.drawRewardMouseOver(gui, this.rewardChoice, 190, this.selectedReward, mX, mY);
            }
        } else if (this.rewardChoice != null) {
            this.drawRewardMouseOver(gui, this.rewardChoice, 150, this.selectedReward, mX, mY);
        }
        for (LargeButton button : this.buttons) {
            button.drawMouseOver(gui, player, mX, mY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int getVisibleTasks(GuiBase gui) {
        if (isEditing) {
            return this.tasks.size();
        }
        int count = 0;
        for (QuestTask task : this.tasks) {
            if (!task.isVisible(((GuiQuestBook)gui).getPlayer())) continue;
            ++count;
        }
        return count;
    }

    private boolean canPlayerClaimReward(EntityPlayer player) {
        return this.hasReward(player) && (this.reward != null && this.rewardChoice == null || this.rewardChoice != null && this.selectedReward != -1) && this.isEnabled(player);
    }

    public boolean hasReward(EntityPlayer player) {
        return this.getQuestData(player).getReward(player) && (this.reward != null || this.rewardChoice != null);
    }

    @SideOnly(value=Side.CLIENT)
    private void drawRewards(GuiQuestBook gui, ItemStack[] rewards, int y, int selected, int mX, int mY) {
        rewards = this.getEditFriendlyRewards(rewards);
        for (int i = 0; i < rewards.length; ++i) {
            gui.drawItem(rewards[i], 20 + i * 20, y, mX, mY, selected == i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawRewardMouseOver(GuiQuestBook gui, ItemStack[] rewards, int y, int selected, int mX, int mY) {
        if (rewards != null) {
            for (int i = 0; i < rewards.length; ++i) {
                if (!gui.inBounds(20 + i * 20, y, 18, 18, mX, mY)) continue;
                if (rewards[i] == null) break;
                List<String> str = new ArrayList<String>();
                try {
                    if (isEditing && !GuiQuestBook.func_73861_o()) {
                        str = rewards[i].func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                        str.add("");
                        str.add((Object)((Object)GuiColor.GRAY) + "Hold Ctrl to see this as a non-editor.");
                    } else {
                        str.add(rewards[i].func_82833_r());
                    }
                }
                catch (Throwable ignored) {
                    break;
                }
                if (selected == i) {
                    str.add((Object)((Object)GuiColor.GREEN) + "Selected");
                }
                gui.drawMouseOver(str, gui.getLeft() + mX, gui.getTop() + mY);
                break;
            }
        }
    }

    private ItemStack[] getEditFriendlyRewards(ItemStack[] rewards) {
        if (rewards == null) {
            return new ItemStack[1];
        }
        if (isEditing && rewards.length < DataBitHelper.REWARDS.getMaximum()) {
            return Arrays.copyOf(rewards, rewards.length + 1);
        }
        return rewards;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleRewardClick(GuiQuestBook gui, EntityPlayer player, ItemStack[] rawRewards, int y, boolean canSelect, int mX, int mY) {
        ItemStack[] rewards = this.getEditFriendlyRewards(rawRewards);
        for (int i = 0; i < rewards.length; ++i) {
            ItemStack[] newRewards;
            if (!gui.inBounds(20 + i * 20, y, 18, 18, mX, mY)) continue;
            if (canSelect && (!isEditing || gui.getCurrentMode() == GuiQuestBook.EditMode.NORMAL)) {
                if (this.selectedReward == i) {
                    this.selectedReward = -1;
                    break;
                }
                if (rewards[i] == null) break;
                this.selectedReward = i;
                break;
            }
            if (isEditing && gui.getCurrentMode() == GuiQuestBook.EditMode.ITEM) {
                gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, player, rewards[i], i, canSelect ? GuiEditMenuItem.Type.PICK_REWARD : GuiEditMenuItem.Type.REWARD, rewards[i] == null ? 1 : rewards[i].field_77994_a, ItemPrecision.PRECISE));
                break;
            }
            if (!isEditing || gui.getCurrentMode() != GuiQuestBook.EditMode.DELETE || rewards[i] == null) break;
            if (rawRewards.length == 1) {
                newRewards = null;
                if (canSelect) {
                    this.selectedReward = -1;
                }
            } else {
                newRewards = new ItemStack[rawRewards.length - 1];
                int id = 0;
                for (int j = 0; j < rawRewards.length; ++j) {
                    if (j == i) continue;
                    newRewards[id] = rawRewards[j];
                    ++id;
                }
                if (canSelect && this.selectedReward != -1) {
                    if (this.selectedReward == i) {
                        this.selectedReward = -1;
                    } else if (this.selectedReward > i) {
                        --this.selectedReward;
                    }
                }
            }
            if (canSelect) {
                this.rewardChoice = newRewards;
                break;
            }
            this.reward = newRewards;
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int getTaskY(GuiQuestBook gui, int id) {
        return 100 + id * 11;
    }

    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        if (b == 1) {
            gui.loadMap();
        } else {
            int id = 0;
            int start = this.taskScroll.isVisible(gui) ? Math.round((float)(this.getVisibleTasks(gui) - 3) * this.taskScroll.getScroll()) : 0;
            int end = Math.min(start + 3, this.tasks.size());
            for (int i = start; i < end; ++i) {
                QuestTask task = this.tasks.get(i);
                if (!task.isVisible(player) && !isEditing) continue;
                if (gui.inBounds(20, this.getTaskY(gui, id), gui.getStringWidth(task.getDescription()), 9, mX, mY)) {
                    if (isEditing && gui.getCurrentMode() != GuiQuestBook.EditMode.NORMAL) {
                        if (gui.getCurrentMode() == GuiQuestBook.EditMode.RENAME) {
                            gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, task, true));
                            break;
                        }
                        if (gui.getCurrentMode() != GuiQuestBook.EditMode.DELETE) break;
                        if (i + 1 < this.tasks.size()) {
                            this.tasks.get(i + 1).clearRequirements();
                            if (i > 0) {
                                this.tasks.get(i + 1).addRequirement(this.tasks.get(i - 1));
                            }
                        }
                        if (this.selectedTask == task) {
                            this.selectedTask = null;
                        }
                        task.onDelete();
                        this.tasks.remove(i);
                        this.nextTaskId = 0;
                        for (QuestTask questTask : this.tasks) {
                            questTask.updateId();
                        }
                        this.addTaskData(this.getQuestData(player));
                        break;
                    }
                    if (task == this.selectedTask) {
                        this.selectedTask = null;
                        break;
                    }
                    this.selectedTask = task;
                    this.taskDescriptionScroll.resetScroll();
                    break;
                }
                ++id;
            }
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onClick(gui, mX, mY);
            }
            if (this.reward != null || isEditing) {
                this.handleRewardClick(gui, player, this.reward, 150, false, mX, mY);
                if (this.rewardChoice != null || isEditing) {
                    this.handleRewardClick(gui, player, this.rewardChoice, 190, true, mX, mY);
                }
            } else if (this.rewardChoice != null) {
                this.handleRewardClick(gui, player, this.rewardChoice, 150, true, mX, mY);
            }
            if (this.selectedTask != null) {
                this.selectedTask.onClick(gui, player, mX, mY, b);
            }
            for (LargeButton button : this.buttons) {
                if (!button.inButtonBounds(gui, mX, mY) || !button.isVisible(gui, player) || !button.isEnabled(gui, player)) continue;
                button.onClick(gui, player);
                break;
            }
            if (gui.getCurrentMode() == GuiQuestBook.EditMode.RENAME) {
                if (gui.inBounds(20, 15, 140, 9, mX, mY)) {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this, true));
                } else if (gui.inBounds(20, 30, 130, 44, mX, mY)) {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this, false));
                } else if (this.selectedTask != null && gui.inBounds(180, 20, 130, 44, mX, mY)) {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this.selectedTask, false));
                }
            }
            if (isEditing && this.selectedTask != null && gui.getCurrentMode() == GuiQuestBook.EditMode.TASK) {
                this.selectedTask = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onDrag(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onDrag(gui, mX, mY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onRelease(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onRelease(gui, mX, mY);
        }
    }

    public QuestData createData(int players) {
        QuestData data = new QuestData(players);
        if (!this.addTaskData(data)) {
            return null;
        }
        return data;
    }

    private boolean addTaskData(QuestData data) {
        data.tasks = new QuestDataTask[this.tasks.size()];
        for (int i = 0; i < this.tasks.size(); ++i) {
            try {
                QuestDataTask obj;
                Constructor<? extends QuestDataTask> constructor = this.tasks.get(i).getDataType().getConstructor(QuestTask.class);
                data.tasks[i] = obj = constructor.newInstance(this.tasks.get(i));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void save(DataWriter dw, QuestData questData, boolean light) {
        dw.writeBoolean(questData.completed);
        dw.writeBoolean(questData.available);
        dw.writeData(questData.time, DataBitHelper.HOURS);
        if (questData.completed) {
            for (boolean b : questData.reward) {
                dw.writeBoolean(b);
            }
        }
        if (light) {
            for (int i = 0; i < this.tasks.size(); ++i) {
                QuestTask task = this.tasks.get(i);
                questData.tasks[i] = task.validateData(questData.tasks[i]);
                task.write(dw, questData.tasks[i], true);
            }
        } else {
            dw.writeData(this.tasks.size(), DataBitHelper.TASKS);
            for (int i = 0; i < this.tasks.size(); ++i) {
                for (int j = 0; j < taskTypes.length; ++j) {
                    TaskType taskType = taskTypes[j];
                    if (taskType.clazz != this.tasks.get(i).getClass()) continue;
                    dw.writeData(j, DataBitHelper.TASK_TYPE);
                    break;
                }
                QuestTask task = this.tasks.get(i);
                questData.tasks[i] = task.validateData(questData.tasks[i]);
                task.write(dw, questData.tasks[i], false);
            }
        }
    }

    public void preRead(int players, QuestData data) {
        data.reward = new boolean[players];
    }

    public void read(DataReader dr, QuestData questData, FileVersion version, boolean light) {
        int i;
        questData.completed = dr.readBoolean();
        if (version.contains(FileVersion.REPEATABLE_QUESTS)) {
            questData.available = dr.readBoolean();
            questData.time = dr.readData(DataBitHelper.HOURS);
            if (questData.completed && this.repeatInfo.getType() == RepeatType.NONE) {
                questData.available = false;
            }
        } else if (this.repeatInfo.getType() != RepeatType.INSTANT) {
            boolean bl = questData.available = !questData.completed;
        }
        if (questData.completed) {
            for (i = 0; i < questData.reward.length; ++i) {
                questData.reward[i] = version.contains(FileVersion.REPEATABLE_QUESTS) ? dr.readBoolean() : !dr.readBoolean() && questData.completed;
            }
        }
        if (light) {
            for (i = 0; i < this.tasks.size(); ++i) {
                QuestTask task = this.tasks.get(i);
                questData.tasks[i] = task.validateData(questData.tasks[i]);
                task.read(dr, questData.tasks[i], version, true);
            }
        } else {
            int count = dr.readData(DataBitHelper.TASKS);
            for (int i2 = 0; i2 < count; ++i2) {
                int type = dr.readData(DataBitHelper.TASK_TYPE);
                if (i2 >= this.tasks.size()) {
                    try {
                        Class clazz = taskTypes[type].clazz;
                        Constructor constructor = clazz.getConstructor(Quest.class, String.class, String.class);
                        Object obj = constructor.newInstance(this, "Fake", "Fake");
                        QuestTask task = (QuestTask)obj;
                        --this.nextTaskId;
                        Constructor<? extends QuestDataTask> constructor2 = task.getDataType().getConstructor(QuestTask.class);
                        QuestDataTask obj2 = constructor2.newInstance(task);
                        task.read(dr, obj2, version, false);
                        task.onDelete();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                QuestTask task = this.tasks.get(i2);
                questData.tasks[i2] = task.validateData(questData.tasks[i2]);
                task.read(dr, questData.tasks[i2], version, false);
            }
        }
    }

    public void postRead(QuestingData questingData, QuestData questData, FileVersion version) {
        String name = questingData.getName();
        if (version.lacks(FileVersion.UNCOMPLETED_DISABLED)) {
            if (this.isCompleted(name) && !this.isEnabled(name)) {
                questData.completed = false;
            }
        } else {
            boolean update = false;
            for (QuestTask task : this.tasks) {
                if (task.isCompleted(name)) {
                    task.autoComplete(name);
                    continue;
                }
                if (!(task.getCompletedRatio(name) >= 1.0f)) continue;
                task.autoComplete(name);
                task.completeTask(name);
                update = true;
            }
            if (update) {
                QuestTask.completeQuest(this, name);
            }
        }
    }

    public List<QuestTask> getTasks() {
        return this.tasks;
    }

    public void sendUpdatedDataToTeam(EntityPlayer player) {
        this.sendUpdatedDataToTeam(QuestingData.getQuestingData(player).getTeam());
    }

    public void sendUpdatedDataToTeam(String playerName) {
        this.sendUpdatedDataToTeam(QuestingData.getQuestingData(playerName).getTeam());
    }

    public void sendUpdatedDataToTeam(Team team) {
        for (Team.PlayerEntry entry : team.getPlayers()) {
            if (!entry.shouldRefreshData()) continue;
            this.sendUpdatedData(entry.getName());
        }
    }

    private void sendUpdatedData(String playerName) {
        DataWriter dw = PacketHandler.getWriter(PacketId.QUEST_DATA);
        dw.writeData((int)this.id, DataBitHelper.QUESTS);
        dw.writeData(QuestingData.getQuestingData(playerName).getTeam().getPlayerCount(), DataBitHelper.PLAYERS);
        this.save(dw, this.getQuestData(playerName), true);
        PacketHandler.sendToPlayer(playerName, dw);
    }

    public void claimReward(EntityPlayer player, DataReader dr) {
        if (this.hasReward(player)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (this.reward != null) {
                for (ItemStack itemStack : this.reward) {
                    items.add(itemStack.func_77946_l());
                }
            }
            if (this.rewardChoice != null) {
                int id = dr.readData(DataBitHelper.REWARDS);
                if (id >= 0 && id < this.rewardChoice.length) {
                    items.add(this.rewardChoice[id].func_77946_l());
                } else {
                    return;
                }
            }
            ArrayList<ItemStack> itemsToAdd = new ArrayList<ItemStack>();
            for (ItemStack item : items) {
                boolean added = false;
                for (ItemStack itemStack : itemsToAdd) {
                    if (!item.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)item, (ItemStack)itemStack)) continue;
                    itemStack.field_77994_a += item.field_77994_a;
                    added = true;
                    break;
                }
                if (added) continue;
                itemsToAdd.add(item.func_77946_l());
            }
            ArrayList<ItemStack> itemsToCheck = new ArrayList<ItemStack>();
            for (ItemStack itemStack : itemsToAdd) {
                itemsToCheck.add(itemStack.func_77946_l());
            }
            block4: for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                for (ItemStack itemStack : itemsToCheck) {
                    if (itemStack.field_77994_a <= 0) continue;
                    if (player.field_71071_by.field_70462_a[i] == null) {
                        itemStack.field_77994_a -= itemStack.func_77976_d();
                        continue block4;
                    }
                    if (!player.field_71071_by.field_70462_a[i].func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)player.field_71071_by.field_70462_a[i])) continue;
                    itemStack.field_77994_a -= itemStack.func_77976_d() - player.field_71071_by.field_70462_a[i].field_77994_a;
                    continue block4;
                }
            }
            boolean valid = true;
            for (ItemStack itemStack : itemsToCheck) {
                if (itemStack.field_77994_a <= 0) continue;
                valid = false;
                break;
            }
            if (valid) {
                Quest.addItems(player, itemsToAdd);
                player.field_71071_by.func_70296_d();
                QuestData data = this.getQuestData(player);
                Team team = QuestingData.getQuestingData(player).getTeam();
                if (!team.isSingle() && team.getRewardSetting() == Team.RewardSetting.ANY) {
                    for (int i = 0; i < data.reward.length; ++i) {
                        data.reward[i] = false;
                    }
                    this.sendUpdatedDataToTeam(player);
                } else {
                    data.claimReward(player);
                    this.sendUpdatedData(QuestingData.getUserName(player));
                }
                SoundHandler.play(Sounds.COMPLETE, player);
            }
        }
    }

    public static void addItems(EntityPlayer player, List<ItemStack> itemsToAdd) {
        block0: for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            Iterator<ItemStack> iterator = itemsToAdd.iterator();
            while (iterator.hasNext()) {
                int amount;
                ItemStack itemStack = iterator.next();
                if (player.field_71071_by.field_70462_a[i] == null) {
                    amount = Math.min(itemStack.func_77976_d(), itemStack.field_77994_a);
                    ItemStack copy = itemStack.func_77946_l();
                    copy.field_77994_a = amount;
                    player.field_71071_by.field_70462_a[i] = copy;
                    itemStack.field_77994_a -= amount;
                    if (itemStack.field_77994_a > 0) continue block0;
                    iterator.remove();
                    continue block0;
                }
                if (!player.field_71071_by.field_70462_a[i].func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)player.field_71071_by.field_70462_a[i])) continue;
                amount = Math.min(itemStack.func_77976_d() - player.field_71071_by.field_70462_a[i].field_77994_a, itemStack.field_77994_a);
                player.field_71071_by.field_70462_a[i].field_77994_a += amount;
                itemStack.field_77994_a -= amount;
                if (itemStack.field_77994_a > 0) continue block0;
                iterator.remove();
                continue block0;
            }
        }
    }

    public void setGuiCenterX(int x) {
        this.x = x - this.getGuiW() / 2;
    }

    public void setGuiCenterY(int y) {
        this.y = y - this.getGuiH() / 2;
    }

    public void setBigIcon(boolean b) {
        this.isBig = b;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
        this.cachedDescription = null;
    }

    public void setItem(GuiEditMenuItem.Element element, int id, GuiEditMenuItem.Type type, ItemPrecision precision, EntityPlayer player) {
        if (type == GuiEditMenuItem.Type.REWARD || type == GuiEditMenuItem.Type.PICK_REWARD) {
            ItemStack itemStack;
            if (element instanceof GuiEditMenuItem.ElementItem && (itemStack = (ItemStack)((GuiEditMenuItem.ElementItem)element).getItem()) != null) {
                itemStack.field_77994_a = Math.min(127, element.getAmount());
                this.setReward(itemStack, id, type == GuiEditMenuItem.Type.REWARD);
            }
        } else if (this.selectedTask != null && this.selectedTask instanceof QuestTaskItems) {
            ((QuestTaskItems)this.selectedTask).setItem(element, id, precision);
        } else if (this.selectedTask != null && this.selectedTask instanceof QuestTaskLocation && type == GuiEditMenuItem.Type.LOCATION) {
            ((QuestTaskLocation)this.selectedTask).setIcon(id, (ItemStack)element.getItem(), player);
        } else if (this.selectedTask != null && this.selectedTask instanceof QuestTaskMob && type == GuiEditMenuItem.Type.MOB) {
            ((QuestTaskMob)this.selectedTask).setIcon(id, (ItemStack)element.getItem(), player);
        }
    }

    private void setReward(ItemStack itemStack, int id, boolean isStandardReward) {
        ItemStack[] reward;
        ItemStack[] itemStackArray = reward = isStandardReward ? this.reward : this.rewardChoice;
        if (reward != null && id < reward.length) {
            reward[id] = itemStack;
        } else if (reward == null) {
            if (isStandardReward) {
                this.reward = new ItemStack[]{itemStack};
            } else {
                this.rewardChoice = new ItemStack[]{itemStack};
            }
        } else {
            ItemStack[] newRewardList = Arrays.copyOf(reward, reward.length + 1);
            newRewardList[newRewardList.length - 1] = itemStack;
            if (isStandardReward) {
                this.reward = newRewardList;
            } else {
                this.rewardChoice = newRewardList;
            }
        }
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
        if (icon != null) {
            icon.field_77994_a = 1;
        }
    }

    public boolean hasSameSetAs(Quest child) {
        return child.set.equals(this.set);
    }

    @SideOnly(value=Side.CLIENT)
    public void onScroll(GuiQuestBook gui, int x, int y, int scroll) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onScroll(gui, x, y, scroll);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onOpen(GuiQuestBook gui, EntityPlayer player) {
        if (this.selectedTask == null) {
            for (QuestTask task : this.tasks) {
                if (task.isCompleted(player)) continue;
                this.selectedTask = task;
                break;
            }
        }
        if (this.selectedTask == null && this.tasks.size() > 0) {
            this.selectedTask = this.tasks.get(0);
        }
    }

    public boolean hasSet(QuestSet selectedSet) {
        return this.set.equals(selectedSet);
    }

    public void mergeProgress(String playerName, QuestData own, QuestData other) {
        if (other.completed) {
            own.completed = true;
            if (other.available) {
                own.available = true;
            }
        }
        for (int i = 0; i < own.tasks.length; ++i) {
            QuestTask task = this.tasks.get(i);
            own.tasks[i] = task.validateData(own.tasks[i]);
            task.mergeProgress(playerName, own.tasks[i], task.validateData(other.tasks[i]));
        }
    }

    public void copyProgress(QuestData own, QuestData other) {
        own.completed = other.completed;
        own.available = other.available;
        for (int i = 0; i < own.tasks.length; ++i) {
            QuestTask task = this.tasks.get(i);
            own.tasks[i] = task.validateData(own.tasks[i]);
            task.copyProgress(own.tasks[i], task.validateData(other.tasks[i]));
        }
    }

    public void completeQuest(EntityPlayer player) {
        for (QuestTask task : this.tasks) {
            task.autoComplete(QuestingData.getUserName(player));
            task.getData((EntityPlayer)player).completed = true;
        }
        QuestTask.completeQuest(this, QuestingData.getUserName(player));
    }

    public void reset(String playerName) {
        this.reset(this.getQuestData(playerName));
    }

    public void reset(QuestData data) {
        data.available = true;
        this.addTaskData(data);
    }

    public void resetAll() {
        for (Team team : QuestingData.getAllTeams()) {
            QuestData data = team.getQuestData(this.id);
            if (data == null || data.available) continue;
            this.reset(data);
            this.sendUpdatedDataToTeam(team);
        }
    }

    public void resetOnTime(int time) {
        for (Team team : QuestingData.getAllTeams()) {
            QuestData data = team.getQuestData(this.id);
            if (data == null || data.available || data.time > time) continue;
            this.reset(data);
            this.sendUpdatedDataToTeam(team);
        }
    }

    public float getProgress(Team team) {
        String name = team.getPlayers().get(0).getName();
        float data = 0.0f;
        for (QuestTask task : this.tasks) {
            data += task.getCompletedRatio(name);
        }
        return data / (float)this.tasks.size();
    }

    public List<Quest> getOptionLinks() {
        return this.optionLinks;
    }

    public List<Quest> getReversedOptionLinks() {
        return this.reversedOptionLinks;
    }

    public static void saveAll(DataWriter dw) {
        dw.writeString(QuestLine.getActiveQuestLine().mainDescription, DataBitHelper.QUEST_DESCRIPTION_LENGTH);
        dw.writeData(QuestLine.getActiveQuestLine().questSets.size(), DataBitHelper.QUEST_SETS);
        for (QuestSet questSet : QuestLine.getActiveQuestLine().questSets) {
            dw.writeString(questSet.getName(), DataBitHelper.QUEST_NAME_LENGTH);
            dw.writeString(questSet.getDescription(), DataBitHelper.QUEST_DESCRIPTION_LENGTH);
        }
        dw.writeData(Quest.size(), DataBitHelper.QUESTS);
        for (int id = 0; id < Quest.size(); ++id) {
            Quest quest = Quest.getQuest(id);
            dw.writeBoolean(quest != null);
            if (quest == null) continue;
            dw.writeString(quest.getName(), DataBitHelper.QUEST_NAME_LENGTH);
            dw.writeString(quest.getDescription(), DataBitHelper.QUEST_DESCRIPTION_LENGTH);
            dw.writeData(quest.getGuiX(), DataBitHelper.QUEST_POS_X);
            dw.writeData(quest.getGuiY(), DataBitHelper.QUEST_POS_Y);
            dw.writeBoolean(quest.useBigIcon());
            dw.writeData(quest.set.getId(), DataBitHelper.QUEST_SETS);
            if (quest.getIcon() != null) {
                dw.writeBoolean(true);
                dw.writeData(quest.getIcon().field_77993_c, DataBitHelper.SHORT);
                dw.writeData(quest.getIcon().func_77960_j(), DataBitHelper.SHORT);
                dw.writeNBT(quest.getIcon().func_77978_p());
            } else {
                dw.writeBoolean(false);
            }
            dw.writeBoolean(!quest.requirement.isEmpty());
            if (!quest.requirement.isEmpty()) {
                dw.writeData(quest.requirement.size(), DataBitHelper.QUESTS);
                for (Quest required : quest.requirement) {
                    dw.writeData((int)required.getId(), DataBitHelper.QUESTS);
                }
            }
            dw.writeBoolean(!quest.optionLinks.isEmpty());
            if (!quest.optionLinks.isEmpty()) {
                dw.writeData(quest.optionLinks.size(), DataBitHelper.QUESTS);
                for (Quest optionLink : quest.optionLinks) {
                    dw.writeData((int)optionLink.getId(), DataBitHelper.QUESTS);
                }
            }
            quest.getRepeatInfo().save(dw);
            dw.writeData(quest.triggerType.ordinal(), DataBitHelper.TRIGGER_TYPE);
            if (quest.triggerType.isUseTaskCount()) {
                dw.writeData(quest.triggerTasks, DataBitHelper.TASKS);
            }
            dw.writeData(quest.tasks.size(), DataBitHelper.TASKS);
            for (int i = 0; i < quest.tasks.size(); ++i) {
                QuestTask task = quest.tasks.get(i);
                int type = -1;
                for (int j = 0; j < taskTypes.length; ++j) {
                    if (taskTypes[j].clazz != task.getClass()) continue;
                    type = j;
                    break;
                }
                dw.writeData(type, DataBitHelper.TASK_TYPE);
                dw.writeString(task.getDescription(), DataBitHelper.QUEST_NAME_LENGTH);
                dw.writeString(task.getLongDescription(), DataBitHelper.QUEST_DESCRIPTION_LENGTH);
                task.save(dw);
            }
            Quest.writeRewardData(dw, quest.reward);
            Quest.writeRewardData(dw, quest.rewardChoice);
        }
        GroupTier.saveAll(dw);
        Group.saveAll(dw);
    }

    private static void writeRewardData(DataWriter dw, ItemStack[] reward) {
        dw.writeBoolean(reward != null);
        if (reward != null) {
            int count = 0;
            for (ItemStack itemStack : reward) {
                if (itemStack == null) continue;
                ++count;
            }
            dw.writeData(count, DataBitHelper.REWARDS);
            for (ItemStack itemStack : reward) {
                if (itemStack == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                itemStack.func_77955_b(compound);
                dw.writeNBT(compound);
            }
        }
    }

    public static void loadAll(DataReader dr, FileVersion version) {
        if (dr != null) {
            try {
                String description;
                String name;
                QuestLine.getActiveQuestLine().mainDescription = version.lacks(FileVersion.LORE) ? "No description" : dr.readString(DataBitHelper.QUEST_DESCRIPTION_LENGTH);
                if (version.lacks(FileVersion.SETS)) {
                    QuestLine.getActiveQuestLine().questSets.add(new QuestSet("Automatically generated", "This set was automatically generated. All your quests were put in this one."));
                } else {
                    int setCount = dr.readData(DataBitHelper.QUEST_SETS);
                    for (int i = 0; i < setCount; ++i) {
                        name = dr.readString(DataBitHelper.QUEST_NAME_LENGTH);
                        description = dr.readString(DataBitHelper.QUEST_DESCRIPTION_LENGTH);
                        QuestLine.getActiveQuestLine().questSets.add(new QuestSet(name, description));
                    }
                }
                int count = dr.readData(DataBitHelper.QUESTS);
                for (int id = 0; id < count; ++id) {
                    int i;
                    if (!dr.readBoolean()) continue;
                    name = dr.readString(DataBitHelper.QUEST_NAME_LENGTH);
                    description = dr.readString(DataBitHelper.QUEST_DESCRIPTION_LENGTH);
                    int x = dr.readData(DataBitHelper.QUEST_POS_X);
                    int y = dr.readData(DataBitHelper.QUEST_POS_Y);
                    boolean big = dr.readBoolean();
                    Quest quest = new Quest(id, name, description, x, y, big);
                    if (version.lacks(FileVersion.SETS)) {
                        quest.setQuestSet(QuestLine.getActiveQuestLine().questSets.get(0));
                    } else {
                        int setId = dr.readData(DataBitHelper.QUEST_SETS);
                        quest.setQuestSet(QuestLine.getActiveQuestLine().questSets.get(setId));
                    }
                    if (version.contains(FileVersion.SETS) && dr.readBoolean()) {
                        int iconId = dr.readData(DataBitHelper.SHORT);
                        int iconDmg = dr.readData(DataBitHelper.SHORT);
                        NBTTagCompound iconCompound = dr.readNBT();
                        ItemStack icon = new ItemStack(iconId, 1, iconDmg);
                        icon.func_77982_d(iconCompound);
                        quest.setIcon(icon);
                    } else {
                        quest.setIcon(null);
                    }
                    if (dr.readBoolean()) {
                        quest.requirementIds = new ArrayList<Integer>();
                        int requirementCount = dr.readData(DataBitHelper.QUESTS);
                        for (i = 0; i < requirementCount; ++i) {
                            quest.requirementIds.add(dr.readData(DataBitHelper.QUESTS));
                        }
                    }
                    if (version.contains(FileVersion.OPTION_LINKS) && dr.readBoolean()) {
                        quest.optionLinkIds = new ArrayList<Integer>();
                        int optionLinkCount = dr.readData(DataBitHelper.QUESTS);
                        for (i = 0; i < optionLinkCount; ++i) {
                            quest.optionLinkIds.add(dr.readData(DataBitHelper.QUESTS));
                        }
                    }
                    quest.getRepeatInfo().load(dr, version);
                    if (version.contains(FileVersion.TRIGGER_QUESTS)) {
                        quest.triggerType = TriggerType.values()[dr.readData(DataBitHelper.TRIGGER_TYPE)];
                        if (quest.triggerType.isUseTaskCount()) {
                            quest.triggerTasks = dr.readData(DataBitHelper.TASKS);
                        }
                    }
                    int tasks = dr.readData(DataBitHelper.TASKS);
                    for (i = 0; i < tasks; ++i) {
                        int type = dr.readData(DataBitHelper.TASK_TYPE);
                        String taskName = dr.readString(DataBitHelper.QUEST_NAME_LENGTH);
                        String taskDescription = dr.readString(DataBitHelper.QUEST_DESCRIPTION_LENGTH);
                        try {
                            Class clazz = taskTypes[type].clazz;
                            Constructor constructor = clazz.getConstructor(Quest.class, String.class, String.class);
                            Object obj = constructor.newInstance(quest, taskName, taskDescription);
                            QuestTask task = (QuestTask)obj;
                            task.load(dr, version);
                            if (quest.tasks.size() > 0) {
                                task.addRequirement(quest.tasks.get(quest.tasks.size() - 1));
                            }
                            quest.tasks.add(task);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    quest.reward = Quest.readRewardData(dr);
                    quest.rewardChoice = Quest.readRewardData(dr);
                }
                for (Quest quest : QuestLine.getActiveQuestLine().quests.values()) {
                    if (quest.requirementIds != null) {
                        for (Integer requirementId : quest.requirementIds) {
                            quest.addRequirement(requirementId);
                        }
                    }
                    if (quest.optionLinkIds == null) continue;
                    for (Integer optionLinkId : quest.optionLinkIds) {
                        quest.addOptionLink(optionLinkId);
                    }
                }
                if (version.contains(FileVersion.BAGS)) {
                    GroupTier.readAll(dr, version);
                    Group.readAll(dr, version);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static ItemStack[] readRewardData(DataReader dr) {
        if (dr.readBoolean()) {
            int count = dr.readData(DataBitHelper.REWARDS);
            ItemStack[] reward = new ItemStack[count];
            for (int i = 0; i < reward.length; ++i) {
                NBTTagCompound compound = dr.readNBT();
                if (compound == null) continue;
                reward[i] = ItemStack.func_77949_a((NBTTagCompound)compound);
            }
            return reward;
        }
        return null;
    }

    public static void init(final String path) {
        FILE_HELPER = new FileHelper(){
            private boolean isUnLocked = true;
            private File file = new File(path + "quests.hqm");
            private File lock = new File(path + "lock.txt");

            @Override
            public boolean loadData(File file) {
                return super.loadData(this.file);
            }

            @Override
            public FileHelper.SaveResult saveData(File file) {
                return super.saveData(this.file);
            }

            @Override
            public void write(DataWriter dw) {
                String lockCode = this.readCode();
                dw.writeString(lockCode, DataBitHelper.PASS_CODE);
                Quest.saveAll(dw);
            }

            @Override
            public void read(DataReader dr, FileVersion version) {
                String code;
                this.isUnLocked = false;
                String string = code = version.lacks(FileVersion.LOCK) ? null : dr.readString(DataBitHelper.PASS_CODE);
                if (code == null || code.equals(this.readCode())) {
                    this.isUnLocked = true;
                }
                if (!isEditing || this.isUnLocked) {
                    Quest.loadAll(dr, version);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String readCode() {
                if (this.lock.exists()) {
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new FileReader(this.lock));
                        String str = br.readLine();
                        String string = str.substring(0, Math.min(DataBitHelper.PASS_CODE.getMaximum(), str.length()));
                        return string;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        String string = null;
                        return string;
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException ignored) {}
                        }
                    }
                }
                return null;
            }
        };
        QuestLine.getActiveQuestLine().mainPath = path;
        QuestLine.getActiveQuestLine().quests = new HashMap<Short, Quest>();
        QuestLine.getActiveQuestLine().questSets = new ArrayList<QuestSet>();
        FILE_HELPER.loadData(null);
    }

    public static void removeQuest(Quest quest) {
        for (Quest requirement : quest.requirement) {
            requirement.reversedRequirement.remove(quest);
        }
        for (Quest optionLink : quest.optionLinks) {
            optionLink.reversedOptionLinks.remove(quest);
        }
        for (QuestTask task : quest.tasks) {
            task.onDelete();
        }
        quest.setQuestSet(null);
        QuestLine.getActiveQuestLine().quests.remove(quest.getId());
        for (Quest other : QuestLine.getActiveQuestLine().quests.values()) {
            Quest element;
            Iterator<Quest> iterator = other.requirement.iterator();
            while (iterator.hasNext()) {
                element = iterator.next();
                if (element.getId() != quest.getId()) continue;
                iterator.remove();
            }
            iterator = other.optionLinks.iterator();
            while (iterator.hasNext()) {
                element = iterator.next();
                if (element.getId() != quest.getId()) continue;
                iterator.remove();
            }
        }
    }

    public QuestSet getQuestSet() {
        return this.set;
    }

    public void setQuestSet(QuestSet set) {
        if (this.set != null) {
            this.set.removeQuest(this);
        }
        this.set = set;
        if (this.set != null) {
            this.set.addQuest(this);
        }
    }

    public List<Quest> getReversedRequirement() {
        return this.reversedRequirement;
    }

    static {
        taskTypes = new TaskType[]{new TaskType(QuestTaskItemsConsume.class, "Consume task", "A task where the player can hand in items or fluids. One can also use the Quest Delivery System to submit items and fluids."), new TaskType(QuestTaskItemsCrafting.class, "Crafting task", "A task where the player has to craft specific items."), new TaskType(QuestTaskLocation.class, "Location task", "A task where the player has to reach one or more locations."), new TaskType(QuestTaskItemsConsumeQDS.class, "QDS task", "A task where the player can hand in items or fluids. This is a normal consume task where manual submit has been disabled to teach the player about the QDS"), new TaskType(QuestTaskItemsDetect.class, "Detection task", "A task where the player needs specific items. These do not have to be handed in, having them in one's inventory is enough."), new TaskType(QuestTaskMob.class, "Killing task", "A task where the player has to kill certain monsters."), new TaskType(QuestTaskDeath.class, "Death task", "A task where the player has to die a certain amount of times.")};
    }

    private static class TaskType {
        private final Class<? extends QuestTask> clazz;
        private final String name;
        public final String description;

        private TaskType(Class<? extends QuestTask> clazz, String name, String description) {
            this.clazz = clazz;
            this.name = name;
            this.description = description;
        }
    }
}

