/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.network;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import hardcorequesting.network.DataBitHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;

public class DataWriter {
    private OutputStream stream;
    private int byteBuffer;
    private int bitCountBuffer;
    private int bits;
    private static final int MAX_PACKET_SIZE = 32766;
    private DataBitHelper bufferSize;
    private DataWriter buffer;

    DataWriter() {
        this.stream = new ByteArrayOutputStream();
    }

    DataWriter(OutputStream stream) {
        this.stream = stream;
    }

    public void writeByte(int data) {
        this.writeData(data, DataBitHelper.BYTE);
    }

    public void writeBoolean(boolean data) {
        this.writeData(data ? 1 : 0, DataBitHelper.BOOLEAN);
    }

    public void writeData(int data, DataBitHelper bitCount) {
        this.writeData(data, bitCount.getBitCount());
    }

    public void writeData(int data, int bitCount) {
        if (this.buffer != null) {
            this.buffer.writeData(data, bitCount);
            return;
        }
        this.bits += bitCount;
        long mask = (long)Math.pow(2.0, bitCount) - 1L;
        data = (int)((long)data & mask);
        while (this.bitCountBuffer + bitCount >= 8) {
            int bitsToAdd = 8 - this.bitCountBuffer;
            int addMask = (int)Math.pow(2.0, bitsToAdd) - 1;
            int addData = data & addMask;
            data >>>= bitsToAdd;
            this.byteBuffer |= (addData <<= this.bitCountBuffer);
            try {
                this.stream.write(this.byteBuffer);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            this.byteBuffer = 0;
            bitCount -= bitsToAdd;
            this.bitCountBuffer = 0;
        }
        this.byteBuffer |= data << this.bitCountBuffer;
        this.bitCountBuffer += bitCount;
    }

    void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeString(String str, DataBitHelper bits) {
        if (str != null) {
            byte[] bytes = str.getBytes();
            int l = Math.min(bytes.length, bits.getMaximum());
            this.writeData(l, bits);
            for (int i = 0; i < l; ++i) {
                this.writeByte(bytes[i]);
            }
        } else {
            this.writeData(0, bits);
        }
    }

    public void writeNBT(NBTTagCompound nbtTagCompound) {
        byte[] bytes = null;
        if (nbtTagCompound != null) {
            try {
                bytes = CompressedStreamTools.func_74798_a((NBTTagCompound)nbtTagCompound);
            }
            catch (IOException ex) {
                bytes = null;
            }
        }
        this.writeBoolean(bytes != null);
        if (bytes != null) {
            this.writeData(bytes.length, DataBitHelper.NBT_LENGTH);
            for (byte b : bytes) {
                this.writeByte(b);
            }
        }
    }

    void sendToPlayer(Player player) {
        this.writeFinalBits();
        byte[] bytes = ((ByteArrayOutputStream)this.stream).toByteArray();
        if (bytes.length < 32766) {
            this.sendBytesToPlayer(bytes, player);
        } else {
            int packets = (int)Math.ceil((float)bytes.length / 32766.0f);
            bytes[0] = (byte)packets;
            for (int i = 0; i < packets; ++i) {
                int start = i * 32766;
                int len = Math.min(32766, bytes.length - start);
                byte[] packetBytes = new byte[len];
                System.arraycopy(bytes, start, packetBytes, 0, len);
                this.sendBytesToPlayer(packetBytes, player);
            }
        }
    }

    private void sendBytesToPlayer(byte[] bytes, Player player) {
        PacketDispatcher.sendPacketToPlayer((Packet)PacketDispatcher.getPacket((String)"hcQuesting", (byte[])bytes), (Player)player);
    }

    void writeFinalBits() {
        if (this.bitCountBuffer > 0) {
            try {
                this.stream.write(this.byteBuffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bitCountBuffer = 0;
        }
    }

    public void sendToServer() {
        this.writeFinalBits();
        PacketDispatcher.sendPacketToServer((Packet)PacketDispatcher.getPacket((String)"hcQuesting", (byte[])((ByteArrayOutputStream)this.stream).toByteArray()));
    }

    public void sendToAllPlayers() {
        this.writeFinalBits();
        PacketDispatcher.sendPacketToAllPlayers((Packet)PacketDispatcher.getPacket((String)"hcQuesting", (byte[])((ByteArrayOutputStream)this.stream).toByteArray()));
    }

    public void sendToAllPlayersAround(TileEntity te, double range) {
        this.writeFinalBits();
        PacketDispatcher.sendPacketToAllAround((double)((double)te.field_70329_l + 0.5), (double)((double)te.field_70330_m + 0.5), (double)((double)te.field_70327_n + 0.5), (double)range, (int)te.field_70331_k.field_73011_w.field_76574_g, (Packet)PacketDispatcher.getPacket((String)"hcQuesting", (byte[])((ByteArrayOutputStream)this.stream).toByteArray()));
    }

    public void createBuffer(DataBitHelper bits) {
        this.buffer = new DataWriter();
        this.bufferSize = bits;
    }

    public void flushBuffer() {
        DataWriter buffer = this.buffer;
        this.buffer = null;
        buffer.writeFinalBits();
        int count = buffer.bits;
        byte[] bytes = ((ByteArrayOutputStream)buffer.stream).toByteArray();
        this.writeData(count, this.bufferSize);
        this.bufferSize = null;
        for (byte b : bytes) {
            int bitCount = Math.min(8, count);
            count -= bitCount;
            this.writeData((int)b, bitCount);
        }
        buffer.close();
    }
}

