/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.network;

import hardcorequesting.FileVersion;
import hardcorequesting.QuestingData;
import hardcorequesting.network.DataBitHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class DataReader {
    private InputStream stream;
    private int byteBuffer;
    private int bitCountBuffer;
    private FileVersion version;

    DataReader(byte[] data) {
        this.stream = new ByteArrayInputStream(data);
        this.version = QuestingData.FILE_VERSION;
    }

    DataReader(InputStream stream) {
        this.stream = stream;
        this.version = QuestingData.FILE_VERSION;
    }

    public int readByte() {
        return this.readData(DataBitHelper.BYTE);
    }

    public boolean readBoolean() {
        return this.readData(DataBitHelper.BOOLEAN) != 0;
    }

    public int readData(DataBitHelper bitCount) {
        return this.readData(bitCount.getBitCount(this.version));
    }

    public int readData(int bitCount) {
        int data = 0;
        int readBits = 0;
        while (true) {
            int bitsLeft;
            if (this.bitCountBuffer >= (bitsLeft = bitCount - readBits)) {
                data |= (this.byteBuffer & (int)Math.pow(2.0, bitsLeft) - 1) << readBits;
                this.byteBuffer >>>= bitsLeft;
                this.bitCountBuffer -= bitsLeft;
                readBits += bitsLeft;
                break;
            }
            data |= this.byteBuffer << readBits;
            readBits += this.bitCountBuffer;
            try {
                this.byteBuffer = this.stream.read();
            }
            catch (IOException ignored) {
                this.byteBuffer = 0;
            }
            this.bitCountBuffer = 8;
        }
        return data;
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String readString(DataBitHelper bits) {
        int length = this.readData(bits);
        if (length == 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.readByte();
        }
        return new String(bytes);
    }

    public NBTTagCompound readNBT() {
        if (this.readBoolean()) {
            byte[] bytes = new byte[this.readData(DataBitHelper.NBT_LENGTH)];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)this.readByte();
            }
            try {
                return CompressedStreamTools.func_74792_a((byte[])bytes);
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public boolean doesUnderlyingStreamHasMoreThanAByteOfData() {
        try {
            return this.stream.available() > 0;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public FileVersion readVersion() {
        this.version = FileVersion.values()[this.readByte()];
        return this.version;
    }
}

